/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.wrappers.io;

public class MultiBufferVO {
    private int numberOfBuffers;
    private int bufferSize;
    public byte[][] buffers;
    protected long[] creations;
    public long[] bufferStartPosition;
    public long[] bufferEndPosition;
    public int[] maxPositionInBuffer;
    private boolean[] bufferHasBeenUsedForWrite;

    public MultiBufferVO(int numberOfBuffers, int bufferSize) {
        this.numberOfBuffers = numberOfBuffers;
        this.bufferSize = bufferSize;
        this.buffers = new byte[numberOfBuffers][bufferSize];
        this.bufferStartPosition = new long[numberOfBuffers];
        this.bufferEndPosition = new long[numberOfBuffers];
        this.maxPositionInBuffer = new int[numberOfBuffers];
        this.creations = new long[numberOfBuffers];
        this.bufferHasBeenUsedForWrite = new boolean[numberOfBuffers];
    }

    public byte[] getBuffer2(int index) {
        return this.buffers[index];
    }

    public byte getByte(int bufferIndex, int byteIndex) {
        return this.buffers[bufferIndex][byteIndex];
    }

    public void clearBuffer(int bufferIndex) {
        byte[] buffer = this.buffers[bufferIndex];
        int maxPosition = this.maxPositionInBuffer[bufferIndex];
        for (int i = 0; i < maxPosition; ++i) {
            buffer[i] = 0;
        }
        this.bufferStartPosition[bufferIndex] = 0L;
        this.bufferEndPosition[bufferIndex] = 0L;
        this.maxPositionInBuffer[bufferIndex] = 0;
        this.bufferHasBeenUsedForWrite[bufferIndex] = false;
    }

    public void setByte(int bufferIndex, int positionInBuffer, byte b) {
        if (this.buffers[bufferIndex] == null) {
            this.buffers[bufferIndex] = new byte[this.bufferSize];
        }
        this.buffers[bufferIndex][positionInBuffer] = b;
        this.bufferHasBeenUsedForWrite[bufferIndex] = true;
        if (positionInBuffer > this.maxPositionInBuffer[bufferIndex]) {
            this.maxPositionInBuffer[bufferIndex] = positionInBuffer;
        }
    }

    public int getBufferIndexForPosition(long position, int size) {
        long max = position + (long)size;
        for (int i = 0; i < this.numberOfBuffers; ++i) {
            if (max > this.bufferEndPosition[i] || position < this.bufferStartPosition[i]) continue;
            return i;
        }
        return -1;
    }

    public void setCreationDate(int bufferIndex, long currentTimeInMs) {
        this.creations[bufferIndex] = currentTimeInMs;
    }

    public void setPositions(int bufferIndex, long startPosition, long endPosition, int maxPosition) {
        this.bufferStartPosition[bufferIndex] = startPosition;
        this.bufferEndPosition[bufferIndex] = endPosition;
        this.maxPositionInBuffer[bufferIndex] = maxPosition;
    }

    private void clear(int bufferIndex, int position) {
        byte[] buffer = this.buffers[bufferIndex];
        for (int i = 0; i < position; ++i) {
            buffer[i] = 0;
        }
        this.bufferStartPosition[bufferIndex] = 0L;
        this.bufferEndPosition[bufferIndex] = 0L;
        this.maxPositionInBuffer[bufferIndex] = 0;
        this.bufferHasBeenUsedForWrite[bufferIndex] = false;
    }

    public void writeBytes(int bufferIndex, byte[] bytes, int startIndex, int offsetWhereToCopy, int lengthToCopy) {
        System.arraycopy(bytes, startIndex, this.buffers[bufferIndex], offsetWhereToCopy, lengthToCopy);
        this.bufferHasBeenUsedForWrite[bufferIndex] = true;
        int positionInBuffer = offsetWhereToCopy + lengthToCopy - 1;
        if (positionInBuffer > this.maxPositionInBuffer[bufferIndex]) {
            this.maxPositionInBuffer[bufferIndex] = positionInBuffer;
        }
    }

    public boolean hasBeenUsedForWrite(int bufferIndex) {
        return this.bufferHasBeenUsedForWrite[bufferIndex];
    }

    public void clear() {
        this.buffers = null;
        this.bufferStartPosition = null;
        this.bufferEndPosition = null;
        this.maxPositionInBuffer = null;
        this.bufferHasBeenUsedForWrite = null;
    }

    public long getCreationDate(int bufferIndex) {
        return this.creations[bufferIndex];
    }
}

