/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.wap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WbxmlParser
implements XmlPullParser {
    public static final int WAP_EXTENSION = 64;
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    private static final String ILLEGAL_TYPE = "Wrong event type";
    private InputStream in;
    private String[] attrStartTable;
    private String[] attrValueTable;
    private String[] tagTable;
    private String stringTable;
    private boolean processNsp;
    private int depth;
    private String[] elementStack = new String[16];
    private String[] nspStack = new String[8];
    private int[] nspCounts = new int[4];
    private int attributeCount;
    private String[] attributes = new String[16];
    private int nextId = -2;
    int version;
    int publicIdentifierId;
    int charSet;
    private String prefix;
    private String namespace;
    private String name;
    private String text;
    private Object wapExtensionData;
    private int wapExtensionCode;
    private int type;
    private boolean degenerated;
    private boolean isWhitespace;

    public boolean getFeature(String string) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string)) {
            return this.processNsp;
        }
        return false;
    }

    public String getInputEncoding() {
        return null;
    }

    public void defineEntityReplacementText(String string, String string2) throws XmlPullParserException {
    }

    public Object getProperty(String string) {
        return null;
    }

    public int getNamespaceCount(int n) {
        if (n > this.depth) {
            throw new IndexOutOfBoundsException();
        }
        return this.nspCounts[n];
    }

    public String getNamespacePrefix(int n) {
        return this.nspStack[n << 1];
    }

    public String getNamespaceUri(int n) {
        return this.nspStack[(n << 1) + 1];
    }

    public String getNamespace(String string) {
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        int n = (this.getNamespaceCount(this.depth) << 1) - 2;
        while (n >= 0) {
            if (string == null ? this.nspStack[n] == null : string.equals(this.nspStack[n])) {
                return this.nspStack[n + 1];
            }
            n -= 2;
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.type < XmlPullParser.TYPES.length ? XmlPullParser.TYPES[this.type] : "unknown");
        stringBuffer.append(' ');
        if (this.type == 2 || this.type == 3) {
            if (this.degenerated) {
                stringBuffer.append("(empty) ");
            }
            stringBuffer.append('<');
            if (this.type == 3) {
                stringBuffer.append('/');
            }
            if (this.prefix != null) {
                stringBuffer.append("{" + this.namespace + "}" + this.prefix + ":");
            }
            stringBuffer.append(this.name);
            int n = this.attributeCount << 2;
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                if (this.attributes[n2 + 1] != null) {
                    stringBuffer.append("{" + this.attributes[n2] + "}" + this.attributes[n2 + 1] + ":");
                }
                stringBuffer.append(this.attributes[n2 + 2] + "='" + this.attributes[n2 + 3] + "'");
                n2 += 4;
            }
            stringBuffer.append('>');
        } else if (this.type != 7) {
            if (this.type != 4) {
                stringBuffer.append(this.getText());
            } else if (this.isWhitespace) {
                stringBuffer.append("(whitespace)");
            } else {
                String string = this.getText();
                if (string.length() > 16) {
                    string = string.substring(0, 16) + "...";
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.type != 4 && this.type != 7 && this.type != 5) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.isWhitespace;
    }

    public String getText() {
        return this.text;
    }

    public char[] getTextCharacters(int[] nArray) {
        if (this.type >= 4) {
            nArray[0] = 0;
            nArray[1] = this.text.length();
            char[] cArray = new char[this.text.length()];
            this.text.getChars(0, this.text.length(), cArray, 0);
            return cArray;
        }
        nArray[0] = -1;
        nArray[1] = -1;
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.type != 2) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.degenerated;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public String getAttributeType(int n) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int n) {
        return false;
    }

    public String getAttributeNamespace(int n) {
        if (n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[n << 2];
    }

    public String getAttributeName(int n) {
        if (n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n << 2) + 2];
    }

    public String getAttributePrefix(int n) {
        if (n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n << 2) + 1];
    }

    public String getAttributeValue(int n) {
        if (n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n << 2) + 3];
    }

    public String getAttributeValue(String string, String string2) {
        int n = (this.attributeCount << 2) - 4;
        while (n >= 0) {
            if (this.attributes[n + 2].equals(string2) && (string == null || this.attributes[n].equals(string))) {
                return this.attributes[n + 3];
            }
            n -= 4;
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.type;
    }

    public int next() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        int n = 9999;
        block3: while (true) {
            String string = this.text;
            this.nextImpl();
            if (this.type < n) {
                n = this.type;
            }
            if (n > 5) continue;
            if (n < 4) break;
            if (string != null) {
                this.text = this.text != null ? string : string + this.text;
            }
            switch (this.peekId()) {
                case 2: 
                case 3: 
                case 4: 
                case 68: 
                case 132: 
                case 196: {
                    continue block3;
                }
            }
            break;
        }
        this.type = n;
        if (this.type > 4) {
            this.type = 4;
        }
        return this.type;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        this.nextImpl();
        return this.type;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.type == 4 && this.isWhitespace) {
            this.next();
        }
        if (this.type != 3 && this.type != 2) {
            this.exception("unexpected type");
        }
        return this.type;
    }

    public String nextText() throws XmlPullParserException, IOException {
        String string;
        if (this.type != 2) {
            this.exception("precondition: START_TAG");
        }
        this.next();
        if (this.type == 4) {
            string = this.getText();
            this.next();
        } else {
            string = "";
        }
        if (this.type != 3) {
            this.exception("END_TAG expected");
        }
        return string;
    }

    public void require(int n, String string, String string2) throws XmlPullParserException, IOException {
        if (n != this.type || string != null && !string.equals(this.getNamespace()) || string2 != null && !string2.equals(this.getName())) {
            this.exception("expected: " + XmlPullParser.TYPES[n] + " {" + string + "}" + string2);
        }
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.exception("InputStream required");
    }

    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        this.in = inputStream;
        try {
            this.version = this.readByte();
            this.publicIdentifierId = this.readInt();
            if (this.publicIdentifierId == 0) {
                this.readInt();
            }
            this.charSet = this.readInt();
            int n = this.readInt();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append((char)this.readByte());
                ++n2;
            }
            this.stringTable = stringBuffer.toString();
        }
        catch (IOException iOException) {
            this.exception("Illegal input format");
        }
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string)) {
            this.processNsp = bl;
        } else {
            this.exception("unsupported feature: " + string);
        }
    }

    public void setProperty(String string, Object object) throws XmlPullParserException {
        throw new XmlPullParserException("unsupported property: " + string);
    }

    private final boolean adjustNsp() throws XmlPullParserException {
        int n;
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.attributeCount << 2) {
            block21: {
                String string;
                String string2;
                block20: {
                    block19: {
                        string2 = this.attributes[n2 + 2];
                        int n3 = string2.indexOf(58);
                        if (n3 == -1) break block19;
                        string = string2.substring(0, n3);
                        string2 = string2.substring(n3 + 1);
                        break block20;
                    }
                    if (!string2.equals("xmlns")) break block21;
                    string = string2;
                    string2 = null;
                }
                if (!string.equals("xmlns")) {
                    bl = true;
                } else {
                    int n4 = this.depth;
                    int n5 = this.nspCounts[n4];
                    this.nspCounts[n4] = n5 + 1;
                    int n6 = n5 << 1;
                    this.nspStack = this.ensureCapacity(this.nspStack, n6 + 2);
                    this.nspStack[n6] = string2;
                    this.nspStack[n6 + 1] = this.attributes[n2 + 3];
                    if (string2 != null && this.attributes[n2 + 3].equals("")) {
                        this.exception("illegal empty namespace");
                    }
                    System.arraycopy(this.attributes, n2 + 4, this.attributes, n2, (--this.attributeCount << 2) - n2);
                    n2 -= 4;
                }
            }
            n2 += 4;
        }
        if (bl) {
            int n7 = (this.attributeCount << 2) - 4;
            while (n7 >= 0) {
                String string = this.attributes[n7 + 2];
                int n8 = string.indexOf(58);
                if (n8 == 0) {
                    throw new RuntimeException("illegal attribute name: " + string + " at " + this);
                }
                if (n8 != -1) {
                    String string3 = string.substring(0, n8);
                    string = string.substring(n8 + 1);
                    String string4 = this.getNamespace(string3);
                    if (string4 == null) {
                        throw new RuntimeException("Undefined Prefix: " + string3 + " in " + this);
                    }
                    this.attributes[n7] = string4;
                    this.attributes[n7 + 1] = string3;
                    this.attributes[n7 + 2] = string;
                    int n9 = (this.attributeCount << 2) - 4;
                    while (n9 > n7) {
                        if (string.equals(this.attributes[n9 + 2]) && string4.equals(this.attributes[n9])) {
                            this.exception("Duplicate Attribute: {" + string4 + "}" + string);
                        }
                        n9 -= 4;
                    }
                }
                n7 -= 4;
            }
        }
        if ((n = this.name.indexOf(58)) == 0) {
            this.exception("illegal tag name: " + this.name);
        } else if (n != -1) {
            this.prefix = this.name.substring(0, n);
            this.name = this.name.substring(n + 1);
        }
        this.namespace = this.getNamespace(this.prefix);
        if (this.namespace == null) {
            if (this.prefix != null) {
                this.exception("undefined prefix: " + this.prefix);
            }
            this.namespace = "";
        }
        return bl;
    }

    private final void exception(String string) throws XmlPullParserException {
        throw new XmlPullParserException(string, this, null);
    }

    private final void nextImpl() throws IOException, XmlPullParserException {
        if (this.type == 3) {
            --this.depth;
        }
        if (this.degenerated) {
            this.type = 3;
            return;
        }
        this.text = null;
        this.prefix = null;
        this.name = null;
        int n = this.peekId();
        this.nextId = -2;
        switch (n) {
            case -1: {
                this.type = 1;
                break;
            }
            case 0: {
                if (this.readByte() == 0) break;
                throw new IOException("Curr. only CP0 supported");
            }
            case 1: {
                int n2 = this.depth - 1 << 2;
                this.type = 3;
                this.namespace = this.elementStack[n2];
                this.prefix = this.elementStack[n2 + 1];
                this.name = this.elementStack[n2 + 2];
                break;
            }
            case 2: {
                this.type = 6;
                char c = (char)this.readInt();
                this.text = "" + c;
                this.name = "#" + c;
                break;
            }
            case 3: {
                this.type = 4;
                this.text = this.readStrI();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 128: 
            case 129: 
            case 130: 
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                this.parseWapExtension(n);
                break;
            }
            case 67: {
                throw new RuntimeException("PI curr. not supp.");
            }
            case 131: {
                this.type = 4;
                int n3 = this.readInt();
                int n4 = this.stringTable.indexOf(0, n3);
                this.text = this.stringTable.substring(n3, n4);
                break;
            }
            default: {
                this.parseElement(n);
            }
        }
    }

    public void parseWapExtension(int n) throws IOException, XmlPullParserException {
        this.type = 64;
        this.wapExtensionCode = n;
        switch (n) {
            case 64: 
            case 65: 
            case 66: {
                this.wapExtensionData = this.readStrI();
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                this.wapExtensionData = new Integer(this.readInt());
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                break;
            }
            case 195: {
                int n2 = this.readInt();
                byte[] byArray = new byte[n2];
                int n3 = 0;
                while (n3 < n2) {
                    byArray[n3] = (byte)this.readByte();
                    ++n3;
                }
                this.wapExtensionData = byArray;
            }
        }
        throw new IOException("illegal id!");
    }

    public void readAttr() throws IOException {
        int n = this.readByte();
        int n2 = 0;
        while (n != 1) {
            StringBuffer stringBuffer;
            String string = this.resolveId(this.attrStartTable, n);
            int n3 = string.indexOf(61);
            if (n3 == -1) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer = new StringBuffer(string.substring(n3 + 1));
                string = string.substring(0, n3);
            }
            n = this.readByte();
            while (n > 128 || n == 2 || n == 3 || n == 131 || n >= 64 && n <= 66 || n >= 128 && n <= 130) {
                switch (n) {
                    case 2: {
                        stringBuffer.append((char)this.readInt());
                        break;
                    }
                    case 3: {
                        stringBuffer.append(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        throw new RuntimeException("wap extension in attr not supported yet");
                    }
                    case 131: {
                        stringBuffer.append(this.readStrT());
                        break;
                    }
                    default: {
                        stringBuffer.append(this.resolveId(this.attrValueTable, n));
                    }
                }
                n = this.readByte();
            }
            this.attributes = this.ensureCapacity(this.attributes, n2 + 4);
            this.attributes[n2++] = "";
            this.attributes[n2++] = null;
            this.attributes[n2++] = string;
            this.attributes[n2++] = stringBuffer.toString();
        }
    }

    private int peekId() throws IOException {
        if (this.nextId == -2) {
            this.nextId = this.in.read();
        }
        return this.nextId;
    }

    String resolveId(String[] stringArray, int n) throws IOException {
        int n2 = (n & 0x7F) - 5;
        if (n2 == -1) {
            return this.readStrT();
        }
        if (n2 < 0 || stringArray == null || n2 >= stringArray.length || stringArray[n2] == null) {
            throw new IOException("id " + n + " undef.");
        }
        return stringArray[n2];
    }

    void parseElement(int n) throws IOException, XmlPullParserException {
        this.name = this.resolveId(this.tagTable, n & 0x3F);
        if ((n & 0x80) != 0) {
            this.readAttr();
        }
        this.degenerated = (n & 0x40) == 0;
        int n2 = this.depth++ << 2;
        this.elementStack = this.ensureCapacity(this.elementStack, n2 + 4);
        this.elementStack[n2 + 3] = this.name;
        int n3 = this.attributeCount - 1;
        while (n3 > 0) {
            int n4 = 0;
            while (n4 < n3) {
                if (this.getAttributeName(n3).equals(this.getAttributeName(n4))) {
                    this.exception("Duplicate Attribute: " + this.getAttributeName(n3));
                }
                ++n4;
            }
            --n3;
        }
        if (this.processNsp) {
            this.adjustNsp();
        } else {
            this.namespace = "";
        }
        this.elementStack[n2] = this.namespace;
        this.elementStack[n2 + 1] = this.prefix;
        this.elementStack[n2 + 2] = this.name;
    }

    private final String[] ensureCapacity(String[] stringArray, int n) {
        if (stringArray.length >= n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n + 16];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    int readByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new IOException(UNEXPECTED_EOF);
        }
        return n;
    }

    int readInt() throws IOException {
        int n;
        int n2 = 0;
        do {
            n = this.readByte();
            n2 = n2 << 7 | n & 0x7F;
        } while ((n & 0x80) != 0);
        return n2;
    }

    String readStrI() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (true) {
            int n;
            if ((n = this.in.read()) == -1) {
                throw new IOException(UNEXPECTED_EOF);
            }
            if (n == 0) break;
            if (n > 32) {
                bl = false;
            }
            stringBuffer.append((char)n);
        }
        this.isWhitespace = bl;
        return stringBuffer.toString();
    }

    String readStrT() throws IOException {
        int n = this.readInt();
        int n2 = this.stringTable.indexOf(0, n);
        return this.stringTable.substring(n, n2);
    }

    public void setTagTable(int n, String[] stringArray) {
        this.tagTable = stringArray;
        if (n != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrStartTable(int n, String[] stringArray) {
        this.attrStartTable = stringArray;
        if (n != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrValueTable(int n, String[] stringArray) {
        this.attrValueTable = stringArray;
        if (n != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }
}

