/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.infocardOrganizer;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.infoml.infocardOrganizer.DragAndDropTree;
import org.infoml.infocardOrganizer.MainFrame;
import org.infoml.infocardOrganizer.MyRenderer;
import org.infoml.infocardOrganizer.NotecardModel;

public class InfocardWindow
implements Serializable {
    public DragAndDropTree tree;
    private DefaultTreeModel treeModel;
    public JScrollPane treeView;
    DefaultMutableTreeNode top;
    MainFrame mainFr;
    DragSource dragSource;
    DropTarget dropTarget;
    Vector nodes;
    Vector cardIds;
    Vector preOrdCardIds;
    String extra;

    public InfocardWindow(MainFrame mainFr) {
        this.mainFr = mainFr;
        this.top = new DefaultMutableTreeNode("InfomlFile");
        this.dragSource = new DragSource(){

            protected DragSourceContext createDragSourceContext(DragSourceContextPeer dscp, DragGestureEvent dgl, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable t, DragSourceListener dsl) {
                return new DragSourceContext(dscp, dgl, dragCursor, dragImage, imageOffset, t, dsl){

                    @Override
                    protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
                    }
                };
            }
        };
        this.tree = new DragAndDropTree(this.top, this.dragSource, mainFr);
        this.treeModel = new DefaultTreeModel(this.top);
        this.tree.setModel(this.treeModel);
        this.tree.addTreeSelectionListener(mainFr);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("mouse clicked");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.treeView.getViewport().setOpaque(true);
        this.tree.setCellRenderer(new MyRenderer());
        this.dropTarget = new DropTarget();
        this.dropTarget.setComponent(this.tree);
        try {
            this.dropTarget.addDropTargetListener(this.tree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dropTarget = new DropTarget();
        this.dropTarget.setComponent(this.treeView);
        try {
            this.dropTarget.addDropTargetListener(this.tree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dragSource.createDefaultDragGestureRecognizer(this.tree, 2, this.tree);
    }

    public void moveUp() {
    }

    public void moveDown() {
    }

    public void editNode(NotecardModel model) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (model.getTitle().compareTo("") != 0) {
            node.setUserObject(model.getTitle());
        } else {
            node.setUserObject("No title");
        }
    }

    public DefaultMutableTreeNode rememberSmartSelection(DefaultMutableTreeNode node) {
        if (node.getNextSibling() != null) {
            return node.getNextSibling();
        }
        if (node.getPreviousSibling() != null) {
            return node.getPreviousSibling();
        }
        return null;
    }

    public void insertNodeInto(NotecardModel model, DefaultMutableTreeNode node, DefaultMutableTreeNode parent, int index, int option) {
        if (node == null) {
            DefaultMutableTreeNode infocardRep = null;
            infocardRep = model.getTitle().compareTo("") != 0 ? new DefaultMutableTreeNode(model.getTitle()) : new DefaultMutableTreeNode("No title");
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(infocardRep, parent, index);
            this.tree.scrollPathToVisible(new TreePath(infocardRep.getPath()));
            this.tree.setSelectionPath(new TreePath(infocardRep.getPath()));
            if (option == 1) {
                this.mainFr.notecards.put(infocardRep, model);
            } else if (option == 2) {
                this.mainFr.uniqueContent.put(infocardRep, model);
            }
        } else {
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(node, parent, index);
            this.tree.scrollPathToVisible(new TreePath(node.getPath()));
            this.tree.setSelectionPath(new TreePath(node.getPath()));
            if (option == 1) {
                this.mainFr.notecards.put(node, model);
            } else if (option == 2) {
                this.mainFr.uniqueContent.put(node, model);
            }
        }
    }

    public void removeNode() {
        DefaultMutableTreeNode selected = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        NotecardModel m = (NotecardModel)this.mainFr.notecards.get(node);
        if (m == null) {
            m = (NotecardModel)this.mainFr.uniqueContent.get(node);
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        this.mainFr.stateSaver.models = new Vector();
        this.mainFr.stateSaver.infomlTypes = new Vector();
        this.mainFr.stateSaver.saveState(node, m, "r", null, parent, parent.getIndex(node));
        selected = this.rememberSmartSelection(node);
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
        Enumeration<TreeNode> nodes = node.preorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodes.nextElement();
            if (this.mainFr.notecards.containsKey(currentNode)) {
                this.mainFr.stateSaver.models.add(this.mainFr.notecards.get(currentNode));
                this.mainFr.stateSaver.infomlTypes.add(this.mainFr.infocards.get(this.mainFr.notecards.get(currentNode)));
                this.mainFr.infocards.remove(this.mainFr.notecards.get(currentNode));
                this.mainFr.notecards.remove(currentNode);
            }
            if (!this.mainFr.uniqueContent.containsKey(currentNode)) continue;
            this.mainFr.stateSaver.models.add(this.mainFr.uniqueContent.get(currentNode));
            this.mainFr.stateSaver.infomlTypes.add(this.mainFr.infocards.get(this.mainFr.uniqueContent.get(currentNode)));
            this.mainFr.infocards.remove(this.mainFr.uniqueContent.get(currentNode));
            this.mainFr.uniqueContent.remove(currentNode);
        }
        this.mainFr.infomlFile.hasChanged = true;
        if (this.top.getChildCount() == 0) {
            this.mainFr.setClearEnabled(false);
        }
        this.mainFr.moveLeft.setEnabled(false);
        this.mainFr.moveRight.setEnabled(false);
        this.mainFr.remove.setEnabled(false);
        this.mainFr.infomlFile.rearangeElements();
        this.mainFr.doSave();
    }

    public void clearNodes() {
        int lastIndex;
        for (int i = lastIndex = this.top.getIndex(this.top.getLastChild()); i >= 0; --i) {
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent((DefaultMutableTreeNode)this.top.getChildAt(i));
        }
        if (this.top.getChildCount() == 0) {
            this.mainFr.setClearEnabled(false);
        }
    }

    public void addNode(NotecardModel model, int option) {
        DefaultMutableTreeNode infocardRep = null;
        infocardRep = model.getTitle().compareTo("") != 0 ? new DefaultMutableTreeNode(model.getTitle()) : new DefaultMutableTreeNode("No title");
        if (option == 1) {
            this.mainFr.notecards.put(infocardRep, model);
        } else if (option == 2) {
            this.mainFr.uniqueContent.put(infocardRep, model);
        }
        this.treeModel.insertNodeInto(infocardRep, this.top, this.top.getChildCount());
        this.tree.scrollPathToVisible(new TreePath(infocardRep.getPath()));
        this.mainFr.enableSave();
    }

    public void getOutline() {
        NotecardModel ret2;
        NotecardModel ret1;
        DefaultMutableTreeNode node;
        this.cardIds = new Vector();
        this.preOrdCardIds = new Vector();
        this.nodes = new Vector();
        Enumeration<TreeNode> enum1 = this.mainFr.infoWindow.top.breadthFirstEnumeration();
        Enumeration<TreeNode> aux = this.mainFr.infoWindow.top.preorderEnumeration();
        while (enum1.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enum1.nextElement();
            this.nodes.add(node);
            ret1 = (NotecardModel)this.mainFr.notecards.get(node);
            ret2 = (NotecardModel)this.mainFr.uniqueContent.get(node);
            if (ret1 != null) {
                this.cardIds.add(ret1.getCardId());
            } else if (ret2 != null) {
                this.cardIds.add(ret2.getCardId());
            }
            ret1 = null;
            ret2 = null;
        }
        while (aux.hasMoreElements()) {
            node = (DefaultMutableTreeNode)aux.nextElement();
            ret1 = (NotecardModel)this.mainFr.notecards.get(node);
            ret2 = (NotecardModel)this.mainFr.uniqueContent.get(node);
            if (ret1 != null) {
                this.preOrdCardIds.add(ret1.getCardId());
            } else if (ret2 != null) {
                this.preOrdCardIds.add(ret2.getCardId());
            }
            ret1 = null;
            ret2 = null;
        }
    }

    public void addNodeFromSaved(String title, int option, NotecardModel model, int level) {
        DefaultMutableTreeNode infocardRep = new DefaultMutableTreeNode(title);
        if (option == 1) {
            this.mainFr.notecards.put(infocardRep, model);
        } else if (option == 2) {
            this.mainFr.uniqueContent.put(infocardRep, model);
        }
        Enumeration<TreeNode> enum1 = this.top.preorderEnumeration();
        int lastNodeLevel = 0;
        DefaultMutableTreeNode lastNode = null;
        while (enum1.hasMoreElements()) {
            lastNode = (DefaultMutableTreeNode)enum1.nextElement();
        }
        lastNodeLevel = lastNode.getLevel();
        if (lastNodeLevel > level) {
            int steps = lastNodeLevel - level;
            DefaultMutableTreeNode link = lastNode;
            for (int j = 0; j <= steps; ++j) {
                link = (DefaultMutableTreeNode)link.getParent();
            }
            int index = link.getChildCount();
            this.treeModel.insertNodeInto(infocardRep, link, index);
        } else if (lastNodeLevel < level) {
            int index = lastNode.getChildCount();
            this.treeModel.insertNodeInto(infocardRep, lastNode, index);
        } else if (lastNodeLevel == level && level != 0) {
            int index = lastNode.getParent().getChildCount();
            this.treeModel.insertNodeInto(infocardRep, (DefaultMutableTreeNode)lastNode.getParent(), index);
        }
        this.tree.scrollPathToVisible(new TreePath(infocardRep.getPath()));
    }

    public void moveNodeToRight() {
        DefaultMutableTreeNode c;
        boolean expanded;
        boolean editing = false;
        Vector<Integer> memExpanded = new Vector<Integer>();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        DefaultMutableTreeNode parentToBe = node.getPreviousSibling();
        Enumeration<TreeNode> children = node.preorderEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)children.nextElement();
            if (!parentToBe.getUserObject().toString().equals(current.getUserObject().toString())) continue;
            this.mainFr.setDropStatusText("Destination node in drop node branch or Drop node in destination node branch - Not allowed");
            Thread dummy = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(7500L);
                        InfocardWindow.this.mainFr.setDropStatusText("   ...");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            dummy.start();
            return;
        }
        if (this.tree.isEditing()) {
            editing = true;
        }
        if (expanded = this.tree.isExpanded(new TreePath(node.getPath()))) {
            Enumeration<TreeNode> enu = node.preorderEnumeration();
            while (enu.hasMoreElements()) {
                c = (DefaultMutableTreeNode)enu.nextElement();
                if (this.tree.isExpanded(new TreePath(c.getPath()))) {
                    memExpanded.add(new Integer(1));
                    continue;
                }
                memExpanded.add(new Integer(0));
            }
        }
        DefaultMutableTreeNode sibling = node.getPreviousSibling();
        this.mainFr.stateSaver.saveState(node, null, "mr", node, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node));
        this.treeModel.removeNodeFromParent(node);
        this.treeModel.insertNodeInto(node, sibling, sibling.getChildCount());
        if (node.getChildCount() != 0) {
            this.tree.scrollPathToVisible(new TreePath(((DefaultMutableTreeNode)node.getLastChild()).getPath()));
        } else {
            this.tree.scrollPathToVisible(new TreePath(node.getPath()));
        }
        this.tree.setSelectionPath(new TreePath(node.getPath()));
        this.mainFr.infomlFile.hasChanged = true;
        if (expanded) {
            c = null;
            Enumeration<TreeNode> enu = node.preorderEnumeration();
            c = (DefaultMutableTreeNode)enu.nextElement();
            int row = this.tree.getRowForPath(new TreePath(c.getPath()));
            int i = 0;
            int cRow = row;
            while (enu.hasMoreElements()) {
                if ((Integer)memExpanded.elementAt(i) == 1) {
                    this.tree.expandRow(cRow);
                } else {
                    this.tree.collapseRow(cRow);
                }
                ++cRow;
                ++i;
                c = (DefaultMutableTreeNode)enu.nextElement();
            }
        } else {
            this.tree.collapsePath(new TreePath(node.getPath()));
        }
        if (editing) {
            this.tree.startEditingAtPath(new TreePath(node.getPath()));
        }
    }

    public void moveNodeToLeft() {
        DefaultMutableTreeNode c;
        boolean expanded;
        boolean editing = false;
        Vector<Integer> memExpanded = new Vector<Integer>();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.tree.isEditing()) {
            editing = true;
        }
        if (expanded = this.tree.isExpanded(new TreePath(node.getPath()))) {
            Enumeration<TreeNode> enu = node.preorderEnumeration();
            while (enu.hasMoreElements()) {
                c = (DefaultMutableTreeNode)enu.nextElement();
                if (this.tree.isExpanded(new TreePath(c.getPath()))) {
                    memExpanded.add(new Integer(1));
                    continue;
                }
                memExpanded.add(new Integer(0));
            }
        }
        DefaultMutableTreeNode linkNode = (DefaultMutableTreeNode)node.getParent();
        this.mainFr.stateSaver.saveState(node, null, "ml", node, linkNode, linkNode.getIndex(node));
        if (linkNode != null) {
            this.treeModel.removeNodeFromParent(node);
            this.treeModel.insertNodeInto(node, (DefaultMutableTreeNode)linkNode.getParent(), linkNode.getParent().getIndex(linkNode) + 1);
            this.mainFr.infomlFile.hasChanged = true;
        }
        this.tree.setSelectionPath(new TreePath(node.getPath()));
        if (expanded) {
            c = null;
            Enumeration<TreeNode> enu = node.preorderEnumeration();
            c = (DefaultMutableTreeNode)enu.nextElement();
            int row = this.tree.getRowForPath(new TreePath(c.getPath()));
            int i = 0;
            int cRow = row;
            while (enu.hasMoreElements()) {
                if ((Integer)memExpanded.elementAt(i) == 1) {
                    this.tree.expandRow(cRow);
                } else {
                    this.tree.collapseRow(cRow);
                }
                ++cRow;
                c = (DefaultMutableTreeNode)enu.nextElement();
                ++i;
            }
        } else {
            this.tree.collapsePath(new TreePath(node.getPath()));
        }
        if (editing) {
            this.tree.startEditingAtPath(new TreePath(node.getPath()));
        }
    }
}

