/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.infocardOrganizer;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.infoml.infocardOrganizer.AncestorDialog;
import org.infoml.infocardOrganizer.InfocardBuilder;
import org.infoml.infocardOrganizer.MainFrame;
import org.infoml.infocardOrganizer.MyBorder;
import org.infoml.infocardOrganizer.NicknameKeeper;
import org.infoml.infocardOrganizer.SetupInformationDialog2;
import org.infoml.infocardOrganizer.UniqueContentListener;
import org.infoml.infocardOrganizer.UniqueContentModel;
import org.infoml.jaxb.InfomlType;

public class UniqueContentDialog
extends AncestorDialog {
    MainFrame mainFr;
    JPanel sPanel;
    JTextField to;
    MyBorder myBorder;
    UniqueContentModel model;
    UniqueContentListener listener;
    InfocardBuilder infocardBuilder;
    private int preferredWidth = 0;
    private int nicknameHeight = 0;
    private int titleHeight = 0;
    private int contentHeight = 0;
    private int pagesHeight = 0;
    private int keywordsHeight = 0;
    private int notes1Height = 0;
    private boolean visible = false;
    Document titleDoc;
    Document contentDoc;
    Document page1Doc;
    Document page2Doc;
    Document keywordsDoc;
    Document notes1Doc;
    Document notes2Doc;
    boolean edit;
    JComboBox chooseNickname = null;
    JTextField titleF;

    public UniqueContentDialog(Frame owner, String title, UniqueContentModel model, InfocardBuilder infocardBuilder, MainFrame mainFr, boolean edit) {
        super(owner, title, mainFr);
        this.setAlwaysOnTop(false);
        this.mainFr = mainFr;
        this.model = model;
        this.infocardBuilder = infocardBuilder;
        this.edit = edit;
        this.myBorder = new MyBorder();
        this.listener = new UniqueContentListener(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(this.createBorder());
        this.getContentPane().add(panel);
        panel.add((Component)this.createNorthPanel(), "North");
        panel.add((Component)this.createCenterPanel(), "Center");
        this.sPanel = this.createSouthPanel();
        panel.add((Component)this.sPanel, "South");
        this.pack();
        this.setVisible(true);
        this.titleF.grabFocus();
    }

    public Border createBorder() {
        TitledBorder inner = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "      Unique  Content      ");
        CompoundBorder cb = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 15, 5, 15), inner);
        return cb;
    }

    public void makeNicknameList(JPanel parent) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
        parent.add(panel);
        this.chooseNickname = new JComboBox(MainFrame.nicknames);
        if (this.model.shared == null) {
            this.chooseNickname.setSelectedIndex(MainFrame.nicknames.size() - 1);
            this.model.setShared((String)MainFrame.nicknames.lastElement(), MainFrame.sharedContent);
        } else {
            this.chooseNickname.setSelectedItem(this.model.shared.getNickname());
        }
        this.chooseNickname.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sel = (String)UniqueContentDialog.this.chooseNickname.getSelectedItem();
                UniqueContentDialog.this.model.setShared(sel, MainFrame.sharedContent);
            }
        });
        panel.add(this.chooseNickname);
        this.nicknameHeight = this.chooseNickname.getPreferredSize().height;
    }

    public void makeContentcardTitle(JPanel parent) {
        JPanel grid = new JPanel(new GridLayout());
        grid.setBorder(BorderFactory.createEmptyBorder(13, 5, 10, 5));
        parent.add(grid);
        this.titleF = new JTextField(20);
        this.titleF.addFocusListener(this.mainFr.focusListener);
        this.titleF.addCaretListener(this.mainFr.caretListener);
        if (this.edit && !this.model.getTitle().equals("No title")) {
            this.titleF.setText(this.model.getTitle());
        }
        this.titleDoc = this.titleF.getDocument();
        this.titleDoc.addDocumentListener(this.listener);
        this.titleDoc.addUndoableEditListener(this.ownUndoListener);
        this.titleF.setBorder(BorderFactory.createLoweredBevelBorder());
        grid.add(this.titleF);
        this.titleHeight = grid.getPreferredSize().height;
    }

    public void makeContentTextArea(JPanel parent) {
        JTextArea content = new JTextArea(12, 50);
        content.setLineWrap(true);
        content.setWrapStyleWord(true);
        UniqueContentDialog.invertFocusTraversalBehaviour(content);
        content.addFocusListener(this.mainFr.focusListener);
        content.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            content.setText(this.model.getContentString());
        }
        this.contentDoc = content.getDocument();
        this.contentDoc.addDocumentListener(this.listener);
        this.contentDoc.addUndoableEditListener(this.ownUndoListener);
        JScrollPane sPane = new JScrollPane(content);
        parent.add(sPane);
        sPane.setBorder(this.myBorder.getBorder());
        this.contentHeight = sPane.getPreferredSize().height;
    }

    public void makePagesPanel(JPanel parent) {
        JPanel pages = new JPanel(new FlowLayout(0));
        JTextField from = new JTextField(5);
        from.addCaretListener(this.mainFr.caretListener);
        from.addFocusListener(this.mainFr.focusListener);
        this.to = new JTextField(5);
        this.to.addFocusListener(this.mainFr.focusListener);
        this.to.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            from.setText(this.model.getPage1());
            if (this.model.getPage1().compareTo("") != 0) {
                this.to.setEditable(true);
            }
        }
        this.page1Doc = from.getDocument();
        this.page1Doc.addDocumentListener(this.listener);
        this.page1Doc.addUndoableEditListener(this.ownUndoListener);
        from.setBorder(BorderFactory.createLoweredBevelBorder());
        pages.add(from);
        JLabel label = new JLabel(" through ");
        pages.add(label);
        if (this.edit) {
            this.to.setText(this.model.getPage2());
        }
        this.to.setEditable(false);
        this.page2Doc = this.to.getDocument();
        this.page2Doc.addDocumentListener(this.listener);
        this.page2Doc.addUndoableEditListener(this.ownUndoListener);
        this.to.setBorder(BorderFactory.createLoweredBevelBorder());
        pages.add(this.to);
        parent.add(pages);
        this.pagesHeight = pages.getPreferredSize().height;
    }

    public void makeKeywordsTextArea(JPanel parent) {
        JTextArea keywords = new JTextArea(3, 40);
        keywords.setLineWrap(true);
        keywords.setWrapStyleWord(true);
        UniqueContentDialog.invertFocusTraversalBehaviour(keywords);
        keywords.addFocusListener(this.mainFr.focusListener);
        keywords.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            keywords.setText(this.model.getSelectorsString());
        }
        this.keywordsDoc = keywords.getDocument();
        this.keywordsDoc.addDocumentListener(this.listener);
        this.keywordsDoc.addUndoableEditListener(this.ownUndoListener);
        JScrollPane scrollPane2 = new JScrollPane(keywords);
        parent.add(scrollPane2);
        scrollPane2.setBorder(this.myBorder.getBorder());
        this.keywordsHeight = scrollPane2.getPreferredSize().height;
    }

    public void makeNotes1TextArea(JPanel parent) {
        JTextArea notes1 = new JTextArea(3, 40);
        notes1.setLineWrap(true);
        notes1.setWrapStyleWord(true);
        UniqueContentDialog.invertFocusTraversalBehaviour(notes1);
        notes1.addFocusListener(this.mainFr.focusListener);
        notes1.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            notes1.setText(this.model.getNotes1String());
        }
        this.notes1Doc = notes1.getDocument();
        this.notes1Doc.addDocumentListener(this.listener);
        this.notes1Doc.addUndoableEditListener(this.ownUndoListener);
        JScrollPane scrollPane3 = new JScrollPane(notes1);
        parent.add(scrollPane3);
        scrollPane3.setBorder(this.myBorder.getBorder());
        this.notes1Height = scrollPane3.getPreferredSize().height;
    }

    public void makeNicknameLabel(JPanel parent) {
        JPanel panel = new JPanel();
        JLabel nick = new JLabel("", 0);
        nick.setText("<html>\n <p> Use shared </p> \n <p> content </p>");
        panel.add(nick);
        parent.add(panel);
        if (nick.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = nick.getPreferredSize().width;
        }
    }

    public void makeTitleLabel(JPanel parent) {
        JPanel panel = new JPanel();
        JLabel title = new JLabel("", 0);
        title.setText("<html>\n <p> Content card </p> \n <p> title </p>");
        panel.add(title);
        parent.add(panel);
        if (title.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = title.getPreferredSize().width;
        }
    }

    public void makeContentLabel(JPanel parent) {
        JPanel panel = new JPanel();
        JLabel content = new JLabel("   Content   ");
        content.setPreferredSize(new Dimension(content.getPreferredSize().width, this.contentHeight));
        panel.add(content);
        parent.add(panel);
        if (content.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = content.getPreferredSize().width;
        }
    }

    public void makePagesLabel(JPanel parent) {
        JPanel panel = new JPanel();
        JLabel pages = new JLabel(" Page(s) ");
        panel.setPreferredSize(new Dimension(pages.getPreferredSize().width, this.pagesHeight));
        panel.add(pages);
        parent.add(panel);
        if (pages.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = pages.getPreferredSize().width;
        }
    }

    public void makeKeywordsLabel(JPanel parent) {
        JPanel panel = new JPanel();
        JLabel keywords = new JLabel("   Tags   ");
        panel.add(keywords);
        keywords.setPreferredSize(new Dimension(keywords.getPreferredSize().width, this.keywordsHeight));
        parent.add(panel);
        if (keywords.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = keywords.getPreferredSize().width;
        }
    }

    public void makeNotes1Label(JPanel parent) {
        JPanel panel = new JPanel();
        JLabel notes1 = new JLabel(" Notes1 ");
        panel.add(notes1);
        notes1.setPreferredSize(new Dimension(notes1.getPreferredSize().width, this.notes1Height));
        parent.add(panel);
        if (notes1.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = notes1.getPreferredSize().width;
        }
    }

    public JPanel createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        panel.add((Component)cPanel, "Center");
        this.makeNicknameList(cPanel);
        this.makeContentcardTitle(cPanel);
        this.makeContentTextArea(cPanel);
        this.makePagesPanel(cPanel);
        this.makeKeywordsTextArea(cPanel);
        this.makeNotes1TextArea(cPanel);
        JPanel wPanel = new JPanel();
        wPanel.setLayout(new BoxLayout(wPanel, 1));
        panel.add((Component)wPanel, "West");
        this.makeNicknameLabel(wPanel);
        this.makeTitleLabel(wPanel);
        this.makeContentLabel(wPanel);
        this.makePagesLabel(wPanel);
        this.makeKeywordsLabel(wPanel);
        this.makeNotes1Label(wPanel);
        return panel;
    }

    public JPanel createPanelA() {
        JPanel panelA = new JPanel(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        panelA.add((Component)cPanel, "Center");
        JPanel rbPanel = new JPanel(new FlowLayout(0));
        cPanel.add(rbPanel);
        ButtonGroup group = new ButtonGroup();
        JRadioButton yes = new JRadioButton(" Yes ");
        yes.setSelected(true);
        yes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UniqueContentDialog.this.model.setExact(true);
            }
        });
        group.add(yes);
        rbPanel.add(yes);
        JRadioButton no = new JRadioButton(" No ");
        no.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UniqueContentDialog.this.model.setExact(false);
            }
        });
        group.add(no);
        rbPanel.add(no);
        JTextArea notes2 = new JTextArea(3, 50);
        notes2.setLineWrap(true);
        notes2.setWrapStyleWord(true);
        UniqueContentDialog.invertFocusTraversalBehaviour(notes2);
        notes2.addFocusListener(this.mainFr.focusListener);
        notes2.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            notes2.setText(this.model.getNotes2String());
        }
        this.notes2Doc = notes2.getDocument();
        this.notes2Doc.addDocumentListener(this.listener);
        this.notes2Doc.addUndoableEditListener(this.ownUndoListener);
        JScrollPane scrollPane = new JScrollPane(notes2);
        cPanel.add(scrollPane);
        scrollPane.setBorder(this.myBorder.getBorder());
        JPanel wPanel = new JPanel();
        wPanel.setLayout(new BoxLayout(wPanel, 1));
        panelA.add((Component)wPanel, "West");
        JPanel panel = new JPanel();
        JLabel quotation = new JLabel("", 0);
        quotation.setText("<html>\n <p> Exact </p> \n <p> quotation </p>");
        quotation.setPreferredSize(new Dimension(this.preferredWidth, rbPanel.getPreferredSize().height));
        panel.add(quotation);
        wPanel.add(panel);
        JPanel panelD = new JPanel();
        JLabel notes2L = new JLabel(" Notes2 ", 0);
        notes2L.setPreferredSize(new Dimension(this.preferredWidth, this.notes1Height));
        panelD.add(notes2L);
        wPanel.add(panelD);
        return panelA;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        final JPanel panelA = this.createPanelA();
        JButton button = new JButton(" More fields ");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!UniqueContentDialog.this.visible) {
                            UniqueContentDialog.this.sPanel.add((Component)panelA, "North");
                            UniqueContentDialog.this.pack();
                            UniqueContentDialog.this.repaint();
                            UniqueContentDialog.this.visible = true;
                        } else {
                            UniqueContentDialog.this.sPanel.remove(panelA);
                            UniqueContentDialog.this.pack();
                            UniqueContentDialog.this.repaint();
                            UniqueContentDialog.this.visible = false;
                        }
                    }
                });
            }
        });
        panel.add(button);
        return panel;
    }

    public void buildContentTree() {
        this.infocardBuilder.setStandardInfocard();
        this.infocardBuilder.setCardId();
        this.infocardBuilder.setContent();
        this.infocardBuilder.setTitle();
        this.infocardBuilder.setSelectors();
        this.infocardBuilder.setNotes1();
        this.infocardBuilder.setNotes2();
        this.infocardBuilder.setCreator(MainFrame.setupModel);
        this.infocardBuilder.setDateCreated();
        this.infocardBuilder.setExactQuotation();
        this.infocardBuilder.setPages();
        this.infocardBuilder.setContainerNamePart1();
        this.infocardBuilder.setContainerNamePart2();
        this.infocardBuilder.setContainerDate();
        this.infocardBuilder.setAgentX(this.model.shared.getAgent1());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setAgentX(this.model.shared.getAgent2());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setAgentX(this.model.shared.getAgent3());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setAgentX(this.model.shared.getAgent4());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setEnclosingAgentX(this.model.shared.getAgent5());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setEnclosingAgentX(this.model.shared.getAgent6());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setEnclosingContainerVolumeIssue();
        this.infocardBuilder.setEnclosingContainerTitle();
        this.infocardBuilder.setCorporateAgent();
        this.mainFr.infomlFile.hasChanged = true;
    }

    public void editContentTree() {
        this.infocardBuilder.modifyInfocard(this.mainFr.infomlFile.findInfocard(this.model));
        this.infocardBuilder.setContent();
        this.infocardBuilder.setTitle();
        this.infocardBuilder.setSelectors();
        this.infocardBuilder.setNotes1();
        this.infocardBuilder.setNotes2();
        this.infocardBuilder.setCreator(MainFrame.setupModel);
        this.infocardBuilder.setDateCreated();
        this.infocardBuilder.setExactQuotation();
        this.infocardBuilder.setPages();
        this.infocardBuilder.setContainerNamePart1();
        this.infocardBuilder.setContainerNamePart2();
        this.infocardBuilder.setContainerDate();
        this.infocardBuilder.setAgentX(this.model.shared.getAgent1());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setAgentX(this.model.shared.getAgent2());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setAgentX(this.model.shared.getAgent3());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setAgentX(this.model.shared.getAgent4());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setEnclosingAgentX(this.model.shared.getAgent5());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setEnclosingAgentX(this.model.shared.getAgent6());
        this.infocardBuilder.agentType = null;
        this.infocardBuilder.setEnclosingContainerVolumeIssue();
        this.infocardBuilder.setEnclosingContainerTitle();
        this.infocardBuilder.setCorporateAgent();
        this.mainFr.infomlFile.hasChanged = true;
    }

    void createContent() {
        if (MainFrame.setupModel.setupInf()) {
            if (this.model.getSelectorsString().compareTo("") != 0) {
                this.model.setSelectorsList(this.model.getSelectorsString());
            }
            if (this.model.getContentString().compareTo("") != 0) {
                this.model.setContentList(this.model.getContentString());
            }
            if (this.model.getNotes1String() != null && this.model.getNotes1String().compareTo("") != 0) {
                this.model.setNotes1List(this.model.getNotes1String());
            }
            if (this.model.getNotes2String() != null && this.model.getNotes2String().compareTo("") != 0) {
                this.model.setNotes2List(this.model.getNotes2String());
            }
            this.model.shared.formatDate();
            if (!this.model.isEmpty()) {
                this.infocardBuilder.generateCardId();
                MainFrame.setupModel.increaseSequenceNumber("unique");
                MainFrame.serializator.run();
                this.mainFr.infoWindow.addNode(this.model, 2);
                this.mainFr.infomlFile.addInfocard(this.infocardBuilder.infocard, this.model);
                this.buildContentTree();
                NicknameKeeper.nickToId.put(this.model.getCardId(), this.model.shared.getNickname());
                MainFrame.equalizer.setModifiedContentcardModel(this.model);
                MainFrame.equalizer.run();
                this.dispose();
                this.mainFr.undoAction.setEnabled(false);
                this.mainFr.redoAction.setEnabled(false);
                this.mainFr.focusedDialog = null;
            } else {
                JOptionPane.showMessageDialog(this, "Content card is empty \nPlease add text to at least one of the fields \n in addition to the nickname field ", "Validation Error", 0);
            }
        } else {
            JOptionPane pane = new JOptionPane("This program needs certain setup information \nbefore it can create infocards. \nClick OK to open the Setup Information Dialog", 0);
            JDialog dialog = pane.createDialog(this, "Setup Information Missing");
            dialog.setVisible(true);
            while (pane.getValue() == JOptionPane.UNINITIALIZED_VALUE) {
            }
            if (pane.getValue() != null) {
                SetupInformationDialog2 setupInformationDialog2 = new SetupInformationDialog2(this, "Setup Information", this.mainFr);
            }
        }
    }

    void editContent() {
        this.model.getSelectorsList().clear();
        this.model.getContentList().clear();
        this.model.getNotes1List().clear();
        if (MainFrame.setupModel.setupInf()) {
            this.model.setSelectorsList(this.model.getSelectorsString());
            if (this.model.getContentString().compareTo("") != 0) {
                this.model.setContentList(this.model.getContentString());
            }
            if (this.model.getNotes1String() != null && this.model.getNotes1String().compareTo("") != 0) {
                this.model.setNotes1List(this.model.getNotes1String());
            }
            if (this.model.getNotes2String() != null && this.model.getNotes2String().compareTo("") != 0) {
                this.model.setNotes2List(this.model.getNotes2String());
            }
            this.model.shared.formatDate();
            if (!this.model.isEmpty()) {
                this.editContentTree();
                this.mainFr.infoWindow.editNode(this.model);
                MainFrame.equalizer.setMainFr(this.mainFr);
                MainFrame.equalizer.setModifiedInfomlType((InfomlType)this.mainFr.infocards.get(this.model));
                MainFrame.equalizer.setModifiedContentcardModel(this.model);
                MainFrame.equalizer.equalizeContentcards();
                this.dispose();
                this.mainFr.undoAction.setEnabled(false);
                this.mainFr.redoAction.setEnabled(false);
                this.mainFr.focusedDialog = null;
            } else {
                JOptionPane.showMessageDialog(this, "Content card is empty \nPlease add text to at least one of the fields \n in addition to the nickname field ", "Validation Error", 0);
            }
        } else {
            JOptionPane pane = new JOptionPane("This program needs certain setup information \nbefore it can create infocards. \nClick OK to open the Setup Information Dialog", 0);
            JDialog dialog = pane.createDialog(this, "Setup Information Missing");
            dialog.setVisible(true);
            while (pane.getValue() == JOptionPane.UNINITIALIZED_VALUE) {
            }
            if (pane.getValue() != null) {
                SetupInformationDialog2 setupInformationDialog2 = new SetupInformationDialog2(this, "Setup Information", this.mainFr);
            }
        }
    }

    public JPanel createSouthPanel() {
        Color color1 = new Color(100, 10, 75);
        Color color2 = new Color(75, 10, 100);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panelB = new JPanel(new FlowLayout(2));
        panel.add((Component)panelB, "South");
        JButton another = new JButton("Done/Another");
        another.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UniqueContentDialog.this.edit) {
                    UniqueContentDialog.this.createContent();
                    MainFrame cfr_ignored_0 = UniqueContentDialog.this.mainFr;
                    if (MainFrame.setupModel.setupInf()) {
                        UniqueContentDialog.this.mainFr.doSave();
                    }
                    UniqueContentModel uniqueModel = new UniqueContentModel();
                    InfocardBuilder infocardBuilder = new InfocardBuilder(UniqueContentDialog.this.mainFr.infomlFile, uniqueModel);
                    UniqueContentDialog unique = new UniqueContentDialog(UniqueContentDialog.this.mainFr, "New Content Card : Unique content", uniqueModel, infocardBuilder, UniqueContentDialog.this.mainFr, false);
                } else {
                    UniqueContentDialog.this.editContent();
                    UniqueContentDialog.this.mainFr.doSave();
                    UniqueContentModel uniqueModel = new UniqueContentModel();
                    InfocardBuilder infocardBuilder = new InfocardBuilder(UniqueContentDialog.this.mainFr.infomlFile, uniqueModel);
                    UniqueContentDialog unique = new UniqueContentDialog(UniqueContentDialog.this.mainFr, "Edit Content Card : Unique content", uniqueModel, infocardBuilder, UniqueContentDialog.this.mainFr, false);
                }
            }
        });
        another.setForeground(color2);
        panelB.add(another);
        panelB.add(new JLabel("                  "));
        if (!this.edit) {
            JButton create = new JButton(" Create ");
            create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UniqueContentDialog.this.createContent();
                    MainFrame cfr_ignored_0 = UniqueContentDialog.this.mainFr;
                    if (MainFrame.setupModel.setupInf()) {
                        UniqueContentDialog.this.mainFr.doSave();
                    }
                }
            });
            create.setForeground(color1);
            panelB.add(create);
        } else {
            JButton done = new JButton(" Done ");
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UniqueContentDialog.this.editContent();
                    UniqueContentDialog.this.mainFr.doSave();
                }
            });
            done.setForeground(color1);
            panelB.add(done);
        }
        JButton cancel = new JButton(" Cancel ");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UniqueContentDialog.this.dispose();
                UniqueContentDialog.this.mainFr.undoAction.setEnabled(false);
                UniqueContentDialog.this.mainFr.redoAction.setEnabled(false);
                UniqueContentDialog.this.mainFr.focusedDialog = null;
                --AncestorDialog.viewableInstances;
            }
        });
        panelB.add(cancel);
        return panel;
    }

    public static void invertFocusTraversalBehaviour(JTextArea textArea) {
        Set<AWTKeyStroke> forwardKeys = textArea.getFocusTraversalKeys(0);
        Set<AWTKeyStroke> backwardKeys = textArea.getFocusTraversalKeys(1);
        if (forwardKeys.size() != 1 || backwardKeys.size() != 1) {
            return;
        }
        AWTKeyStroke fks = forwardKeys.iterator().next();
        AWTKeyStroke bks = backwardKeys.iterator().next();
        int fkm = fks.getModifiers();
        int bkm = bks.getModifiers();
        int ctrlMask = 130;
        int ctrlShiftMask = 195;
        if (fks.getKeyCode() != 9 || (fkm & 0x82) == 0 || (fkm & 0x82) != fkm) {
            return;
        }
        if (bks.getKeyCode() != 9 || (bkm & 0xC3) == 0 || (bkm & 0xC3) != bkm) {
            return;
        }
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(1);
        newForwardKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        textArea.setFocusTraversalKeys(0, Collections.unmodifiableSet(newForwardKeys));
        HashSet<AWTKeyStroke> newBackwardKeys = new HashSet<AWTKeyStroke>(1);
        newBackwardKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 65));
        textArea.setFocusTraversalKeys(1, Collections.unmodifiableSet(newBackwardKeys));
    }
}

