/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.jaxb.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.unmarshaller.InterningXMLReader;
import com.sun.xml.bind.validator.DOMLocator;
import com.sun.xml.bind.validator.Locator;
import com.sun.xml.bind.validator.SAXLocator;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import org.infoml.jaxb.impl.runtime.DefaultJAXBContextImpl;
import org.infoml.jaxb.impl.runtime.ErrorHandlerAdaptor;
import org.infoml.jaxb.impl.runtime.GrammarInfo;
import org.infoml.jaxb.impl.runtime.InterningUnmarshallerHandler;
import org.infoml.jaxb.impl.runtime.SAXUnmarshallerHandler;
import org.infoml.jaxb.impl.runtime.SAXUnmarshallerHandlerImpl;
import org.infoml.jaxb.impl.runtime.ValidatingUnmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UnmarshallerImpl
extends AbstractUnmarshallerImpl {
    private DefaultJAXBContextImpl context = null;
    private final GrammarInfo grammarInfo;
    private static final DefaultHandler dummyHandler = new DefaultHandler();

    public UnmarshallerImpl(DefaultJAXBContextImpl context, GrammarInfo gi) {
        this.context = context;
        this.grammarInfo = gi;
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
    }

    @Override
    public void setValidating(boolean validating) throws JAXBException {
        super.setValidating(validating);
        if (validating) {
            this.context.getGrammar();
        }
    }

    @Override
    public UnmarshallerHandler getUnmarshallerHandler() {
        return new InterningUnmarshallerHandler(this.createUnmarshallerHandler((Locator)new SAXLocator()));
    }

    private SAXUnmarshallerHandler createUnmarshallerHandler(Locator locator) {
        SAXUnmarshallerHandler unmarshaller = new SAXUnmarshallerHandlerImpl(this, this.grammarInfo);
        try {
            if (this.isValidating()) {
                unmarshaller = ValidatingUnmarshaller.create(this.context.getGrammar(), unmarshaller, locator);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return unmarshaller;
    }

    @Override
    protected Object unmarshal(XMLReader reader, InputSource source) throws JAXBException {
        SAXLocator locator = new SAXLocator();
        SAXUnmarshallerHandler handler = this.createUnmarshallerHandler((Locator)locator);
        reader = InterningXMLReader.adapt((XMLReader)reader);
        reader.setContentHandler(handler);
        reader.setErrorHandler(new ErrorHandlerAdaptor(handler, (Locator)locator));
        try {
            reader.parse(source);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
        Object result = handler.getResult();
        reader.setContentHandler(dummyHandler);
        reader.setErrorHandler(dummyHandler);
        return result;
    }

    @Override
    public final Object unmarshal(Node node) throws JAXBException {
        try {
            DOMScanner scanner = new DOMScanner();
            InterningUnmarshallerHandler handler = new InterningUnmarshallerHandler(this.createUnmarshallerHandler((Locator)new DOMLocator(scanner)));
            if (node instanceof Element) {
                scanner.parse((Element)node, (ContentHandler)handler);
            } else if (node instanceof Document) {
                scanner.parse(((Document)node).getDocumentElement(), (ContentHandler)handler);
            } else {
                throw new IllegalArgumentException();
            }
            return handler.getResult();
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
    }
}

