/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class DeviceNColorSpace
extends SeparationColorSpace {
    public DeviceNColorSpace() {
    }

    public DeviceNColorSpace(PdfObjectReader pdfObjectReader, String string, Map map) {
        this.value = 11;
        this.processColorToken(pdfObjectReader, string, map);
    }

    public void setColor(String[] stringArray, int n) {
        try {
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            stringArray = this.colorMapper.getOperand(fArray);
            if (this.altCS instanceof DeviceCMYKColorSpace) {
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = stringArray[stringArray.length - i - 1];
                }
                stringArray = stringArray2;
            }
            this.altCS.setColor(stringArray, stringArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.createImage(n, n2, byArray);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't convert DeviceN colorspace data: " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, String string) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            Raster raster = imageReader.readRaster(0, null);
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
            bufferedImage = this.createImage(n3, n4, dataBufferByte.getData());
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            exception.printStackTrace();
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, byte[] byArray) {
        byte[] byArray2 = new byte[n * n2 * 3];
        int n3 = byArray.length / this.componentCount;
        String[] stringArray = new String[this.componentCount];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3 && n4 < byArray.length; ++i) {
            int n6;
            for (n6 = 0; n6 < this.componentCount; ++n6) {
                float f = (float)(byArray[n4] & 0xFF) / 255.0f;
                stringArray[this.componentCount - n6 - 1] = String.valueOf(f);
                ++n4;
            }
            this.setColor(stringArray, this.componentCount);
            n6 = this.altCS.currentColor.getRGB();
            byArray2[n5] = (byte)(n6 >> 16 & 0xFF);
            byArray2[n5 + 1] = (byte)(n6 >> 8 & 0xFF);
            byArray2[n5 + 2] = (byte)(n6 & 0xFF);
            n5 += 3;
        }
        int[] nArray = new int[]{0, 1, 2};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

