/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.contentextractor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.utils.IconiseImage;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.TimeNow;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_String;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentExtractor
extends SimpleViewer {
    private Vector_Int itemSelectedX1 = new Vector_Int(10);
    private Vector_Int itemSelectedY1 = new Vector_Int(10);
    private Vector_Int itemSelectedWidth = new Vector_Int(10);
    private Vector_Int itemSelectedHeight = new Vector_Int(10);
    private Vector_Int pageUsed = new Vector_Int(10);
    private Vector_String imagesStored = new Vector_String(10);
    Vector_Object thumbnailsStored = new Vector_Object(10);
    private Map imagesUsed = new HashMap();
    private Vector_String textStored = new Vector_String(10);
    private Vector_String xmlStored = new Vector_String(10);
    private int itemSelectedCount = 1;
    private boolean showExtractedItems;
    GUIButton showItemsExtracted = new SwingButton();
    GUIButton saveItemsExtracted = new SwingButton();
    private static final String type = "TIFF";

    public ContentExtractor() {
        JAIHelper.useJAI(false);
        JAIHelper.confirmJAIOnClasspath();
        this.commonValues.setContentExtractor(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        ContentExtractor contentExtractor = new ContentExtractor();
        contentExtractor.setupViewer();
    }

    public void setupViewer() {
        try {
            this.init(null);
            this.setupExtractorGUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception on initialisation");
        }
    }

    private void setupExtractorGUI() {
        this.currentGUI.first = new SwingButton();
        this.currentGUI.fback = new SwingButton();
        this.currentGUI.back = new SwingButton();
        this.currentGUI.forward = new SwingButton();
        this.currentGUI.fforward = new SwingButton();
        this.currentGUI.end = new SwingButton();
        ((AbstractButton)((Object)this.currentGUI.first)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fback)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.back)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.forward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fforward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.end)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.currentGUI.setViewerTitle(null);
        if (!this.thumbnails.isShownOnscreen()) {
            this.currentGUI.setPDFOutlineVisible(false);
        }
        this.mouseHandler.setupExtractor();
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.currentGUI.initStatus();
        this.createSwingMenu(false);
        this.createExtractorButtons(this.currentGUI.getTopButtonBar());
        this.currentGUI.addCursor();
    }

    private void createExtractorButtons(JToolBar jToolBar) {
        this.openButton(jToolBar);
        jToolBar.add(Box.createHorizontalGlue());
        SwingButton swingButton = new SwingButton();
        swingButton.init("/org/jpedal/examples/contentextractor/snapgrid.gif", -1, "Click to snap onto outlines");
        jToolBar.add(swingButton);
        ((AbstractButton)swingButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.mouseHandler.updateRectangle();
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        SwingButton swingButton2 = new SwingButton();
        swingButton2.init("/org/jpedal/examples/simpleviewer/res/snapshot.gif", -1, "Click to extract selected rectangle");
        jToolBar.add(swingButton2);
        ((AbstractButton)swingButton2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ContentExtractor.this.commonValues.getSelectedFile() != null && !ContentExtractor.this.commonValues.isProcessing() && ContentExtractor.this.currentGUI.getRectangle() != null) {
                    ContentExtractor.this.extractContent();
                    if (ContentExtractor.this.currentGUI.isPDFOutlineVisible()) {
                        ContentExtractor.this.createThumbnails();
                    }
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(Box.createHorizontalGlue());
        String string = "Show extracted items";
        if (this.showExtractedItems) {
            string = "Hide extracted items";
        }
        this.showItemsExtracted.init("/org/jpedal/examples/contentextractor/list.gif", -1, string);
        this.showItemsExtracted.setVisible(false);
        jToolBar.add((AbstractButton)((Object)this.showItemsExtracted));
        ((AbstractButton)((Object)this.showItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !ContentExtractor.this.currentGUI.isPDFOutlineVisible();
                ContentExtractor.this.currentGUI.setPDFOutlineVisible(bl);
                ContentExtractor.this.showExtractedItems = !ContentExtractor.this.showExtractedItems;
                if (bl) {
                    ContentExtractor.this.createThumbnails();
                } else {
                    ContentExtractor.this.showExtractedItems = false;
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        this.saveItemsExtracted.init("/org/jpedal/examples/simpleviewer/res/save.gif", -1, "Save extracted items");
        this.saveItemsExtracted.setVisible(false);
        jToolBar.add((AbstractButton)((Object)this.saveItemsExtracted));
        ((AbstractButton)((Object)this.saveItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ContentExtractor.this.saveThumbnails();
                if (bl) {
                    ContentExtractor.this.resetToEmpty(false);
                }
                ContentExtractor.this.decode_pdf.setHighlightedAreas(null);
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    private boolean saveThumbnails() {
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showSaveDialog(jFileChooser);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            if (file.exists()) {
                this.currentGUI.showMessageDialog("Directory already exists - please use another name");
            } else {
                file.mkdirs();
                String string2 = this.commonValues.getTarget();
                String string3 = this.commonValues.getSeparator();
                if (string2 != null) {
                    File file2 = new File(string2);
                    String[] stringArray = file2.list();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!(!stringArray[i].endsWith(type) | this.imagesUsed.get(stringArray[i]) != null)) continue;
                            File file3 = new File(string2 + string3 + stringArray[i]);
                            ObjectStore.copy(string2 + string3 + stringArray[i], string + string3 + stringArray[i]);
                            file3.deleteOnExit();
                            file3.delete();
                        }
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            this.showExtractedItems = false;
        }
        return bl;
    }

    private void openButton(JToolBar jToolBar) {
        SwingButton swingButton = new SwingButton();
        swingButton.init("/org/jpedal/examples/simpleviewer/res/open.gif", -1, Messages.getMessage("PdfViewerFileMenuTooltip.open"));
        jToolBar.add(swingButton);
        ((AbstractButton)swingButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentExtractor.this.commonValues.setProcessing(false);
                boolean bl = true;
                if (ContentExtractor.this.itemSelectedCount == 1) {
                    bl = false;
                } else {
                    int n = ContentExtractor.this.currentGUI.showConfirmDialog(" ARE YOU SURE you wish to lose the currently selected items?", "Extracted Content WILL be overwritten", 0);
                    if (n == 0) {
                        bl = false;
                    }
                }
                if (!bl) {
                    ContentExtractor.this.resetToEmpty(false);
                    ContentExtractor.this.currentGUI.setPDFOutlineVisible(false);
                    ContentExtractor.this.currentGUI.zoom(false);
                    ContentExtractor.this.currentCommands.selectFile();
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    private void resetToEmpty(boolean bl) {
        int n;
        if (bl && this.itemSelectedCount > 1 && (n = this.currentGUI.showConfirmDialog("Do you wish to save it first?", "Extracted Content WILL be overwritten", 0)) == 0) {
            while (!this.saveThumbnails()) {
            }
        }
        this.showExtractedItems = false;
        this.showItemsExtracted.setVisible(false);
        this.saveItemsExtracted.setVisible(false);
        this.itemSelectedX1 = new Vector_Int(10);
        this.itemSelectedY1 = new Vector_Int(10);
        this.itemSelectedWidth = new Vector_Int(10);
        this.itemSelectedHeight = new Vector_Int(10);
        this.itemSelectedCount = 1;
        this.pageUsed = new Vector_Int(10);
        this.imagesStored = new Vector_String(10);
        this.imagesUsed = new HashMap();
        this.thumbnailsStored = new Vector_Object(10);
        this.textStored = new Vector_String(10);
        this.xmlStored = new Vector_String(10);
        this.currentCommands.flush();
        this.decode_pdf.removeHiglightedObject();
        this.decode_pdf.setHighlightedZones(0, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.decode_pdf.updateCursorBoxOnScreen(null, null);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        this.currentGUI.setSplitDividerLocation(0);
        this.decode_pdf.repaint();
    }

    private void extractContent() {
        BufferedImage bufferedImage = null;
        String string = null;
        String string2 = null;
        try {
            PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
            int n = this.commonValues.m_x1;
            int n2 = this.commonValues.m_x2;
            int n3 = this.commonValues.m_y1;
            int n4 = this.commonValues.m_y2;
            if (n3 < n4) {
                n4 = this.commonValues.m_y1;
                n3 = this.commonValues.m_y2;
            }
            if (n > n2) {
                n2 = this.commonValues.m_x1;
                n = this.commonValues.m_x2;
            }
            if ((string = pdfGroupingAlgorithms.extractTextInRectangle(n - 3, n3 + 3, n2 + 6, n4 - 6, this.commonValues.getCurrentPage(), false, true)) != null) {
                string2 = Strip.stripXML(string).toString();
            }
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        bufferedImage = this.extractSelectedScreenAsImage();
        this.popupDisplay(bufferedImage, string, string2, this.itemSelectedCount, true, false);
    }

    private void popupDisplay(final BufferedImage bufferedImage, String string, String string2, final int n, final boolean bl, boolean bl2) {
        Object object;
        JTabbedPane jTabbedPane = new JTabbedPane();
        final JTextPane jTextPane = new JTextPane();
        final JTextPane jTextPane2 = new JTextPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bufferedImage == null) {
            return;
        }
        jPanel.add((Component)new JLabel(new IconiseImage(bufferedImage)), "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        jTabbedPane.addTab("Image", jScrollPane);
        if (string != null) {
            object = new JScrollPane();
            try {
                object = this.currentGUI.createPane(jTextPane2, string, true);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
            ((JScrollPane)object).setVerticalScrollBarPolicy(20);
            ((JComponent)object).setPreferredSize(new Dimension(400, 400));
            jTabbedPane.addTab("XML", (Component)object);
        }
        if (string2 != null) {
            object = new JScrollPane();
            try {
                object = this.currentGUI.createPane(jTextPane, string2, true);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
            ((JScrollPane)object).setVerticalScrollBarPolicy(20);
            ((JComponent)object).setPreferredSize(new Dimension(400, 400));
            jTabbedPane.addTab("Text", (Component)object);
        }
        object = "Extracted Content - would you like to accept?";
        if (bl2) {
            object = "Would you like to save any changes you have made to the current item?";
        }
        final JDialog jDialog = new JDialog((Frame)this.currentGUI.getFrame(), true);
        jDialog.setLocationRelativeTo(null);
        jDialog.setLocation(this.currentGUI.getFrame().getLocationOnScreen().x + 10, this.currentGUI.getFrame().getLocationOnScreen().y + 10);
        jDialog.setSize(450, 450);
        jDialog.setTitle((String)object);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jTabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(Messages.getMessage("PdfMessage.Yes"));
        jButton.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton, "West");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                String string2 = "";
                string = jTextPane.getText();
                string2 = jTextPane2.getText();
                if (bl) {
                    ContentExtractor.this.textStored.addElement(string);
                    ContentExtractor.this.xmlStored.addElement(string2);
                } else {
                    ContentExtractor.this.textStored.setElementAt(string, n - 1);
                    ContentExtractor.this.xmlStored.setElementAt(string2, n - 1);
                }
                ContentExtractor.this.saveExtractedContent(bufferedImage, string2, string, n, bl);
                if (ContentExtractor.this.itemSelectedCount == 1) {
                    ContentExtractor.this.showItemsExtracted.setVisible(true);
                    ContentExtractor.this.saveItemsExtracted.setVisible(true);
                }
                if (bl) {
                    ContentExtractor.this.itemSelectedCount++;
                    ContentExtractor.this.itemSelectedX1.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_x1);
                    ContentExtractor.this.itemSelectedY1.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_y1);
                    ContentExtractor.this.itemSelectedWidth.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_x2);
                    ContentExtractor.this.itemSelectedHeight.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_y2);
                }
                if (bl) {
                    ContentExtractor.this.createOnscreenOutlines();
                }
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton(Messages.getMessage("PdfMessage.No"));
        jButton2.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton2, "East");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
    }

    private void createOnscreenOutlines() {
        int[] nArray = this.itemSelectedX1.get();
        int[] nArray2 = this.itemSelectedY1.get();
        int[] nArray3 = this.itemSelectedWidth.get();
        int[] nArray4 = this.itemSelectedHeight.get();
        int[] nArray5 = new int[this.itemSelectedCount];
        boolean[] blArray = new boolean[this.itemSelectedCount];
        int[] nArray6 = new int[this.itemSelectedCount];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[this.itemSelectedCount];
        Shape[] shapeArray = new Shape[this.itemSelectedCount];
        Color[] colorArray = new Color[this.itemSelectedCount];
        int[] nArray7 = new int[this.itemSelectedCount];
        int[] nArray8 = new int[this.itemSelectedCount];
        for (int i = 0; i < this.itemSelectedCount; ++i) {
            nArray5[i] = i;
            blArray[i] = true;
            rectangle2DArray[i] = new Rectangle(nArray[i], nArray4[i], nArray3[i] - nArray[i], nArray2[i] - nArray4[i]);
            nArray7[i] = (int)((rectangle2DArray[i].getBounds().getMinX() + rectangle2DArray[i].getBounds().getMaxX()) / 2.0);
            nArray8[i] = (int)((rectangle2DArray[i].getBounds().getMinY() + rectangle2DArray[i].getBounds().getMaxY()) / 2.0) - 12;
            if (this.pageUsed.elementAt(i) == this.commonValues.getCurrentPage()) {
                shapeArray[i] = rectangle2DArray[i];
            }
            colorArray[i] = Color.BLUE;
        }
        this.currentGUI.setRectangle(null);
        this.decode_pdf.setHighlightedZones(1, nArray7, nArray8, shapeArray, null, null, null, null, rectangle2DArray, blArray, null, colorArray, nArray5, nArray6);
        this.decode_pdf.repaint();
    }

    private void saveExtractedContent(BufferedImage bufferedImage, String string, String string2, int n, boolean bl) {
        Object object;
        Object object2;
        String string3 = this.commonValues.getTarget();
        String string4 = this.commonValues.getSeparator();
        if (string3 == null) {
            try {
                object2 = File.createTempFile("jpedal", "ads");
                object = new File(((File)object2).getAbsolutePath() + "-files");
                ((File)object).mkdirs();
                ((File)object).deleteOnExit();
                string3 = ((File)object).getAbsolutePath();
                this.commonValues.setTarget(string3);
                ((File)object2).delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string3 != null) {
            if (bl) {
                if (bufferedImage != null) {
                    object2 = "page_" + this.commonValues.getCurrentPage() + "_id" + n + '.' + type;
                    object = string3 + string4 + (String)object2;
                    JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)object, (Object)type);
                    this.thumbnailsStored.addElement(bufferedImage);
                    this.imagesStored.addElement((String)object);
                    this.imagesUsed.put(object2, "x");
                } else {
                    this.imagesStored.addElement(null);
                    this.thumbnailsStored.addElement(null);
                }
            }
        } else {
            this.currentGUI.showInputDialog("Problem accessing drive - unable to save images");
        }
        int n2 = this.commonValues.getCurrentPage();
        if (!bl) {
            n2 = this.pageUsed.elementAt(n - 1);
        } else {
            this.pageUsed.addElement(n2);
        }
        try {
            this.writeText(string2, string3, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentGUI.showInputDialog("Problem saving text");
        }
        try {
            this.writeXML(string, string3, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentGUI.showMessageDialog("Problem saving xml");
        }
    }

    private void writeText(String string, String string2, int n, int n2) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(string2 + this.commonValues.getSeparator() + "page_" + n2 + "_id" + n + ".txt"));
        outputStreamWriter.write(string);
        outputStreamWriter.close();
    }

    public void writeXML(String string, String string2, int n, int n2) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("content");
            document.appendChild(element);
            Comment comment = document.createComment("Created " + TimeNow.getShortTimeNow());
            Comment comment2 = document.createComment("Extracted via JPedal");
            Comment comment3 = document.createComment("SourceFile " + this.decode_pdf.getObjectStore().getCurrentFilename());
            element.appendChild(comment);
            element.appendChild(comment2);
            element.appendChild(comment3);
            Element element2 = this.addTextAsXML(string, document, element);
            Node node = document.importNode(element2, true);
            element.appendChild(node);
            InputStream inputStream = this.decode_pdf.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
            transformer.transform(new DOMSource(document), new StreamResult(string2 + this.commonValues.getSeparator() + "page_" + n2 + "_id" + n + ".xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Element addTextAsXML(String string, Document document, Node node) throws FactoryConfigurationError {
        Element element = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\"?><text>");
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '&') {
                    boolean bl = false;
                    for (int j = i + 1; j < n; ++j) {
                        char c2 = string.charAt(i);
                        if (c2 == ';') {
                            j = n;
                            bl = true;
                            continue;
                        }
                        if (!(c2 == ' ' | c2 == '\n')) continue;
                        j = n;
                    }
                    if (bl) {
                        outputStreamWriter.write(c);
                        continue;
                    }
                    outputStreamWriter.write("&amp;");
                    continue;
                }
                if (c <= '\u0000') continue;
                outputStreamWriter.write(c);
            }
            outputStreamWriter.write("</text>");
            outputStreamWriter.close();
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document2 = documentBuilderFactory.newDocumentBuilder().parse(byteArrayInputStream);
            NodeList nodeList = document2.getElementsByTagName("text");
            element = (Element)nodeList.item(0);
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in writing text \n" + string);
        }
        return element;
    }

    private BufferedImage extractSelectedScreenAsImage() {
        int n = this.commonValues.m_x1;
        int n2 = this.commonValues.m_x2;
        int n3 = this.commonValues.m_y1;
        int n4 = this.commonValues.m_y2;
        if (n3 < n4) {
            n4 = this.commonValues.m_y1;
            n3 = this.commonValues.m_y2;
        }
        if (n > n2) {
            n2 = this.commonValues.m_x1;
            n = this.commonValues.m_x2;
        }
        return this.decode_pdf.getSelectedRectangleOnscreen(n, n3, n2, n4, 100.0f);
    }

    private void createThumbnails() {
        this.currentGUI.initThumbnails(this.itemSelectedCount, this.pageUsed);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        Object[] objectArray = this.thumbnails.getButtons();
        for (int i = 0; i < this.itemSelectedCount - 1; ++i) {
            JButton jButton = (JButton)objectArray[i];
            jButton.addActionListener(new ButtonPopup(i));
        }
    }

    public class ButtonPopup
    implements ActionListener {
        int id;
        JButton[] buttons;

        public ButtonPopup(int n) {
            this.id = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContentExtractor.this.thumbnails.resetHighlightedThumbnail(this.id);
            ContentExtractor.this.thumbnails.refreshDisplay();
            BufferedImage bufferedImage = JAI.create((String)"fileload", (Object)ContentExtractor.this.imagesStored.elementAt(this.id)).getAsBufferedImage();
            ContentExtractor.this.popupDisplay(bufferedImage, ContentExtractor.this.xmlStored.elementAt(this.id), ContentExtractor.this.textStored.elementAt(this.id), this.id + 1, false, true);
        }
    }
}

