/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.utils.Messages;

public class Preferences {
    JFrame jf = new JFrame("JPedal PDF Preferences");
    JLabel title = new JLabel("Preferences");
    JPanel mainPane = new JPanel(new GridBagLayout());
    JPanel[] settings = new JPanel[2];
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTextField dpi_Input = new JTextField("96");
    String dpiDefaultValue = "96";
    JComboBox searchStyle = new JComboBox<String>(new String[]{"Ext. Window", "Tab Pane", "Menu Bar"});
    int searchStyleDefaultValue = 1;
    JCheckBox border = new JCheckBox();
    JCheckBox autoScroll = new JCheckBox();
    int borderDefaultValue = 1;
    boolean scrollDefaultValue = false;
    JList settingsList = new JList<String>(new String[]{"Display", "Viewer"});
    Box setButtons = Box.createHorizontalBox();
    int currentListSelection = 0;

    public void createPreferanceWindow(final GUI gUI) {
        int n;
        this.jf = new JFrame(Messages.getMessage("PageLayoutViewMenu.PreferencesWindowTitle"));
        for (n = 0; n != this.settings.length; ++n) {
            this.settings[n] = new JPanel(new BorderLayout());
        }
        this.settingsList = new JList<String>(new String[]{"Display", "Viewer"});
        this.settingsList.setSelectedIndex(this.currentListSelection);
        this.settingsList.setSize(50, 100);
        this.dpi_Input = new JTextField(this.dpiDefaultValue);
        this.dpi_Input.setPreferredSize(new Dimension(this.dpi_Input.getFont().getSize() * 4, this.dpi_Input.getFont().getSize() + 10));
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.border = new JCheckBox();
        this.autoScroll = new JCheckBox();
        this.confirm = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.title = new JLabel(Messages.getMessage("PageLayoutViewMenu.Preferences"));
        this.title.setFont(new Font(null, 1, 14));
        this.setButtons.add(this.confirm);
        this.setButtons.add(Box.createHorizontalStrut(30));
        this.setButtons.add(this.cancel);
        block5: for (n = 0; n != this.settingsList.countComponents() + 1; ++n) {
            switch (n) {
                case 0: {
                    this.createDisplaySettings(this.settings[0]);
                    continue block5;
                }
                case 1: {
                    this.createViewerSettings(this.settings[1]);
                    continue block5;
                }
            }
        }
        this.mainPane = this.buildMainPane(this.mainPane);
        this.jf.getContentPane().setLayout(new BorderLayout());
        this.jf.getContentPane().add((Component)this.mainPane, "Center");
        this.jf.setSize(400, 300);
        this.jf.setResizable(false);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.dpiDefaultValue = Preferences.this.dpi_Input.getText();
                int n = Integer.parseInt(Preferences.this.dpi_Input.getText());
                int n2 = Preferences.this.searchStyleDefaultValue = Preferences.this.searchStyle.getSelectedIndex();
                Preferences.this.borderDefaultValue = 0;
                int n3 = 0;
                if (Preferences.this.border.isSelected()) {
                    Preferences.this.borderDefaultValue = 1;
                    n3 = 1;
                }
                boolean bl = Preferences.this.scrollDefaultValue = Preferences.this.autoScroll.isSelected();
                gUI.setPreferences(n, n2, n3, bl);
                Preferences.this.jf.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.jf.setVisible(false);
            }
        });
        this.dpi_Input.addKeyListener(new KeyListener(){
            boolean consume = false;

            public void keyPressed(KeyEvent keyEvent) {
                this.consume = false;
                if (!(keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (this.consume) {
                    keyEvent.consume();
                }
            }
        });
        this.settingsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Preferences.this.changeDisplayedSettings();
            }
        });
        this.searchStyle.setSelectedIndex(this.searchStyleDefaultValue);
        this.dpi_Input.setText(this.dpiDefaultValue);
        if (this.borderDefaultValue == 1) {
            this.border.setSelected(true);
        } else {
            this.border.setSelected(false);
        }
        this.autoScroll.setSelected(this.scrollDefaultValue);
    }

    private JPanel buildMainPane(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.title, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 5;
        jPanel.add((Component)this.settings[0], gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.setButtons, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.settingsList, gridBagConstraints);
        return jPanel;
    }

    private void changeDisplayedSettings() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.mainPane.remove(this.settings[this.currentListSelection]);
        this.mainPane.add((Component)this.settings[this.settingsList.getSelectedIndex()], gridBagConstraints);
        this.mainPane.validate();
        this.mainPane.repaint();
        this.currentListSelection = this.settingsList.getSelectedIndex();
    }

    public void showPreferanceWindow() {
        this.jf.setVisible(true);
    }

    private JPanel createViewerSettings(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(250, 100));
        jPanel.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.searchStyle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.autoScroll, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Viewer Settings"));
        return jPanel;
    }

    private JPanel createDisplaySettings(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(250, 100));
        jPanel.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenu.Dpi")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.dpi_Input, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.Borders_Show")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.border, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Display Settings"));
        return jPanel;
    }

    public void setAutoScrollDefaultValue(boolean bl) {
        this.scrollDefaultValue = bl;
    }

    public void setBorderDefaultValue(int n) {
        this.borderDefaultValue = n;
    }

    public void setDpiDefaultValue(String string) {
        this.dpiDefaultValue = string;
    }

    public void setSearchStyleDefaultValue(int n) {
        this.searchStyleDefaultValue = n;
    }
}

