/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.io.PdfObjectReader;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private Map tintTransform;
    private float[] domain;
    private float[] encode;
    private float[] decode;
    private float[] range;
    private int[] size;
    private int BitsPerSample = 0;
    private float[] samples;

    public PDFSampled(byte[] byArray, Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        this.tintTransform = map;
        this.domain = fArray;
        this.range = fArray2;
        this.BitsPerSample = Integer.parseInt((String)map.get("BitsPerSample"));
        this.setSize(pdfObjectReader);
        this.setEncode(pdfObjectReader);
        this.setDecode(pdfObjectReader);
        this.setSamples(byArray);
    }

    public String[] compute(float[] fArray) {
        int n;
        int n2 = this.domain.length / 2;
        int n3 = n = this.range.length / 2;
        String[] stringArray = new String[n3];
        try {
            float[] fArray2 = new float[n2 * 2];
            float[] fArray3 = fArray;
            for (int i = 0; i < n2; ++i) {
                int n4;
                fArray2[i * 2] = this.encodeInput(fArray3[i], i);
                if (n == n2) {
                    stringArray[n3 - i - 1] = String.valueOf(this.decodeSample(fArray2[i * 2], i, n, 0));
                    continue;
                }
                if (n2 < n) {
                    for (n4 = 0; n4 < n; ++n4) {
                        stringArray[n3 - n4 - 1] = String.valueOf(this.decodeSample(fArray2[i * 2], n4, n, n4));
                    }
                    continue;
                }
                if (n >= n2) continue;
                for (n4 = 0; n4 < n; ++n4) {
                    stringArray[n3 - n4 - 1] = String.valueOf(this.decodeSample(fArray2[i * 2], n4, n, n4));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Sampled exception " + exception);
            exception.printStackTrace();
        }
        return stringArray;
    }

    public float[] computeFloat(float[] fArray) {
        int n = this.range.length / 2;
        float[] fArray2 = new float[n];
        try {
            int n2 = this.domain.length / 2;
            int n3 = this.range.length / 2;
            float[] fArray3 = new float[n2 * 2];
            float[] fArray4 = fArray;
            for (int i = 0; i < n2; ++i) {
                int n4;
                fArray3[i * 2] = this.encodeInput(fArray4[i], i);
                if (n3 == n2) {
                    fArray2[n - i - 1] = this.decodeSample(fArray3[i * 2], i, n3, 0);
                    continue;
                }
                if (n2 < n3) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        fArray2[n - n4 - 1] = this.decodeSample(fArray3[i * 2], n4, n3, n4);
                    }
                    continue;
                }
                if (n3 >= n2) continue;
                for (n4 = 0; n4 < n3; ++n4) {
                    fArray2[n - n4 - 1] = this.decodeSample(fArray3[i * 2], n4, n3, n4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Sampled exception " + exception);
            exception.printStackTrace();
        }
        return fArray2;
    }

    public String getType() {
        return "SAMPLED";
    }

    private float encodeInput(float f, int n) {
        f = this.min(this.max(f, this.domain[n * 2]), this.domain[n * 2 + 1]);
        f = this.interpolate(f, this.domain[n * 2], this.domain[n * 2 + 1], this.encode[n * 2], this.encode[n * 2 + 1]);
        f = this.min(this.max(f, 0.0f), this.size[n] - 1);
        return f;
    }

    private float decodeSample(float f, int n, int n2, int n3) {
        int n4 = (int)f;
        if (f - (float)((int)f) > 0.0f) {
            n4 = (int)f + 1;
        }
        float f2 = (float)n4 - f;
        float f3 = 1.0f - f2;
        int n5 = (int)f * n2 + n3;
        int n6 = n4 * n2 + n3;
        float f4 = f2 * this.samples[n5] + f3 * this.samples[n6];
        f4 = this.interpolate(f4, 0.0f, 1.0f, this.decode[n * 2], this.decode[n * 2 + 1]);
        f4 = this.min(this.max(f4, this.range[n * 2]), this.range[n * 2 + 1]);
        return f4;
    }

    private void setSize(PdfObjectReader pdfObjectReader) {
        String string = pdfObjectReader.getValue((String)this.tintTransform.get("Size"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
        this.size = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.size[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
    }

    private void setEncode(PdfObjectReader pdfObjectReader) {
        String string = (String)this.tintTransform.get("Encode");
        if (string != null) {
            string = pdfObjectReader.getValue(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            this.encode = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.encode[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            int n = this.size.length;
            this.encode = new float[n * 2];
            for (int i = 0; i < n; ++i) {
                this.encode[i * 2 + 1] = this.size[i] - 1;
            }
        }
    }

    private void setDecode(PdfObjectReader pdfObjectReader) {
        String string = (String)this.tintTransform.get("Decode");
        if (string != null) {
            string = pdfObjectReader.getValue(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
            this.decode = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.decode[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            int n = this.range.length;
            this.decode = new float[n];
            System.arraycopy(this.range, 0, this.decode, 0, n);
        }
    }

    private void setSamples(byte[] byArray) {
        this.samples = new float[byArray.length];
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            long l = 0L;
            long l2 = (1L << this.BitsPerSample) - 1L;
            float f = 1L << this.BitsPerSample;
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                while (n < this.BitsPerSample) {
                    l = (l << 8) + (long)((InputStream)byteArrayInputStream).read();
                    n += 8;
                }
                long l3 = l >> n - this.BitsPerSample & l2;
                n -= this.BitsPerSample;
                this.samples[i] = (float)l3 / f;
            }
            ((InputStream)byteArrayInputStream).close();
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " reading stream for separation colorspace");
        }
    }
}

