/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import jreepad.JreepadArticle;

public class JreepadNode
extends DefaultMutableTreeNode
implements Comparable {
    public JreepadNode() {
        this(new JreepadArticle());
    }

    public JreepadNode(String content) {
        this(new JreepadArticle(content));
    }

    public JreepadNode(String title, String content) {
        this(new JreepadArticle(title, content));
    }

    public JreepadNode(JreepadArticle article) {
        this.setUserObject(article);
    }

    public JreepadArticle getArticle() {
        return (JreepadArticle)this.getUserObject();
    }

    public String toFullString() {
        String ret = "JreepadNode \"" + this.getTitle() + "\": " + this.getChildCount() + " direct child nodes in subtree";
        ret = ret + "\nDirect children:";
        for (int i = 0; i < this.children.size(); ++i) {
            ret = ret + "\n    " + ((JreepadNode)this.getChildAt(i)).getTitle();
        }
        return ret;
    }

    public String getWikiAnchor() {
        if (this.getParent() == null) {
            return JreepadNode.htmlSpecialChars(this.getTitle());
        }
        return this.getParentNode().getWikiAnchor() + "/" + JreepadNode.htmlSpecialChars(this.getTitle());
    }

    private static String htmlSpecialChars(String in) {
        char[] c = in.toCharArray();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '<') {
                ret.append("&lt;");
                continue;
            }
            if (c[i] == '>') {
                ret.append("&gt;");
                continue;
            }
            if (c[i] == '&') {
                ret.append("&amp;");
                continue;
            }
            if (c[i] == '\n') {
                ret.append(" <br />\n");
                continue;
            }
            if (c[i] == '\"') {
                ret.append("&quot;");
                continue;
            }
            ret.append(c[i]);
        }
        return ret.toString();
    }

    public String exportTitlesAsList() {
        return this.exportTitlesAsList(0).toString();
    }

    private StringBuffer exportTitlesAsList(int currentDepth) {
        int i;
        StringBuffer ret = new StringBuffer();
        for (i = 0; i < currentDepth; ++i) {
            ret.append(" ");
        }
        ret.append(this.getTitle() + "\n");
        for (i = 0; i < this.children.size(); ++i) {
            ret.append(((JreepadNode)this.getChildAt(i)).exportTitlesAsList(currentDepth + 1));
        }
        return ret;
    }

    public String exportArticlesToText(boolean titlesToo) {
        return this.exportArticlesToTextRecursive(titlesToo).toString();
    }

    public StringBuffer exportArticlesToTextRecursive(boolean titlesToo) {
        StringBuffer ret = new StringBuffer();
        if (titlesToo) {
            ret.append(this.getTitle() + "\n\n");
        }
        ret.append(this.getArticle().getContent() + "\n\n");
        for (int i = 0; i < this.children.size(); ++i) {
            ret.append(((JreepadNode)this.getChildAt(i)).exportArticlesToTextRecursive(titlesToo));
        }
        return ret;
    }

    public JreepadNode removeChild(int child) {
        JreepadNode ret = (JreepadNode)this.getChildAt(child);
        this.remove(child);
        return ret;
    }

    public boolean indent() {
        int pos = this.getIndex();
        if (pos < 1) {
            return false;
        }
        MutableTreeNode oldParent = (MutableTreeNode)this.getParent();
        DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)oldParent.getChildAt(pos - 1);
        newParent.add(this);
        return true;
    }

    public boolean outdent() {
        JreepadNode p = (JreepadNode)this.getParent();
        if (p == null) {
            return false;
        }
        JreepadNode pp = (JreepadNode)p.getParent();
        if (pp == null) {
            return false;
        }
        int ppos = p.getIndex();
        p.removeChild(this.getIndex());
        pp.insert(this, ppos + 1);
        return true;
    }

    public void moveUp() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent == null) {
            return;
        }
        int index = this.getIndex();
        if (index < 1) {
            return;
        }
        parent.insert(this, index - 1);
    }

    public void moveDown() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent == null) {
            return;
        }
        int index = this.getIndex();
        if (index < 0 || index >= parent.getChildCount() - 1) {
            return;
        }
        parent.insert(this, index + 1);
    }

    public JreepadNode addChild() {
        JreepadNode theChild = new JreepadNode();
        this.add(theChild);
        return theChild;
    }

    public JreepadNode addChild(int index) {
        JreepadNode theChild = new JreepadNode();
        this.insert(theChild, index);
        return theChild;
    }

    public int getIndex() {
        if (this.getParent() == null) {
            return -1;
        }
        return this.getParent().getIndex(this);
    }

    public void sortChildrenRecursive() {
        this.sortChildren();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((JreepadNode)this.getChildAt(i)).sortChildrenRecursive();
        }
    }

    public void sortChildren() {
        Object[] childrenArray = this.children.toArray();
        Arrays.sort(childrenArray);
        this.removeAllChildren();
        for (int i = 0; i < childrenArray.length; ++i) {
            this.add((JreepadNode)childrenArray[i]);
        }
    }

    public int compareTo(Object o) {
        String a = this.getTitle();
        String b = ((JreepadNode)o).getTitle();
        if (a.length() != 0 && b.length() != 0 && Character.isDigit(a.charAt(0)) && Character.isDigit(b.charAt(0))) {
            int i;
            StringBuffer aBuf = new StringBuffer("");
            StringBuffer bBuf = new StringBuffer("");
            for (i = 0; i < a.length() && Character.isDigit(a.charAt(i)); ++i) {
                aBuf.append(a.charAt(i));
            }
            for (i = 0; i < b.length() && Character.isDigit(b.charAt(i)); ++i) {
                bBuf.append(b.charAt(i));
            }
            return new Integer(aBuf.toString()).compareTo(new Integer(bBuf.toString()));
        }
        return a.compareToIgnoreCase(b);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public JreepadNode getParentNode() {
        return (JreepadNode)this.getParent();
    }

    public void addChildFromTextFile(InputStreamReader textFile, String nodeName) throws IOException {
        String currentLine;
        StringBuffer contentString = new StringBuffer();
        BufferedReader bReader = new BufferedReader(textFile);
        while ((currentLine = bReader.readLine()) != null) {
            contentString.append(currentLine + "\n");
        }
        this.add(new JreepadNode(new JreepadArticle(nodeName, contentString.toString())));
    }

    public JreepadNode getCopy() {
        JreepadNode ret = new JreepadNode(this.getArticle());
        for (int i = 0; i < this.getChildCount(); ++i) {
            ret.add(((JreepadNode)this.getChildAt(i)).getCopy());
        }
        return ret;
    }

    public JreepadNode getChildByTitle(String title) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((JreepadNode)this.getChildAt(i)).getTitle().equals(title)) continue;
            return (JreepadNode)this.getChildAt(i);
        }
        return null;
    }

    public String getTitle() {
        return this.getArticle().getTitle();
    }

    public void setTitle(String title) {
        this.getArticle().setTitle(title);
    }

    public String getContent() {
        return this.getArticle().getContent();
    }
}

