/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import jreepad.JreepadViewer;

public class OSXAdapter
extends ApplicationAdapter {
    private static OSXAdapter theAdapter;
    private static Application theApplication;
    private JreepadViewer mainApp;

    private OSXAdapter(JreepadViewer inApp) {
        this.mainApp = inApp;
    }

    public void handleAbout(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleAbout: JreepadViewer instance detached from listener");
        }
        ae.setHandled(true);
        this.mainApp.about();
    }

    public void handlePreferences(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handlePreferences: JreepadViewer instance detached from listener");
        }
        this.mainApp.preferences();
        ae.setHandled(true);
    }

    public void handleOpenFile(ApplicationEvent ae) {
        this.mainApp.openFile(new File(ae.getFilename()));
    }

    public void handleQuit(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleQuit: JreepadViewer instance detached from listener");
        }
        ae.setHandled(false);
        this.mainApp.quit();
    }

    public static void registerMacOSXApplication(JreepadViewer inApp) {
        if (theApplication == null) {
            theApplication = new Application();
        }
        if (theAdapter == null) {
            theAdapter = new OSXAdapter(inApp);
        }
        theApplication.addApplicationListener((ApplicationListener)theAdapter);
    }

    public static void enablePrefs(boolean enabled) {
        if (theApplication == null) {
            theApplication = new Application();
        }
        theApplication.setEnabledPreferencesMenu(enabled);
    }
}

