/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import jreepad.JreepadPrefs;
import jreepad.JreepadSearcher;
import jreepad.JreepadView;
import jreepad.JreepadViewer;

public class SearchDialog
extends JDialog {
    private JTextField nodeSearchField;
    private JComboBox searchWhereSelector;
    private JSpinner searchMaxNumSpinner;
    private JCheckBox searchCaseCheckBox;
    private AbstractTableModel searchResultsTableModel;
    private JTable searchResultsTable;
    private JScrollPane searchResultsTableScrollPane;
    private JLabel searchResultsLabel;
    private JreepadView theJreepad;

    public SearchDialog(Frame owner, JreepadView theJreepad) {
        super(owner, JreepadViewer.lang.getString("SEARCH_WINDOWTITLE"), false);
        this.theJreepad = theJreepad;
        this.setVisible(false);
        Box vBox = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        this.nodeSearchField = new JTextField("");
        vBox.add(new JLabel(JreepadViewer.lang.getString("SEARCH_SEARCHFOR")));
        hBox.add(this.nodeSearchField);
        this.nodeSearchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.doTheSearch();
            }
        });
        this.nodeSearchField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                SearchDialog.this.doTheSearch();
            }
        });
        vBox.add(hBox);
        this.searchWhereSelector = new JComboBox<String>(new String[]{JreepadViewer.lang.getString("SEARCH_SELECTEDNODE"), JreepadViewer.lang.getString("SEARCH_WHOLETREE")});
        this.searchWhereSelector.setSelectedIndex(1);
        this.searchWhereSelector.setEditable(false);
        this.searchWhereSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.doTheSearch();
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(new JLabel(JreepadViewer.lang.getString("SEARCH_SEARCHWHERE")));
        hBox.add(this.searchWhereSelector);
        hBox.add(Box.createGlue());
        this.searchCaseCheckBox = new JCheckBox(JreepadViewer.lang.getString("SEARCH_CASESENSITIVE"), false);
        hBox.add(this.searchCaseCheckBox);
        this.searchCaseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.doTheSearch();
            }
        });
        hBox.add(Box.createGlue());
        vBox.add(hBox);
        this.searchMaxNumSpinner = new JSpinner(new SpinnerNumberModel(SearchDialog.getPrefs().searchMaxNum, 1, 1000, 1));
        this.searchMaxNumSpinner.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SearchDialog.this.doTheSearch();
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createGlue());
        hBox.add(new JLabel(JreepadViewer.lang.getString("SEARCH_MAXRESULTS")));
        hBox.add(this.searchMaxNumSpinner);
        hBox.add(Box.createGlue());
        vBox.add(hBox);
        this.searchResultsTableModel = new AbstractTableModel(){
            private final String[] columns = new String[]{JreepadViewer.lang.getString("SEARCH_TBL_COL_NODE"), JreepadViewer.lang.getString("SEARCH_TBL_COL_ARTICLETEXT"), JreepadViewer.lang.getString("SEARCH_TBL_COL_FULLPATH")};

            public int getColumnCount() {
                return this.columns.length;
            }

            public String getColumnName(int index) {
                return this.columns[index];
            }

            public int getRowCount() {
                JreepadSearcher.JreepadSearchResult[] results = SearchDialog.this.theJreepad.getSearchResults();
                if (results == null || results.length == 0) {
                    return 1;
                }
                return results.length;
            }

            public Object getValueAt(int row, int col) {
                JreepadSearcher.JreepadSearchResult[] results = SearchDialog.this.theJreepad.getSearchResults();
                if (results == null || results.length == 0) {
                    switch (col) {
                        case 2: {
                            return "";
                        }
                        case 1: {
                            return SearchDialog.this.nodeSearchField.getText() == "" ? JreepadViewer.lang.getString("SEARCH_TBL_BEFORERESULTS") : JreepadViewer.lang.getString("SEARCH_TBL_NORESULTS");
                        }
                    }
                    return "";
                }
                switch (col) {
                    case 2: {
                        return results[row].getTreePath();
                    }
                    case 1: {
                        return results[row].getArticleQuote();
                    }
                }
                return results[row].getNode().getTitle();
            }
        };
        this.searchResultsTable = new JTable(this.searchResultsTableModel);
        this.searchResultsTable.setCellSelectionEnabled(false);
        this.searchResultsTable.setColumnSelectionAllowed(false);
        this.searchResultsTable.setRowSelectionAllowed(true);
        this.searchResultsTable.setSelectionMode(0);
        this.searchResultsTableScrollPane = new JScrollPane(this.searchResultsTable);
        this.searchResultsLabel = new JLabel(JreepadViewer.lang.getString("SEARCH_RESULTS"));
        vBox.add(this.searchResultsLabel);
        vBox.add(this.searchResultsTableScrollPane);
        MouseAdapter sml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SearchDialog.this.mouseClickedOnSearchResultsTable(e);
            }
        };
        this.searchResultsTable.addMouseListener(sml);
        this.getContentPane().add(vBox);
        KeyAdapter searchKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent eek) {
                switch (eek.getKeyCode()) {
                    case 27: {
                        SearchDialog.this.setVisible(false);
                        break;
                    }
                    case 87: {
                        if (!eek.isControlDown() && !eek.isMetaDown()) break;
                        SearchDialog.this.setVisible(false);
                    }
                }
            }
        };
        this.addKeyListener(searchKeyListener);
        this.nodeSearchField.addKeyListener(searchKeyListener);
        this.searchCaseCheckBox.addKeyListener(searchKeyListener);
        this.searchWhereSelector.addKeyListener(searchKeyListener);
        this.searchResultsTable.addKeyListener(searchKeyListener);
        this.searchMaxNumSpinner.addKeyListener(searchKeyListener);
        this.searchResultsTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent eek) {
                switch (eek.getKeyCode()) {
                    case 10: 
                    case 32: {
                        SearchDialog.this.mouseClickedOnSearchResultsTable(null);
                    }
                }
            }
        });
    }

    private void doTheSearch() {
        SearchDialog.getPrefs().searchMaxNum = (Integer)this.searchMaxNumSpinner.getValue();
        this.performSearch(this.nodeSearchField.getText(), this.nodeSearchField.getText(), this.searchWhereSelector.getSelectedIndex(), true, this.searchCaseCheckBox.isSelected(), SearchDialog.getPrefs().searchMaxNum);
    }

    private boolean performSearch(String inNodes, String inArticles, int searchWhat, boolean orNotAnd, boolean caseSensitive, int maxResults) {
        boolean ret = this.theJreepad.performSearch(inNodes, inArticles, searchWhat, orNotAnd, caseSensitive, maxResults);
        if (!ret) {
            this.searchResultsLabel.setText(JreepadViewer.lang.getString("SEARCH_RESULTS"));
        } else {
            this.searchResultsLabel.setText(JreepadViewer.lang.getString("SEARCH_RESULTS") + this.theJreepad.getSearchResults().length + JreepadViewer.lang.getString("SEARCH_NODES_MATCHED"));
        }
        this.searchResultsTableModel.fireTableStructureChanged();
        return ret;
    }

    private void mouseClickedOnSearchResultsTable(MouseEvent e) {
        JreepadSearcher.JreepadSearchResult[] results = this.theJreepad.getSearchResults();
        int selectedRow = this.searchResultsTable.getSelectedRow();
        if (results == null || results.length == 0 || selectedRow == -1) {
            return;
        }
        this.theJreepad.getTree().setSelectionPath(results[selectedRow].getTreePath());
        this.theJreepad.getTree().scrollPathToVisible(results[selectedRow].getTreePath());
    }

    private static JreepadPrefs getPrefs() {
        return JreepadView.getPrefs();
    }

    public void setJreepad(JreepadView theJreepad) {
        this.theJreepad = theJreepad;
    }

    public void open() {
        this.setVisible(true);
        this.nodeSearchField.requestFocus();
        this.nodeSearchField.setSelectionStart(0);
    }
}

