/*
 * Decompiled with CFR 0.152.
 */
package jreepad.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class EditPopupHandler
extends MouseAdapter {
    private JPopupMenu popupMenu = new JPopupMenu();
    public static final String ITEM_CUT = "cut";
    public static final String ITEM_COPY = "copy";
    public static final String ITEM_PASTE = "paste";
    private final Map itemMap = new HashMap();

    public EditPopupHandler() {
        this.itemMap.put(ITEM_COPY, null);
        this.itemMap.put(ITEM_CUT, null);
        this.itemMap.put(ITEM_PASTE, null);
    }

    public void addActionItem(TextAction action, String menuLabel, String type) {
        JMenuItem item = new JMenuItem(action);
        item.setText(menuLabel);
        this.popupMenu.add(item);
        if (this.itemMap.containsKey(type)) {
            this.itemMap.put(type, item);
        }
    }

    private void enableMenuItems(MouseEvent e) {
        Clipboard clipboard;
        Transferable contents;
        JTextComponent textComp = (JTextComponent)e.getComponent();
        String selectedText = textComp.getSelectedText();
        boolean textSelected = selectedText != null && selectedText.length() > 0;
        boolean isEditable = textComp.isEditable();
        JMenuItem item = (JMenuItem)this.itemMap.get(ITEM_COPY);
        if (item != null) {
            item.setEnabled(textSelected);
        }
        if ((item = (JMenuItem)this.itemMap.get(ITEM_CUT)) != null) {
            item.setEnabled(textSelected && isEditable);
        }
        boolean hasTransferableText = (contents = (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(null)) != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        item = (JMenuItem)this.itemMap.get(ITEM_PASTE);
        if (item != null) {
            item.setEnabled(hasTransferableText && isEditable);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            this.enableMenuItems(e);
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

