/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.InputStream;
import jreepad.JreepadTreeModel;
import jreepad.io.EncryptedReader;
import jreepad.io.JreepadReader;
import jreepad.io.TreepadReader;
import jreepad.io.XmlReader;
import jreepad.ui.PasswordDialog;

public class AutoDetectReader
implements JreepadReader {
    XmlReader xmlReader = new XmlReader();
    TreepadReader treepadReader;
    EncryptedReader encryptedReader;

    public AutoDetectReader(String encoding, boolean autoDetectHtmlArticles) {
        this.treepadReader = new TreepadReader(encoding, autoDetectHtmlArticles);
        this.encryptedReader = new EncryptedReader(this);
    }

    public JreepadTreeModel read(InputStream in) throws IOException {
        in = new RewindableInputStream(in);
        String currentLine = ((RewindableInputStream)in).readLine();
        in.reset();
        if (currentLine.startsWith("<?xml")) {
            return this.xmlReader.read(in);
        }
        if (currentLine.toLowerCase().startsWith("<treepad") && currentLine.endsWith(">")) {
            this.treepadReader.setFileFormat(1);
            return this.treepadReader.read(in);
        }
        if (currentLine.toLowerCase().startsWith("<hj-treepad") && currentLine.endsWith(">")) {
            this.treepadReader.setFileFormat(1);
            return this.treepadReader.read(in);
        }
        if (currentLine.startsWith("JreepadEncrypted")) {
            String password = PasswordDialog.showPasswordDialog("This file is encrypted. Please enter password:");
            if (password == null) {
                throw new IOException("Could not decrypt. No password entered.");
            }
            this.encryptedReader.setPassword(password);
            return this.encryptedReader.read(in);
        }
        System.out.println("First line of file does not indicate a recognised format:\n" + currentLine + "\n");
        throw new IOException("First line of file does not indicate a recognised format:\n\n" + currentLine);
    }

    public boolean isAutoDetectHtmlArticles() {
        return this.treepadReader.isAutoDetectHtmlArticles();
    }

    public void setAutoDetectHtmlArticles(boolean autoDetectHtmlArticles) {
        this.treepadReader.setAutoDetectHtmlArticles(autoDetectHtmlArticles);
    }

    public String getEncoding() {
        return this.treepadReader.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.treepadReader.setEncoding(encoding);
    }

    protected static class RewindableInputStream
    extends InputStream {
        private static int BUFFER_SIZE = 2048;
        private InputStream fInputStream;
        private byte[] fData = new byte[BUFFER_SIZE];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream is) {
            this.fInputStream = is;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int offset) {
            this.fStartOffset = offset;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
            System.out.println("Rewinding " + this.fOffset + "/" + this.fLength + " -> " + this.fStartOffset + "(end=" + this.fEndOffset + ")");
        }

        public int read() throws IOException {
            int b = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] newData = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, newData, 0, this.fOffset);
                this.fData = newData;
            }
            if ((b = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)b;
            ++this.fOffset;
            return b & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.read(b, off, len);
            }
            if (len < bytesLeft) {
                if (len <= 0) {
                    return 0;
                }
            } else {
                len = bytesLeft;
            }
            if (b != null) {
                System.arraycopy(this.fData, this.fOffset, b, off, len);
            }
            this.fOffset += len;
            return len;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(n);
            }
            if (n <= (long)bytesLeft) {
                this.fOffset = (int)((long)this.fOffset + n);
                return n;
            }
            this.fOffset += bytesLeft;
            if (this.fOffset == this.fEndOffset) {
                return bytesLeft;
            }
            return this.fInputStream.skip(n -= (long)bytesLeft) + (long)bytesLeft;
        }

        public int available() throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.available();
            }
            return bytesLeft;
        }

        public void mark(int howMuch) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }

        public String readLine() throws IOException {
            int ret;
            int len;
            byte[] bytes = new byte[BUFFER_SIZE];
            for (len = 0; len < BUFFER_SIZE && (ret = this.read()) != -1 && ret != 10 && ret != 13; ++len) {
                bytes[len] = (byte)(ret & 0xFF);
            }
            return new String(bytes, 0, len);
        }
    }
}

