/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import jreepad.JreepadTreeModel;
import jreepad.io.JreepadWriter;

public class EncryptedWriter
implements JreepadWriter {
    static final String ALGORITHM = "Blowfish";
    static final String HEADER = "JreepadEncrypted";
    private JreepadWriter writer;
    private String password = "";

    public EncryptedWriter(JreepadWriter writer) {
        this.writer = writer;
    }

    public void write(OutputStream out, JreepadTreeModel document) throws IOException {
        out.write(HEADER.getBytes());
        out.write("\n".getBytes());
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM);
            SecretKeySpec key = new SecretKeySpec(this.password.getBytes(), ALGORITHM);
            cipher.init(1, key);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.toString());
        }
        CipherOutputStream out2 = new CipherOutputStream(out, cipher);
        this.writer.write(out2, document);
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

