/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import jreepad.JreepadNode;
import jreepad.JreepadTreeModel;
import jreepad.io.JreepadWriter;

public class HtmlWriter
implements JreepadWriter {
    private String encoding;
    private int exportMode;
    private boolean urlsToLinks;
    private int anchorType;
    private boolean causeToPrint;

    public HtmlWriter(String encoding, int exportMode, boolean urlsToLinks, int anchorType) {
        this(encoding, exportMode, urlsToLinks, anchorType, false);
    }

    public HtmlWriter(String encoding, int exportMode, boolean urlsToLinks, int anchorType, boolean causeToPrint) {
        this.encoding = encoding;
        this.exportMode = exportMode;
        this.urlsToLinks = urlsToLinks;
        this.anchorType = anchorType;
        this.causeToPrint = causeToPrint;
    }

    public void write(OutputStream out, JreepadTreeModel document) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.encoding);
        this.write(writer, document.getRootNode());
        out.close();
    }

    public String write(JreepadNode node) {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer, node);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return ((Object)writer).toString();
    }

    public void write(Writer writer, JreepadNode node) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\n<head>\n<title>");
        writer.write(HtmlWriter.htmlSpecialChars(node.getTitle()));
        writer.write("</title>\n<style type=\"text/css\">\ndl {}\ndl dt { font-weight: bold; margin-top: 10px; font-size: 24pt; }\ndl dd {margin-left: 20px; padding-left: 0px;}\ndl dd dl dt {background: black; color: white; font-size: 12pt; }\ndl dd dl dd dl dt {background: white; color: black; }\n</style>\n</head>\n\n<body" + (this.causeToPrint ? " onload='print();'" : "") + ">\n<!-- Exported from Jreepad -->\n<dl>");
        this.writeNode(writer, node);
        writer.write("\n</dl>\n</body>\n</html>");
    }

    public void writeNode(Writer writer, JreepadNode node) throws IOException {
        writer.write("\n<dt><a name=\"");
        if (this.anchorType == 1) {
            writer.write(node.getTitle());
        } else {
            writer.write(node.getWikiAnchor());
        }
        writer.write("\"></a>");
        writer.write(HtmlWriter.htmlSpecialChars(node.getTitle()));
        writer.write("</dt>\n<dd>");
        writer.write(node.getArticle().toHtml(this.exportMode, this.urlsToLinks, this.anchorType));
        if (node.getChildCount() > 0) {
            writer.write("\n<dl>");
        }
        Enumeration<TreeNode> kids = node.children();
        while (kids.hasMoreElements()) {
            this.writeNode(writer, (JreepadNode)kids.nextElement());
        }
        if (node.getChildCount() > 0) {
            writer.write("\n</dl>");
        }
        writer.write("</dd>");
    }

    private static String htmlSpecialChars(String in) {
        char[] c = in.toCharArray();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '<') {
                ret.append("&lt;");
                continue;
            }
            if (c[i] == '>') {
                ret.append("&gt;");
                continue;
            }
            if (c[i] == '&') {
                ret.append("&amp;");
                continue;
            }
            if (c[i] == '\n') {
                ret.append(" <br />\n");
                continue;
            }
            if (c[i] == '\"') {
                ret.append("&quot;");
                continue;
            }
            ret.append(c[i]);
        }
        return ret.toString();
    }

    public int getAnchorType() {
        return this.anchorType;
    }

    public void setAnchorType(int anchorType) {
        this.anchorType = anchorType;
    }

    public boolean isCauseToPrint() {
        return this.causeToPrint;
    }

    public void setCauseToPrint(boolean causeToPrint) {
        this.causeToPrint = causeToPrint;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getExportMode() {
        return this.exportMode;
    }

    public void setExportMode(int exportMode) {
        this.exportMode = exportMode;
    }

    public boolean isUrlsToLinks() {
        return this.urlsToLinks;
    }

    public void setUrlsToLinks(boolean urlsToLinks) {
        this.urlsToLinks = urlsToLinks;
    }
}

