/*
 * Decompiled with CFR 0.152.
 */
package jreepad.ui;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jreepad.ui.ExtensionFileFilter;

public class SaveFileChooser
extends JFileChooser {
    protected static final ResourceBundle LANG = ResourceBundle.getBundle("jreepad.lang.JreepadStrings");
    public static final FileFilter JREEPAD_FILE_FILTER = new ExtensionFileFilter("Jreepad XML file (*.jree)", "jree");
    public static final FileFilter TREEPAD_FILE_FILTER = new ExtensionFileFilter("Treepad file (*.hjt)", "hjt");
    public static final FileFilter JREEPAD_ENCRYPTED_FILE_FILTER = new ExtensionFileFilter("Jreepad Encrypted XML file (*.jree) [EXPERIMENTAL]", "jree");
    private int defaultFileFormat;

    public SaveFileChooser(int defaultFileFormat) {
        this.defaultFileFormat = defaultFileFormat;
        this.addChoosableFileFilter(JREEPAD_FILE_FILTER);
        this.addChoosableFileFilter(JREEPAD_ENCRYPTED_FILE_FILTER);
        this.addChoosableFileFilter(TREEPAD_FILE_FILTER);
        switch (defaultFileFormat) {
            case 1: {
                this.setFileFilter(TREEPAD_FILE_FILTER);
                break;
            }
            case 2: {
                this.setFileFilter(JREEPAD_ENCRYPTED_FILE_FILTER);
                break;
            }
            default: {
                this.setFileFilter(JREEPAD_FILE_FILTER);
            }
        }
    }

    public int getFileType() {
        if (this.getFileFilter() == JREEPAD_FILE_FILTER) {
            return 0;
        }
        if (this.getFileFilter() == TREEPAD_FILE_FILTER) {
            return 1;
        }
        if (this.getFileFilter() == JREEPAD_ENCRYPTED_FILE_FILTER) {
            return 2;
        }
        return this.defaultFileFormat;
    }

    public void approveSelection() {
        if (!this.checkOverwrite(this.getSelectedFile())) {
            return;
        }
        if (this.getSelectedFile().isFile() && !this.getSelectedFile().canWrite()) {
            JOptionPane.showMessageDialog(this, LANG.getString("MSG_FILE_NOT_WRITEABLE"), LANG.getString("TITLE_FILE_ERROR"), 0);
            return;
        }
        super.approveSelection();
    }

    private boolean checkOverwrite(File theFile) {
        if (theFile == null || !theFile.exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(this, LANG.getString("PROMPT_CONFIRM_OVERWRITE1") + " " + theFile.getName() + " " + LANG.getString("PROMPT_CONFIRM_OVERWRITE2"), LANG.getString("TITLE_CONFIRM_OVERWRITE"), 0) == 0;
    }
}

