/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import com.jhlabs.composite.MiscCompositeContext;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class MiscComposite
implements Composite {
    public static final int BLEND = 0;
    public static final int ADD = 1;
    public static final int SUBTRACT = 2;
    public static final int DIFFERENCE = 3;
    public static final int MULTIPLY = 4;
    public static final int DARKEN = 5;
    public static final int BURN = 6;
    public static final int COLOR_BURN = 7;
    public static final int SCREEN = 8;
    public static final int LIGHTEN = 9;
    public static final int DODGE = 10;
    public static final int COLOR_DODGE = 11;
    public static final int HUE = 12;
    public static final int SATURATION = 13;
    public static final int VALUE = 14;
    public static final int COLOR = 15;
    public static final int OVERLAY = 16;
    public static final int SOFT_LIGHT = 17;
    public static final int HARD_LIGHT = 18;
    public static final int PIN_LIGHT = 19;
    public static final int EXCLUSION = 20;
    public static final int NEGATION = 21;
    public static final int AVERAGE = 22;
    public static final int STENCIL = 23;
    public static final int SILHOUETTE = 24;
    private static final int MIN_RULE = 0;
    private static final int MAX_RULE = 24;
    public static String[] RULE_NAMES = new String[]{"Normal", "Add", "Subtract", "Difference", "Multiply", "Darken", "Burn", "Color Burn", "Screen", "Lighten", "Dodge", "Color Dodge", "Hue", "Saturation", "Brightness", "Color", "Overlay", "Soft Light", "Hard Light", "Pin Light", "Exclusion", "Negation", "Average", "Stencil", "Silhouette"};
    protected float extraAlpha;
    protected int rule;

    private MiscComposite(int n) {
        this(n, 1.0f);
    }

    private MiscComposite(int n, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("alpha value out of range");
        }
        if (n < 0 || n > 24) {
            throw new IllegalArgumentException("unknown composite rule");
        }
        this.rule = n;
        this.extraAlpha = f;
    }

    public static Composite getInstance(int n, float f) {
        switch (n) {
            case 0: {
                return AlphaComposite.getInstance(3, f);
            }
            case 23: {
                return AlphaComposite.getInstance(6, f);
            }
            case 24: {
                return AlphaComposite.getInstance(8, f);
            }
        }
        return new MiscComposite(n, f);
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return new MiscCompositeContext(this.rule, this.extraAlpha, colorModel, colorModel2);
    }

    public float getAlpha() {
        return this.extraAlpha;
    }

    public int getRule() {
        return this.rule;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.extraAlpha) * 31 + this.rule;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MiscComposite)) {
            return false;
        }
        MiscComposite miscComposite = (MiscComposite)object;
        if (this.rule != miscComposite.rule) {
            return false;
        }
        return this.extraAlpha == miscComposite.extraAlpha;
    }
}

