/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.EnumSet;
import makagiga.sdk.SDK;
import org.makagiga.MainWindow;
import org.makagiga.Vars;
import org.makagiga.commons.Args;
import org.makagiga.commons.Config;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.UI;
import org.makagiga.console.Console;
import org.makagiga.desktop.Desktop;
import org.makagiga.internetsearch.InternetSearchPlugin;
import org.makagiga.plugins.LookAndFeelSettings;
import org.makagiga.plugins.PluginDownloader;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.search.Index;
import org.makagiga.tools.Armor;

public final class Main
extends MApplication {
    public static final void main(String ... stringArray) {
        Config config;
        int n;
        if (Main.mainSDK(stringArray)) {
            return;
        }
        Main.addConfigEntries(Desktop.class);
        Main.addConfigEntries(Vars.class);
        Main.init(stringArray, "makagiga", Main.class);
        Main.initArgs();
        if (!Main.checkOneInstance()) {
            return;
        }
        Main.initPlatform(EnumSet.allOf(MApplication.Init.class));
        Color color = Main.getLightBrandColor();
        Desktop.backgroundColor.setDefaultValue(color);
        if (Main.isFirstRun() && Desktop.backgroundColor.equalsValue(MColor.SKY_BLUE)) {
            Desktop.backgroundColor.set(color);
        }
        if ((n = (config = Config.getDefault()).readInt("lastVersion", 0)) != (Integer)Main.getInternalVersion().get()) {
            MLogger.info("core", "Version changed: %s -> %s", n, Main.getInternalVersion().get());
            config.write("lastVersion", Main.getInternalVersion());
            config.write("updatePlugins", n != 0);
            config.sync();
            if (n == 0) {
                MLogger.info("core", "Fixing cache...");
                FileCache.getInstance().clear();
                Index.getInstance().clear();
            }
            if (n < 131328) {
                MLogger.info("core", "Fixing cache directory...");
                FileCache.getInstance().fixCacheDirectory();
            }
            if (n < 198402) {
                MLogger.info("core", "Fixing search-index cache...");
                Index.getInstance().clear();
            }
        }
        Main.initSecurityManager();
        Main.initPlugins();
        Console.init();
        Main.launch(Main.class);
    }

    @Override
    protected void startup() {
        if (!Main.isSafeMode()) {
            LookAndFeelSettings.applyLookAndFeel();
        }
        MainWindow mainWindow = MainWindow.getInstance();
        if (Config.getDefault().read("updatePlugins", false)) {
            if (mainWindow.isLocked()) {
                mainWindow.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("locked".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                            MainWindow.getInstance().removePropertyChangeListener(this);
                            Main.updatePlugins();
                        }
                    }
                });
            } else {
                Main.updatePlugins();
            }
        }
        Main.addShutDownListener(new MApplication.ShutDownListener(){

            @Override
            public void shutDown(MApplication.ShutDownEvent shutDownEvent) {
                Index.getInstance().shutDown();
                if (MainWindow.isInstance()) {
                    MainWindow.getInstance().saveSession(2);
                }
            }
        });
    }

    private static void initArgs() {
        Args.add("autostart", UI._("Start application in minimized or hidden window"));
        Args.add("full-screen", UI._("Start application in full screen window"));
        Args.add("presentation", UI._("Start application in full screen \"presentation\" mode"));
        Args.add("test-plugin", "Used internally by the Makagiga SDK");
        Args.add("test-sdk", "Used internally to test Makagiga SDK");
    }

    private static void initPlugins() {
        PluginManager.init(Vars.armorEnabled.get());
        PluginManager pluginManager = PluginManager.getInstance();
        pluginManager.registerInternal("org/makagiga/desktop/calendar");
        pluginManager.registerInternal("org/makagiga/desktop/internetsearch");
        pluginManager.registerInternal("org/makagiga/desktop/note");
        pluginManager.registerInternal("org/makagiga/desktop/todo");
        pluginManager.registerInternal("org/makagiga/editors/image");
        pluginManager.registerInternal("org/makagiga/editors/link");
        pluginManager.registerInternal("org/makagiga/editors/notepad");
        pluginManager.registerInternal("org/makagiga/editors/text");
        pluginManager.registerInternal("org/makagiga/editors/todo");
        pluginManager.registerInternal("org/makagiga/fs/feeds");
        pluginManager.registerInternal("org/makagiga/fs/trash");
        pluginManager.registerInternal("org/makagiga/tools/backup");
        pluginManager.registerInternal("org/makagiga/tools/deleteprivatedata");
        pluginManager.registerInternal("org/makagiga/tools/stats");
        pluginManager.registerInternal("org/makagiga/tools/update");
        InternetSearchPlugin.init();
        String string = Args.getOption("test-plugin");
        if (string != null) {
            MLogger.developer.set(true);
            MLogger.info("plugin", "Testing \"%s\" plugin...", string);
            if (!pluginManager.registerExternal(string, 2)) {
                MMessage.error(null, "Cannot register plugin.\nTry to uninstall current plugin before test.\nSee \"standard output\" log messages for more details...");
            }
        }
    }

    private static void initSecurityManager() {
        if (Vars.armorEnabled.get().booleanValue()) {
            Armor.init();
        } else {
            System.setSecurityManager(null);
        }
    }

    private static boolean mainSDK(String ... stringArray) {
        if (stringArray.length > 0) {
            if ("--test-profile".equals(stringArray[0])) {
                System.out.println("Press Enter to continue...");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if ("--test-sdk".equals(stringArray[0])) {
                SDK.main((String[])new String[]{"--base-dir", "./sdk/SDK"});
                return true;
            }
        }
        return false;
    }

    private static void updatePlugins() {
        MLogger.info("core", "Starting plugin update");
        Config config = Config.getDefault();
        config.write("updatePlugins", false);
        config.sync();
        int n = 0;
        for (PluginInfo pluginInfo : PluginManager.getTable()) {
            if (pluginInfo.isInternal()) continue;
            ++n;
        }
        if (n > 0) {
            MNotification.Message message = new MNotification.Message();
            message.setAction(new MAction(UI._("Update"), "ui/refresh"){

                @Override
                public void onAction() {
                    PluginDownloader.update(MainWindow.getInstance());
                }
            });
            message.setText(UI._("Click here to update plugins"));
            MNotification.showMessage(message);
        }
    }
}

