/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;

public abstract class AbstractProperty<T>
implements PropertyAccess<T> {
    protected PropertyChangeSupport propertyChangeSupport;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
            }
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.propertyChangeSupport == null) {
            return TK.EMPTY_PROPERTY_CHANGE_LISTENER_ARRAY;
        }
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    @Deprecated
    public void clear() {
        this.set(null);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WTFError(cloneNotSupportedException);
        }
    }

    @Override
    public int compareTo(PropertyAccess<T> propertyAccess) {
        Object t = this.get();
        if (t instanceof Comparable) {
            return ((Comparable)Comparable.class.cast(t)).compareTo(propertyAccess.get());
        }
        throw new UnsupportedOperationException("Property value does not implement \"Comparable\" interface");
    }

    @Override
    public int hashCode() {
        Object t = this.get();
        return t == null ? 0 : t.hashCode();
    }

    @Override
    public boolean isNull() {
        return this.get() == null;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void parse(String string) throws ParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.set(this.getDefaultValue());
    }

    @Override
    public String toString() {
        Object t = this.get();
        return t == null ? null : t.toString();
    }
}

