/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.makagiga.commons.AbstractProperty;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MObject;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;

public class BeanProperty<T>
extends AbstractProperty<T>
implements PropertyChangeListener {
    private Class<T> type;
    private Method getter;
    private Method setter;
    private Object object;
    private String name;
    private T defaultValue;

    public BeanProperty(Object object, Class<T> clazz, String string) {
        this.object = TK.checkNull(object);
        this.type = TK.checkNull(clazz);
        this.name = TK.checkNullOrEmpty(string);
        Class<?> clazz2 = object.getClass();
        this.getter = BeanProperty.getGetter(clazz2, string);
        this.setter = BeanProperty.getSetter(clazz2, string, clazz);
        this.defaultValue = this.get();
    }

    public BeanProperty(Object object, Class<T> clazz, String string, Method method, Method method2) {
        this.object = TK.checkNull(object);
        this.type = TK.checkNull(clazz);
        this.name = TK.checkNullOrEmpty(string);
        this.getter = method;
        this.setter = method2;
        this.defaultValue = this.get();
    }

    public BeanProperty(Object object, PropertyDescriptor propertyDescriptor) {
        this(object, propertyDescriptor.getPropertyType(), propertyDescriptor.getName(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
    }

    public boolean canRead() {
        return this.getter != null;
    }

    public boolean canWrite() {
        return this.setter != null;
    }

    public static Method getGetter(Class<?> clazz, String string) {
        String string2 = TK.capitalize(string);
        try {
            Method method = BeanProperty.getGetter(clazz, "is", string2);
            if (method == null) {
                method = BeanProperty.getGetter(clazz, "get", string2);
            }
            return method;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getObject() {
        return this.object;
    }

    public static Method getSetter(Class<?> clazz, String string, Class<?> clazz2) {
        String string2 = "set" + TK.capitalize(string);
        try {
            return clazz.getMethod(string2, clazz2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyAccess)) {
            return false;
        }
        PropertyAccess propertyAccess = (PropertyAccess)object;
        return MObject.safeEquals(this.get(), propertyAccess.get());
    }

    @Override
    public T get() {
        if (!this.canRead()) {
            return null;
        }
        try {
            return (T)this.getter.invoke(this.object, new Object[0]);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return null;
        }
    }

    @Override
    public void set(T t) {
        if (!this.canWrite()) {
            return;
        }
        try {
            this.setter.invoke(this.object, t);
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue() {
        return MObject.safeEquals(this.get(), this.getDefaultValue());
    }

    @Override
    public void setDefaultValue(T t) {
        this.defaultValue = t;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canWrite();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    private static Method getGetter(Class<?> clazz, String string, String string2) {
        try {
            return clazz.getMethod(string + string2, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

