/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.text.ParseException;
import org.makagiga.commons.Property;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;

public class EnumProperty<E extends Enum<?>>
extends Property<E> {
    private Class<E> type;
    private E[] enumValues;

    public static <E extends Enum<?>> EnumProperty<E> create(E e) {
        return new EnumProperty<E>(e);
    }

    public static <E extends Enum<?>> EnumProperty<E> create(E e, Class<E> clazz) {
        return new EnumProperty<E>(e, clazz);
    }

    @Deprecated
    public static <E extends Enum<?>> EnumProperty<E> create(E e, E[] EArray) {
        return new EnumProperty(e, EArray);
    }

    public E[] getEnumValues() {
        return TK.copyOf(this.initEnumValues());
    }

    public boolean hasEnumValues() {
        return this.initEnumValues() != null;
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    @Override
    public void parse(String string) throws ParseException {
        this.set(string);
    }

    public static <T extends Enum<T>> T parse(String string, T t) {
        if (string == null) {
            return t;
        }
        try {
            return (T)Enum.valueOf(t.getClass(), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return t;
        }
    }

    @Override
    public void set(String string) {
        EnumProperty.set(this, string);
    }

    public static <E extends Enum<?>> void set(PropertyAccess<E> propertyAccess, String string) {
        try {
            Enum enum_ = (Enum)propertyAccess.get();
            propertyAccess.set(Enum.valueOf(enum_.getClass(), string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            propertyAccess.reset();
        }
    }

    @Override
    public String toString() {
        return ((Enum)this.get()).name();
    }

    protected EnumProperty(E e) {
        this((Enum)e, null);
    }

    protected EnumProperty(E e, Class<E> clazz) {
        super(e);
        this.type = clazz;
    }

    @Deprecated
    protected EnumProperty(E e, E[] EArray) {
        super(e);
        this.enumValues = (Enum[])TK.copyOf(EArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E[] initEnumValues() {
        if (this.type == null) {
            return null;
        }
        EnumProperty enumProperty = this;
        synchronized (enumProperty) {
            if (this.enumValues == null) {
                this.enumValues = (Enum[])this.type.getEnumConstants();
            }
            return this.enumValues;
        }
    }
}

