/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.makagiga.commons.AbstractFileCache;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.Pair;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.XMLBuilder;

public class FileCache
extends AbstractFileCache<String, Item> {
    public static final long IGNORE_DATE = Long.MIN_VALUE;
    public static final long NO_DATE = 0L;

    public File createFile(String string, long l, String string2, String string3) throws IOException {
        if (l == 0L) {
            this.log.infoFormat("File with \"zero\" date will not be cached: %s", string);
            File file = File.createTempFile("item", string2);
            file.deleteOnExit();
            return file;
        }
        File file = this.createItemFile(string2);
        Item item = new Item(file.getName());
        item.date = l;
        item.tag = string3;
        this.putItem(string, item);
        return file;
    }

    public File createFile(String string, long l, String string2) throws IOException {
        return this.createFile(string, l, "", string2);
    }

    public File createFile(URL uRL, long l, String string) throws IOException {
        return this.createFile(uRL.toString(), l, "", string);
    }

    public File createFile(URL uRL, long l, String string, String string2) throws IOException {
        return this.createFile(uRL.toString(), l, string, string2);
    }

    public File getFile(URL uRL) {
        return this.getFile(uRL.toString(), Long.MIN_VALUE);
    }

    public File getFile(String string, long l) {
        Item item = (Item)this.getItem(string);
        if (item == null) {
            return null;
        }
        item.incUsage();
        File file = this.getItemFile(item);
        if (!file.exists()) {
            this.removeItem(string);
        }
        if (l != Long.MIN_VALUE && item.date != l) {
            this.removeItem(string);
            return null;
        }
        return file;
    }

    public File getFile(URL uRL, long l) {
        return this.getFile(uRL.toString(), l);
    }

    public static FileCache getInstance() {
        return (FileCache)LazyFileCacheHolder.INSTANCE.get();
    }

    @Deprecated
    public static FileCache getInstance(File file) {
        return new FileCache(file);
    }

    @Override
    public void removeItem(URL uRL) {
        this.removeItem(uRL.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItemByTag(String string) {
        this.log.debugFormat("Removing by tag \"%s\"...", string);
        boolean bl = false;
        FileCache fileCache = this;
        synchronized (fileCache) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!string.equals(((Item)entry.getValue()).tag)) continue;
                this.removeItemFile((AbstractFileCache.Item)entry.getValue());
                iterator.remove();
                bl = true;
            }
        }
        if (bl) {
            this.doWriteIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown() {
        FileCache fileCache = FileCache.getInstance();
        Class<FileCache> clazz = FileCache.class;
        synchronized (FileCache.class) {
            fileCache.cleanUp(2000);
            fileCache.doWriteIndex();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected FileCache(File file) {
        super("cache", file);
    }

    @Override
    protected void readIndex() throws IOException {
        this.readXMLIndex(this.getName(), null);
    }

    @Override
    protected Map.Entry<String, Item> readXMLEntry(SimpleXMLReader simpleXMLReader) {
        Item item = new Item(simpleXMLReader.getStringAttribute("file"));
        item.setUsage(simpleXMLReader.getIntegerAttribute("usage", 1));
        item.date = simpleXMLReader.getLongAttribute("date", 0L);
        item.tag = simpleXMLReader.getStringAttribute("tag");
        return Pair.create(simpleXMLReader.getStringAttribute("path"), item);
    }

    @Override
    protected void writeIndex() throws IOException {
        this.writeXMLIndex(this.getName(), null);
    }

    @Override
    protected void writeXMLEntry(XMLBuilder xMLBuilder, Map.Entry<String, Item> entry) {
        Item item = entry.getValue();
        xMLBuilder.singleTag("item", "tag", item.tag, "path", entry.getKey(), "file", item.getFileName(), "date", item.date, "usage", item.getUsage());
    }

    private static final class LazyFileCacheHolder {
        private static final MGuardedObject<FileCache> INSTANCE = new MGuardedObject<FileCache>(new FileCache(null), "org.makagiga.commons.FileCache", PermissionInfo.ThreatLevel.MEDIUM, "Cache");

        private LazyFileCacheHolder() {
        }
    }

    public static final class Item
    extends AbstractFileCache.Item {
        private long date;
        private String tag;

        public Item(String string) {
            super(string);
        }
    }
}

