/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.makagiga.commons.AbstractScanner;
import org.makagiga.commons.FS;

public abstract class FileScanner<I, E extends Exception>
extends AbstractScanner {
    private Comparator<File> comparator;
    private static final Comparator<File> defaultComparator = new DefaultComparator();

    public FileScanner(I i, File file, Comparator<File> comparator) throws E, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        this.comparator = comparator;
        this.recurse(i, file);
    }

    public FileScanner(I i, File file) throws E, FileNotFoundException {
        this(i, file, FileScanner.getDefaultComparator());
    }

    public FileScanner(File file) throws E, FileNotFoundException {
        this(null, file, FileScanner.getDefaultComparator());
    }

    public Comparator<File> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    public static Comparator<File> getDefaultComparator() {
        return defaultComparator;
    }

    public I processDir(I i, File file) throws E {
        return null;
    }

    public abstract void processFile(I var1, File var2) throws E;

    public void processParentDir(I i, File file) throws E {
    }

    private void recurse(I i, File file) throws E {
        if (this.isStopped()) {
            return;
        }
        File[] fileArray = FS.listFiles(file);
        if (fileArray.length == 0) {
            return;
        }
        if (this.comparator != null) {
            Arrays.sort(fileArray, this.comparator);
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                I i2 = this.processDir(i, file2);
                if (this.isStopped()) {
                    return;
                }
                this.recurse(i2, file2);
                if (this.isStopped()) {
                    return;
                }
                this.processParentDir(i2, file2);
                if (!this.isStopped()) continue;
                return;
            }
            if (!file2.isFile()) continue;
            this.processFile(i, file2);
            if (!this.isStopped()) continue;
            return;
        }
    }

    private static final class DefaultComparator
    implements Comparator<File>,
    Serializable {
        @Override
        public int compare(File file, File file2) {
            boolean bl = file.isDirectory();
            boolean bl2 = file2.isDirectory();
            if (bl && !bl2) {
                return -1;
            }
            if (bl2 && !bl) {
                return 1;
            }
            String string = file.getName();
            String string2 = file2.getName();
            return string.compareToIgnoreCase(string2);
        }

        private DefaultComparator() {
        }
    }

    public static class Simple
    extends FileScanner<Object, Exception> {
        public Simple(File file) throws Exception {
            super(file);
        }

        public Simple(File file, Comparator<File> comparator) throws Exception {
            super(null, file, comparator);
        }

        public Simple(String string) throws Exception {
            super(new File(string));
        }

        public void processDir(File file) throws Exception {
        }

        public void processFile(File file) throws Exception {
        }

        @Override
        public final Object processDir(Object object, File file) throws Exception {
            this.processDir(file);
            return null;
        }

        @Override
        public final void processFile(Object object, File file) throws Exception {
            this.processFile(file);
        }
    }
}

