/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.Serializable;
import org.makagiga.commons.FS;
import org.makagiga.commons.TK;

public class LogFile
implements Serializable {
    private File file;
    private int maxBufSize = 65536;
    private int maxFileSize = 524288;
    private StringBuilder buf = new StringBuilder(this.maxBufSize);

    public LogFile(File file) {
        this.file = TK.checkNull(file, "file");
    }

    public LogFile(String string) {
        this(new File(string));
    }

    public synchronized void append(String string) {
        if (this.buf == null) {
            return;
        }
        this.buf.append(string);
        if (this.buf.length() > this.maxBufSize) {
            this.flush();
        }
    }

    public synchronized void clear() {
        if (this.buf == null) {
            return;
        }
        this.buf.setLength(0);
        File file = new File(this.file.getPath() + ".old");
        file.delete();
        this.file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.flush();
        LogFile logFile = this;
        synchronized (logFile) {
            this.buf = null;
        }
    }

    public synchronized boolean flush() {
        if (this.buf == null) {
            return false;
        }
        try {
            if (this.file.length() > (long)this.maxFileSize) {
                File file = new File(this.file.getPath() + ".old");
                file.delete();
                this.file.renameTo(file);
                this.file.delete();
            }
            FS.append(this.file, this.buf.toString());
            this.file.setReadable(false, false);
            this.file.setReadable(true, true);
            this.buf.setLength(0);
            return true;
        }
        catch (Exception exception) {
            this.buf.setLength(0);
            return false;
        }
    }

    public synchronized File getFile() {
        return this.file;
    }

    public synchronized String toString() {
        return this.buf == null ? "" : this.buf.toString();
    }
}

