/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;

public class MColor
extends Color {
    public static final Color DARK_GREEN = MColor.deriveColor(GREEN, 0.5f);
    public static final Color DARK_RED = MColor.deriveColor(RED, 0.5f);
    @Deprecated
    public static final MColor FOREST_GREEN = new MColor(14215362);
    public static final MColor HOT_ORANGE = new MColor(16767408);
    public static final MColor SKY_BLUE = new MColor(10797284);
    private static final MColor HOVER_LINK = new MColor(12518147);
    private static final MColor LINK = new MColor(191);
    private static final MColor VISITED_LINK = new MColor(8716653);

    public MColor(int n) {
        super(n);
    }

    public Color deriveAlpha(int n) {
        return MColor.deriveAlpha(this, n);
    }

    public static Color deriveAlpha(Color color, int n) {
        if (color.getAlpha() == n) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public Color deriveColor(float f) {
        return MColor.deriveColor(this, f);
    }

    public static Color deriveColor(Color color, float f) {
        if (f == 0.0f) {
            return color;
        }
        return new Color(Math.min(Math.max((int)((float)color.getRed() * f), 0), 255), Math.min(Math.max((int)((float)color.getGreen() * f), 0), 255), Math.min(Math.max((int)((float)color.getBlue() * f), 0), 255));
    }

    public Color getBrighter() {
        return MColor.getBrighter(this);
    }

    public Color getBrighter(int n) {
        return MColor.getBrighter(this, n);
    }

    public static Color getBrighter(Color color) {
        return MColor.getBrighter(color, 25);
    }

    public static Color getBrighter(Color color, int n) {
        float f = (100.0f - (float)n) / 100.0f;
        float f2 = (float)n / 100.0f * 255.0f;
        return new Color((int)((float)color.getRed() * f + f2), (int)((float)color.getGreen() * f + f2), (int)((float)color.getBlue() * f + f2));
    }

    public Color getContrast() {
        return MColor.getContrast(this);
    }

    public static Color getContrast(Color color) {
        if (MColor.isDark(color)) {
            return MColor.getBrighter(color, 50);
        }
        return MColor.deriveColor(color, 0.5f);
    }

    public Color getDarker() {
        return MColor.getDarker(this);
    }

    public static Color getDarker(Color color) {
        return MColor.deriveColor(color, 0.94f);
    }

    public static Color getHoverLinkForeground(Color color) {
        return MColor.isDark(color) ? MColor.getBrighter(HOVER_LINK, 50) : HOVER_LINK;
    }

    public static Color getLinkForeground(Color color) {
        return MColor.isDark(color) ? MColor.getBrighter(LINK, 50) : LINK;
    }

    public static Color getVisitedLinkForeground(Color color) {
        return MColor.isDark(color) ? MColor.getBrighter(VISITED_LINK, 50) : VISITED_LINK;
    }

    public boolean isDark() {
        return MColor.isDark(this);
    }

    public static boolean isDark(Color color) {
        if (color == null) {
            return false;
        }
        return color.getRGB() < -8421505;
    }
}

