/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import edu.umd.cs.findbugs.annotation.SuppressWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.undo.AbstractUndoableEdit;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButtonPanel;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MColorChooserPanel;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MColorPicker;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.color.ColorPalette;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.form.Info;

public class MColorChooser
extends MDialog {
    private boolean canUpdateUndoManager;
    private ChangeListener changeListener;
    private Color color;
    private final Color defaultColor;
    private HTMLColorChooserPanel htmlColorChooserPanel;
    private JColorChooser colorChooser;
    private MColorPicker colorPicker;
    private final MLabel backgroundPreviewLabel;
    private final MLabel foregroundPreviewLabel;
    private final MLineBorder previewBorder;
    private MUndoManager undoManager = new MUndoManager();
    private PickerColorChooserPanel pickerColorChooserPanel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MColorChooser(Window window, String string, Color color, Color color2) {
        super(window, string, 15);
        Serializable serializable;
        this.undoManager.updateUserActions();
        MButtonPanel mButtonPanel = new MButtonPanel(4, new MSmallButton(this.undoManager.getUndoAction(), false), new MSmallButton(this.undoManager.getRedoAction(), false));
        this.getButtonsPanel().addContentGap();
        this.getButtonsPanel().add(mButtonPanel);
        Icon icon = color2 == null ? MActionInfo.RESTORE_DEFAULT_VALUES.getIcon() : new MColorIcon(color2);
        this.changeButton((AbstractButton)this.getUserButton(), MActionInfo.RESTORE_DEFAULT_VALUES.getText(), icon);
        this.defaultColor = color2;
        this.previewBorder = new MLineBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.previewBorder, UI.createEmptyBorder(5));
        this.backgroundPreviewLabel = new MLabel(UI._("Preview"));
        this.backgroundPreviewLabel.setForeground(Color.BLACK);
        this.backgroundPreviewLabel.setBorder(compoundBorder);
        this.backgroundPreviewLabel.setOpaque(true);
        this.foregroundPreviewLabel = new MLabel(UI._("Preview"));
        this.foregroundPreviewLabel.setBackground(Color.WHITE);
        this.foregroundPreviewLabel.setBorder(compoundBorder);
        this.foregroundPreviewLabel.setOpaque(true);
        this.colorPicker = new MColorPicker();
        this.colorPicker.setColorButtonVisible(false);
        if (this.colorPicker.colorPaletteComboBox != null) {
            this.colorPicker.colorPaletteComboBox.setRequestFocusEnabled(true);
            serializable = this.getConfigPrivileged();
            this.colorPicker.readConfig((Config)serializable, "ColorChooser");
        }
        serializable = MPanel.createGroupPanel(false);
        serializable.getGroupLayout().beginRows().addComponent(this.colorPicker).addContentGap().beginColumns().addComponent(this.backgroundPreviewLabel).addComponent(this.foregroundPreviewLabel).end().end();
        this.addEast((JComponent)serializable);
        UI.setWaitCursor(true);
        try {
            this.colorChooser = new JColorChooser();
            this.htmlColorChooserPanel = new HTMLColorChooserPanel();
            this.colorChooser.addChooserPanel(this.htmlColorChooserPanel);
            this.pickerColorChooserPanel = new PickerColorChooserPanel();
            this.colorChooser.addChooserPanel(this.pickerColorChooserPanel);
            this.colorChooser.setDragEnabled((Boolean)Kiosk.actionDragDrop.get());
        }
        finally {
            UI.setWaitCursor(false);
        }
        this.colorChooser.setPreviewPanel((JComponent)serializable);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == MColorChooser.this.colorChooser.getSelectionModel()) {
                    MColorChooser.this.setColor(MColorChooser.this.colorChooser.getSelectionModel().getSelectedColor());
                } else if (changeEvent.getSource() == MColorChooser.this.colorPicker) {
                    MColorChooser.this.setColor(MColorChooser.this.colorPicker.getColor());
                }
            }
        };
        this.colorChooser.getSelectionModel().addChangeListener(this.changeListener);
        this.colorPicker.addChangeListener(this.changeListener);
        this.addCenter(this.colorChooser);
        this.setColor(color);
        if (color == null) {
            this.colorChooser.setColor(Color.BLACK);
        }
        this.packFixed();
        this.canUpdateUndoManager = true;
    }

    public static Color getColor(Window window, String string, Color color) {
        return MColorChooser.getColor(window, string, color, color);
    }

    public static Color getColor(Window window, String string, Color color, Color color2) {
        MColorChooser mColorChooser = new MColorChooser(window, string, color, color2);
        if (mColorChooser.exec()) {
            return mColorChooser.getColor();
        }
        return null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        boolean bl = TK.isChange(this.color, color);
        if (this.canUpdateUndoManager && bl) {
            this.undoManager.addEdit(new ColorEdit(this.color, color));
            this.undoManager.updateUserActions();
        }
        this.color = color;
        for (MLineBorder.Position position : MLineBorder.Position.values()) {
            MLineBorder.Style style = this.previewBorder.getStyle(position);
            style.setColor(this.color);
            style.setSize(2);
        }
        if (this.color == null) {
            this.backgroundPreviewLabel.setEnabled(false);
            this.foregroundPreviewLabel.setEnabled(false);
        } else {
            this.backgroundPreviewLabel.setEnabled(true);
            this.foregroundPreviewLabel.setEnabled(true);
            if (bl) {
                this.colorChooser.setColor(this.color);
            }
            this.backgroundPreviewLabel.setBackground(this.color);
            this.foregroundPreviewLabel.setForeground(this.color);
        }
        this.colorPicker.setColor(this.color);
    }

    @Override
    protected boolean done(boolean bl) {
        return super.done(bl);
    }

    @Override
    protected void onClose() {
        if (this.colorPicker != null) {
            Config config = this.getConfigPrivileged();
            this.colorPicker.writeConfig(config, "ColorChooser");
            config.sync();
        }
        if (this.colorChooser != null) {
            if (this.changeListener != null) {
                this.colorChooser.getSelectionModel().removeChangeListener(this.changeListener);
                this.colorPicker.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            if (this.htmlColorChooserPanel != null) {
                this.colorChooser.removeChooserPanel(this.htmlColorChooserPanel);
                this.htmlColorChooserPanel.actionGroup = null;
                this.htmlColorChooserPanel.value = null;
                this.htmlColorChooserPanel = null;
            }
            if (this.pickerColorChooserPanel != null) {
                this.pickerColorChooserPanel.dispose(new Object[0]);
                this.colorChooser.removeChooserPanel(this.pickerColorChooserPanel);
                this.pickerColorChooserPanel = null;
            }
            this.colorChooser = null;
            this.colorPicker = null;
        }
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
            this.undoManager = null;
        }
    }

    @Override
    protected void onUserClick() {
        this.setColor(this.defaultColor);
    }

    private Config getConfigPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return Config.getDefault();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Config>(){

            @Override
            public Config run() {
                return Config.getDefault();
            }
        });
    }

    void setSelectedColorPalette(ColorPalette colorPalette) {
        this.colorPicker.setSelectedColorPalette(colorPalette);
    }

    private static final class PickerColorChooserPanel
    extends MColorChooserPanel
    implements MDisposable {
        private Color color;
        private CoolHeader errorMessage;
        private MCheckBox enabled;
        private MLabel colorLabel;
        private MTimer updateTimer;
        private final Point lastMouseLocation = new Point();
        private Robot bender;

        @Override
        public void updateChooser() {
            if (this.color == null) {
                return;
            }
            this.colorLabel.setHTML(String.format("HTML: <code>%s</code><br>RGB: %d, %d, %d<br>X: %d, Y: %d", ColorProperty.toString(this.color), this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.lastMouseLocation.x, this.lastMouseLocation.y));
        }

        @Override
        public Object dispose(Object ... objectArray) {
            this.bender = null;
            this.colorLabel = null;
            this.enabled = null;
            this.errorMessage = null;
            if (this.updateTimer != null) {
                this.updateTimer.stop();
                this.updateTimer = null;
            }
            return null;
        }

        @Override
        protected void buildChooser() {
            super.buildChooser();
            this.enabled = new MCheckBox(UI._("Active (press {0} to disable)", TK.toString(32, 0))){

                @Override
                protected void onClick() {
                    if (!this.isSelected() && PickerColorChooserPanel.this.color != null) {
                        PickerColorChooserPanel.this.setSelectedColor(PickerColorChooserPanel.this.color);
                    }
                }
            };
            this.add((Component)this.enabled, "North");
            this.colorLabel = new MLabel();
            this.colorLabel.makeLargeMessage();
            this.add(this.colorLabel);
            this.errorMessage = new CoolHeader();
            this.errorMessage.setVisible(false);
            this.add((Component)this.errorMessage, "South");
            this.updateTimer.start();
        }

        private PickerColorChooserPanel() {
            super(UI._("Color Picker"));
            this.updateTimer = new MTimer(100){

                @Override
                protected boolean onTimeout() {
                    PickerColorChooserPanel.this.getColorFromScreen();
                    return true;
                }
            };
        }

        private void createRobot() {
            if (this.bender != null) {
                return;
            }
            if (this.errorMessage.isVisible()) {
                return;
            }
            try {
                this.bender = new Robot();
            }
            catch (Exception exception) {
                MLogger.exception(exception);
                this.enabled.setEnabled(false);
                this.errorMessage.setVisible(true);
                this.errorMessage.setErrorMessage(exception.getMessage());
            }
        }

        private void getColorFromScreen() {
            if (!this.enabled.isSelected()) {
                return;
            }
            this.createRobot();
            if (this.bender == null) {
                return;
            }
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point point = pointerInfo.getLocation();
            if (point.equals(this.lastMouseLocation)) {
                return;
            }
            this.lastMouseLocation.setLocation(point);
            this.color = this.bender.getPixelColor(point.x, point.y);
            int n = 30;
            Dimension dimension = UI.getScreenSize();
            int n2 = point.x - n / 2;
            int n3 = point.y - n / 2;
            Rectangle rectangle = new Rectangle(n2, n3, n, n);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            } else if (rectangle.x + n > dimension.width) {
                rectangle.x = dimension.width - n;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            } else if (rectangle.y + n > dimension.height) {
                rectangle.y = dimension.height - n;
            }
            BufferedImage bufferedImage = this.bender.createScreenCapture(rectangle);
            int n4 = 5;
            int n5 = n * n4;
            BufferedImage bufferedImage2 = UI.createCompatibleImage(n5, n5, false);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.PINK);
            graphics2D.fillRect(0, 0, n5, n5);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics2D.drawImage(bufferedImage, (rectangle.x - n2) * n4, (rectangle.y - n3) * n4, n5, n5, null);
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect(n5 / 2, n5 / 2, n4, n4);
            graphics2D.dispose();
            this.colorLabel.setImage(bufferedImage2);
            this.updateChooser();
        }
    }

    private static final class HTMLColorChooserPanel
    extends MColorChooserPanel {
        private ActionGroup actionGroup;
        private boolean inUpdate;
        private FormPanel<HTMLColorChooserForm> formPanel;
        private MLabel status;
        private MTextField value;

        @Override
        public void updateChooser() {
            if (!this.inUpdate) {
                Color color = this.getColorFromModel();
                String string = ColorProperty.toString(color);
                this.value.setText(string);
                MURLButton mURLButton = (MURLButton)this.formPanel.getComponent("colourLovers");
                mURLButton.setURL("http://www.colourlovers.com/color/" + TK.toUpperCase(string.substring(1)));
                mURLButton = (MURLButton)this.formPanel.getComponent("colorMixers");
                mURLButton.setURL("http://www.colormixers.com/?color=" + string.substring(1));
            }
        }

        @Override
        protected void buildChooser() {
            super.buildChooser();
            this.actionGroup = new ActionGroup();
            this.actionGroup.add("copy", new MAction(MActionInfo.COPY){

                @Override
                public void onAction() {
                    MText.copyAll(HTMLColorChooserPanel.this.value);
                }
            });
            this.actionGroup.add("paste", new MAction(MActionInfo.PASTE){

                @Override
                public void onAction() {
                    HTMLColorChooserPanel.this.value.clear();
                    HTMLColorChooserPanel.this.value.paste();
                }
            });
            this.value = new MTextField(7){

                @Override
                protected void onChange(DocumentEvent documentEvent) {
                    HTMLColorChooserPanel.this.updateActions();
                    HTMLColorChooserPanel.this.updateColor();
                }
            };
            this.value.setStyle("font-family: Monospaced; font-size: larger");
            MText.setMaximumLength(this.value, 7);
            MPanel mPanel = MPanel.createHBoxPanel();
            mPanel.add(MLabel.createFor(this.value, UI._("Value:")));
            mPanel.addContentGap();
            mPanel.add(this.value);
            this.status = new MLabel();
            mPanel.addContentGap();
            mPanel.add(this.status);
            mPanel.addContentGap();
            mPanel.add(new MSmallButton((Action)this.actionGroup.getAction("copy"), false));
            mPanel.add(new MSmallButton((Action)this.actionGroup.getAction("paste"), false));
            MPanel mPanel2 = MPanel.createVBoxPanel();
            mPanel2.add(mPanel);
            mPanel2.addContentGap();
            this.formPanel = new FormPanel<HTMLColorChooserForm>(new HTMLColorChooserForm());
            mPanel2.add(this.formPanel);
            this.add(mPanel2);
        }

        private HTMLColorChooserPanel() {
            super("HTML");
        }

        private void updateActions() {
            this.actionGroup.setEnabled("copy", !this.value.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateColor() {
            try {
                this.inUpdate = true;
                Color color = ColorProperty.parseColor(this.value.getText());
                this.setSelectedColor(color);
                this.status.setIcon(MIcon.small("ui/ok"));
                this.status.setToolTipText(UI._("OK"));
            }
            catch (ParseException parseException) {
                this.status.setIcon(MIcon.small("ui/error"));
                this.status.setToolTipText(UI._("Error"));
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    @Form(order={"examples", "example1", "example2", "www", "colourLovers", "colorMixers", "colorSchemer", "colorSchemer2"})
    @SuppressWarnings(value="UUF_UNUSED_FIELD")
    private static final class HTMLColorChooserForm {
        @Info(type=5)
        private final String examples = UI._("Examples");
        @Info(type=1)
        private final String example1 = UI._("{0} - red color", "<code>#ff0000</code>, <code>ff0000</code>, <code>f00</code>");
        @Info(type=1)
        private final String example2 = UI._("{0} - light orange", "<code>#FFA858</code>");
        @Info(type=5)
        private final String www = "WWW";
        @Field(label="COLOURlovers :: Color Trends & Palettes")
        private final URI colourLovers = URI.create("http://www.colourlovers.com/");
        @Field(label="ColorMatch Remix")
        private final URI colorMixers = URI.create("http://www.colormixers.com/");
        @Field(label="Color Schemer Online")
        private final URI colorSchemer = URI.create("http://www.colorschemer.com/online.html");
        @Field(label="Color Scheme Designer")
        private final URI colorSchemer2 = URI.create("http://colorschemedesigner.com/");

        private HTMLColorChooserForm() {
        }
    }

    private final class ColorEdit
    extends AbstractUndoableEdit {
        private final Color newColor;
        private final Color oldColor;

        @Override
        public void redo() {
            super.redo();
            this.setColor(this.newColor);
        }

        @Override
        public void undo() {
            super.undo();
            this.setColor(this.oldColor);
        }

        private ColorEdit(Color color, Color color2) {
            this.oldColor = color;
            this.newColor = color2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setColor(Color color) {
            try {
                MColorChooser.this.canUpdateUndoManager = false;
                MColorChooser.this.setColor(color);
            }
            finally {
                MColorChooser.this.canUpdateUndoManager = true;
            }
        }
    }
}

