/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MText;
import org.makagiga.commons.UI;

public class MComponent
extends JComponent {
    public MComponent() {
    }

    public MComponent(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
    }

    public static BufferedImage createScreenshot(Component component, Color color) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        BufferedImage bufferedImage = UI.createCompatibleImage(n, n2, true);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
        }
        UI.setTextAntialiasing(graphics2D, null);
        component.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean removeFromParent(Component component, boolean bl) {
        Container container = component.getParent();
        if (container != null) {
            container.remove(component);
            if (bl) {
                container.validate();
                container.repaint();
            }
            return true;
        }
        return false;
    }

    public static void replace(Container container, Component component, Component component2, Object object, boolean bl) {
        if (component == component2) {
            return;
        }
        boolean bl2 = false;
        if (component != null) {
            container.remove(component);
            bl2 = true;
        }
        if (component2 != null) {
            if (object == null) {
                if (container instanceof MPanel && component2 instanceof JComponent) {
                    ((MPanel)MPanel.class.cast(container)).add((JComponent)component2);
                } else {
                    container.add(component2);
                }
            } else {
                container.add(component2, object);
            }
            bl2 = true;
        }
        if (bl2) {
            if (bl && container instanceof JComponent) {
                JComponent jComponent = (JComponent)container;
                jComponent.revalidate();
            } else {
                container.validate();
            }
            container.repaint();
        }
    }

    public static void requestFocus(Component component) {
        if (component instanceof MText.TextFieldExtensions) {
            MComponent.doRequestTextFieldFocus(component);
        } else if (component instanceof MPanel.Wrapper) {
            Object c = ((MPanel.Wrapper)MPanel.Wrapper.class.cast(component)).getView();
            if (c instanceof MText.TextFieldExtensions) {
                MComponent.doRequestTextFieldFocus(c);
            } else {
                MComponent.doFocus(c);
            }
        } else {
            MComponent.doFocus(component);
        }
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    @Deprecated
    public void setHeight(int n) {
        this.setSize(this.getWidth(), n);
    }

    @Deprecated
    public void setWidth(int n) {
        this.setSize(n, this.getHeight());
    }

    private static void doFocus(Component component) {
        if (component instanceof Focusable) {
            ((Focusable)Focusable.class.cast(component)).focus();
        } else {
            component.requestFocusInWindow();
        }
    }

    private static void doRequestTextFieldFocus(Component component) {
        if (component instanceof JComboBox) {
            if (component.isEnabled()) {
                ((MText.TextFieldExtensions)MText.TextFieldExtensions.class.cast(component)).makeDefault();
            }
        } else {
            ((MText.TextFieldExtensions)MText.TextFieldExtensions.class.cast(component)).makeDefault();
        }
    }

    static Dimension setFixedSize(Component component, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
        component.setSize(dimension);
        return dimension;
    }
}

