/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Cursor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import org.makagiga.commons.AbstractSpinner;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MCalendarPanel;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.UI;

public class MDateSpinner
extends AbstractSpinner<SpinnerDateModel, Date> {
    public MDateSpinner() {
        this(true);
    }

    public MDateSpinner(boolean bl) {
        super(new SpinnerDateModel());
        this.setEditor(new JSpinner.DateEditor(this));
        this.setupEditor();
        if (bl) {
            this.setupUserActions();
        }
        JTextField jTextField = this.getTextField();
        jTextField.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void clearDate() {
        this.setSelectedDate(MDate.invalid());
    }

    public MCalendarPanel createMenuCalendarPanel(final MMenu mMenu) {
        MCalendarPanel mCalendarPanel = new MCalendarPanel(this.getSelectedDate()){

            @Override
            protected MMenu onClick(int n) {
                MCalendar mCalendar = MCalendar.of(super.getSelectedDate());
                mCalendar.setTime(MCalendar.of(MDateSpinner.this.getSelectedDate()));
                MDateSpinner.this.setSelectedDate(mCalendar.getTime());
                mMenu.setPopupMenuVisible(false);
                MDateSpinner.this.requestFocusInWindow();
                return null;
            }
        };
        mCalendarPanel.getDateSpinner().getTextField().putClientProperty("org.makagiga.commons.MText.noGlobalMenu", true);
        mCalendarPanel.setBorder(BorderFactory.createLineBorder(MColor.WHITE, 2));
        mCalendarPanel.setMonthMenuButtonVisible(false);
        mCalendarPanel.setShowInfo(false);
        return mCalendarPanel;
    }

    public boolean isDateValid() {
        MDate mDate = (MDate)this.getSelectedDate();
        return mDate.isValid();
    }

    public Date getSelectedDate() {
        Date date = ((SpinnerDateModel)this.getModel()).getDate();
        return date instanceof MDate ? (MDate)date : new MDate(date);
    }

    public void setSelectedDate(Date date) {
        ((SpinnerDateModel)this.getModel()).setValue(date);
    }

    public void setDateFormat(int n) {
        this.setFormat(DateFormat.getDateInstance(n));
    }

    public void setDateTimeFormat(int n, int n2) {
        this.setFormat(DateFormat.getDateTimeInstance(n, n2));
    }

    public void setFormat(DateFormat dateFormat) {
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        DateFormatter dateFormatter = (DateFormatter)defaultEditor.getTextField().getFormatter();
        dateFormatter.setFormat(dateFormat);
        ChangeEvent changeEvent = new ChangeEvent(this.getModel());
        for (ChangeListener changeListener : ((SpinnerDateModel)this.getModel()).getChangeListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void setSimpleFormat(String string) {
        this.setFormat(new SimpleDateFormat(string));
    }

    public void setTimeFormat(int n) {
        this.setFormat(DateFormat.getTimeInstance(n));
    }

    public MCalendar toCalendar() {
        return MCalendar.of(this.getSelectedDate());
    }

    private void addField(int n, int n2) {
        MCalendar mCalendar = MCalendar.of(this.getSelectedDate());
        mCalendar.add(n, n2);
        this.setSelectedDate(mCalendar.getTime());
    }

    private void setupUserActions() {
        MText.setUserMenu(this.getTextField(), new MText.UserMenu<JTextField>(){

            @Override
            public void onUserMenu(JTextField jTextField, MMenu mMenu) {
                MDateSpinner.this.setupUserMenu(mMenu);
            }
        });
    }

    private void setupUserMenu(MMenu mMenu) {
        MMenu mMenu2 = new MMenu(MActionInfo.SET_DATE_TIME);
        mMenu2.add(new MAction(MActionInfo.CURRENT_DATE_AND_TIME){

            @Override
            public void onAction() {
                MDateSpinner.this.setSelectedDate(MDate.now());
            }
        });
        mMenu2.add(new MAction(MActionInfo.NO_DATE_TIME){

            @Override
            public void onAction() {
                MDateSpinner.this.clearDate();
            }
        });
        mMenu2.addSeparator();
        mMenu2.add(new MAction(UI._("Next Day")){

            @Override
            public void onAction() {
                MDateSpinner.this.addField(5, 1);
            }
        });
        mMenu2.addSeparator();
        mMenu2.add(new MAction(UI._("Next Week")){

            @Override
            public void onAction() {
                MDateSpinner.this.addField(5, 7);
            }
        });
        mMenu2.add(new MAction(UI._("Next Month")){

            @Override
            public void onAction() {
                MDateSpinner.this.addField(2, 1);
            }
        });
        mMenu2.add(new MAction(UI._("Next Year")){

            @Override
            public void onAction() {
                MDateSpinner.this.addField(1, 1);
            }
        });
        mMenu.add(mMenu2);
        mMenu.add(this.createMenuCalendarPanel(mMenu));
    }
}

