/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.UI;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelinePropertyBuilder;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class MDesktopPane<I extends JInternalFrame>
extends JDesktopPane
implements Iterable<I>,
Lockable,
UI.ComponentExtensions {
    private boolean locked;

    public MDesktopPane() {
        this.setDesktopManager(new MDesktopManager());
    }

    public static JDesktopPane getDesktopPane(JComponent jComponent) {
        if (jComponent instanceof JDesktopPane) {
            return (JDesktopPane)jComponent;
        }
        JInternalFrame jInternalFrame = MDesktopPane.getInternalFrame(jComponent);
        return jInternalFrame == null ? null : jInternalFrame.getDesktopPane();
    }

    public static JInternalFrame getInternalFrame(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame) {
            return (JInternalFrame)jComponent;
        }
        if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            return ((JInternalFrame.JDesktopIcon)JInternalFrame.JDesktopIcon.class.cast(jComponent)).getInternalFrame();
        }
        if (jComponent instanceof BasicInternalFrameTitlePane) {
            return (JInternalFrame)jComponent.getParent();
        }
        return null;
    }

    public List<I> getFrames() {
        return this.toList(this.getAllFrames());
    }

    public List<I> getFrames(int n) {
        return this.toList(this.getAllFramesInLayer(n));
    }

    @Override
    public Iterator<I> iterator() {
        return this.getFrames().iterator();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public static boolean isLocked(JComponent jComponent) {
        JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent);
        return jDesktopPane instanceof Lockable && ((Lockable)Lockable.class.cast(jDesktopPane)).isLocked();
    }

    protected void onEndDraggingFrame(JComponent jComponent) {
    }

    protected void onEndResizingFrame(JComponent jComponent) {
    }

    private List<I> toList(JInternalFrame[] jInternalFrameArray) {
        ArrayList<JInternalFrame> arrayList = new ArrayList<JInternalFrame>(jInternalFrameArray.length);
        for (JInternalFrame jInternalFrame : jInternalFrameArray) {
            arrayList.add(jInternalFrame);
        }
        return arrayList;
    }

    private static final class GhostFrame
    extends UIThreadTimelineCallbackAdapter {
        private float alpha;
        private float scale;
        private BufferedImage image;
        private JDesktopPane desktopPane;
        private Rectangle bounds;
        private Timeline animation;

        @Override
        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            if (timelineState2 == Timeline.TimelineState.DONE) {
                this.image = null;
                this.doRepaint();
                this.bounds = null;
                this.desktopPane = null;
            }
        }

        private GhostFrame() {
        }

        private void begin(JInternalFrame jInternalFrame, boolean bl) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = jInternalFrame.isIcon() ? jInternalFrame.getDesktopIcon().getBounds() : jInternalFrame.getBounds();
            if (!rectangle.equals(this.bounds)) {
                this.stopAnimations();
                this.alpha = bl ? 1.0f : 0.2f;
                this.scale = 1.0f;
                this.bounds = rectangle;
                this.desktopPane = jInternalFrame.getDesktopPane();
                this.image = UI.createCompatibleImage(jInternalFrame.isIcon() ? jInternalFrame.getDesktopIcon() : jInternalFrame, UI.INVISIBLE);
                this.doRepaint();
            }
        }

        private void doRepaint() {
            if (this.desktopPane != null) {
                this.desktopPane.repaint(this.bounds);
            }
        }

        private void end(boolean bl) {
            if (this.bounds != null) {
                this.stopAnimations();
                if (!((Boolean)UI.animations.get()).booleanValue()) {
                    this.onTimelineStateChanged(null, Timeline.TimelineState.DONE, 0.0f, 1.0f);
                    return;
                }
                this.animation = new Timeline(this);
                this.animation.addCallback(this);
                if (bl) {
                    this.animation.setDuration(500L);
                    this.animation.addPropertyToInterpolate(Timeline.property("scale").from(Float.valueOf(this.scale)).to(Float.valueOf(0.0f)).getWith(new TimelinePropertyBuilder.PropertyGetter<Float>(){

                        @Override
                        public Float get(Object object, String string) {
                            return Float.valueOf(GhostFrame.this.scale);
                        }
                    }).setWith(new TimelinePropertyBuilder.PropertySetter<Float>(){

                        @Override
                        public void set(Object object, String string, Float f) {
                            if (f.floatValue() != GhostFrame.this.scale) {
                                GhostFrame.this.scale = f.floatValue();
                                UI.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GhostFrame.this.doRepaint();
                                    }
                                });
                            }
                        }
                    }));
                } else {
                    this.animation.setDuration(250L);
                    this.animation.addPropertyToInterpolate(Timeline.property("alpha").from(Float.valueOf(this.alpha)).to(Float.valueOf(0.0f)).getWith(new TimelinePropertyBuilder.PropertyGetter<Float>(){

                        @Override
                        public Float get(Object object, String string) {
                            return Float.valueOf(GhostFrame.this.alpha);
                        }
                    }).setWith(new TimelinePropertyBuilder.PropertySetter<Float>(){

                        @Override
                        public void set(Object object, String string, Float f) {
                            if (f.floatValue() != GhostFrame.this.alpha) {
                                GhostFrame.this.alpha = f.floatValue();
                                UI.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GhostFrame.this.doRepaint();
                                    }
                                });
                            }
                        }
                    }));
                }
                this.animation.play();
            }
        }

        private void paint(Graphics2D graphics2D) {
            if (this.bounds != null && this.image != null) {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                int n = this.bounds.x;
                int n2 = this.bounds.y;
                int n3 = this.image.getWidth();
                int n4 = this.image.getHeight();
                if (this.alpha < 1.0f) {
                    graphics2D2.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
                }
                if (this.scale < 1.0f) {
                    n3 = (int)((float)n3 * this.scale);
                    n4 = (int)((float)n4 * this.scale);
                    n += this.image.getWidth() / 2 - n3 / 2;
                    n2 += this.image.getHeight() / 2 - n4 / 2;
                    graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics2D2.drawImage(this.image, n, n2, n3, n4, null);
                graphics2D2.dispose();
            }
        }

        private void stopAnimations() {
            if (this.animation != null) {
                this.doRepaint();
                this.animation.abort();
                this.animation.removeCallback(this);
                this.animation = null;
            }
        }
    }

    public static final class MDesktopManager
    extends DefaultDesktopManager {
        private boolean snapEnabled;
        private final GhostFrame ghost = new GhostFrame();
        private int snapSize = 5;

        @Override
        public void beginDraggingFrame(JComponent jComponent) {
            JInternalFrame jInternalFrame;
            if (jComponent instanceof JInternalFrame) {
                super.beginDraggingFrame(jComponent);
                jInternalFrame = (JInternalFrame)jComponent;
            } else {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)JInternalFrame.JDesktopIcon.class.cast(jComponent)).getInternalFrame();
            }
            this.ghost.begin(jInternalFrame, false);
        }

        @Override
        public void closeFrame(JInternalFrame jInternalFrame) {
            this.ghost.begin(jInternalFrame, true);
            super.closeFrame(jInternalFrame);
            this.ghost.end(true);
        }

        @Override
        public void dragFrame(JComponent jComponent, int n, int n2) {
            if (jComponent instanceof JInternalFrame && !MDesktopPane.isLocked(jComponent)) {
                Point point = new Point(n, n2);
                this.snap(MDesktopPane.getDesktopPane(jComponent), jComponent, point);
                super.dragFrame(jComponent, point.x, point.y);
            }
        }

        @Override
        public void endDraggingFrame(JComponent jComponent) {
            if (jComponent instanceof JInternalFrame) {
                super.endDraggingFrame(jComponent);
            }
            this.ghost.end(false);
            JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent);
            if (jDesktopPane instanceof MDesktopPane) {
                ((MDesktopPane)MDesktopPane.class.cast(jDesktopPane)).onEndDraggingFrame(jComponent);
            }
        }

        @Override
        public void beginResizingFrame(JComponent jComponent, int n) {
            super.beginResizingFrame(jComponent, n);
        }

        @Override
        public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (!MDesktopPane.isLocked(jComponent)) {
                super.resizeFrame(jComponent, n, n2, n3, n4);
            }
        }

        @Override
        public void endResizingFrame(JComponent jComponent) {
            super.endResizingFrame(jComponent);
            JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent);
            if (jDesktopPane instanceof MDesktopPane) {
                ((MDesktopPane)MDesktopPane.class.cast(jDesktopPane)).onEndResizingFrame(jComponent);
            }
        }

        public int getSnapSize() {
            return this.snapSize;
        }

        public void setSnapSize(int n) {
            this.snapSize = n;
        }

        public boolean isSnapEnabled() {
            return this.snapEnabled;
        }

        public void setSnapEnabled(boolean bl) {
            this.snapEnabled = bl;
        }

        public void paintBackground(JDesktopPane jDesktopPane, Graphics2D graphics2D) {
            this.ghost.paint(graphics2D);
        }

        public void snap(JDesktopPane jDesktopPane, JComponent jComponent, Point point) {
            if (!this.snapEnabled) {
                return;
            }
            if (point.x < this.snapSize * 2) {
                point.x = this.snapSize;
            } else if (point.x + jComponent.getWidth() + this.snapSize * 2 > jDesktopPane.getWidth()) {
                point.x = jDesktopPane.getWidth() - jComponent.getWidth() - this.snapSize + 2;
            }
            if (point.y < this.snapSize * 2) {
                point.y = this.snapSize;
            } else if (point.y + jComponent.getHeight() + this.snapSize * 2 > jDesktopPane.getHeight()) {
                point.y = jDesktopPane.getHeight() - jComponent.getHeight() - this.snapSize + 2;
            }
        }
    }
}

