/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.HTMLViewFactory;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextPane;
import org.makagiga.commons.TK;

public class MHTMLViewer
extends MTextPane {
    private HTMLViewFactory.ImageDownloader imageDownloader;

    public MHTMLViewer() {
        this((String)null);
    }

    public MHTMLViewer(HTMLBuilder hTMLBuilder) {
        this(hTMLBuilder.toString());
    }

    public MHTMLViewer(String string) {
        MText.uninstallUndoManager(this);
        this.setEditable(false);
        this.setHonorDisplayProperties(true);
        if (TK.isEmpty(string)) {
            this.setContentType("text/html; charset=UTF-8");
        } else {
            this.setHTML(string);
        }
    }

    public HTMLViewFactory.ImageDownloader getImageDownloader() {
        return this.imageDownloader;
    }

    public void installCache() {
        this.installCache(2);
    }

    public synchronized void installCache(int n) {
        this.uninstallCache();
        this.imageDownloader = new HTMLViewFactory.ImageDownloader(n);
        this.setEditorKit(new StaticHTMLEditorKit(this));
    }

    public synchronized void uninstallCache() {
        if (this.imageDownloader != null) {
            this.imageDownloader.cancelAll();
            this.imageDownloader = null;
        }
    }

    public synchronized void setHTML(HTMLBuilder hTMLBuilder) {
        this.setHTML(hTMLBuilder.toString());
    }

    public void setHTML(String string) {
        this.setHTML(string, null);
    }

    public synchronized void setHTML(String string, URL uRL) {
        HTMLDocument hTMLDocument;
        this.setContentType("text/html; charset=UTF-8");
        Document document = this.getDocument();
        HTMLDocument hTMLDocument2 = hTMLDocument = document instanceof HTMLDocument ? (HTMLDocument)document : null;
        if (hTMLDocument != null) {
            hTMLDocument.setAsynchronousLoadPriority(-1);
            if (uRL != null) {
                hTMLDocument.setBase(uRL);
            }
        }
        this.setText(string);
        this.scrollToTop();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyStroke.getKeyCode() == 84 && (keyStroke.getModifiers() & 0x80) == 128) {
            return false;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private static final class StaticHTMLEditorKit
    extends HTMLEditorKit {
        private final WeakReference<MHTMLViewer> viewerRef;

        @Override
        public ViewFactory getViewFactory() {
            MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
            if (mHTMLViewer == null) {
                return super.getViewFactory();
            }
            return new HTMLViewFactory(super.getViewFactory(), mHTMLViewer.imageDownloader);
        }

        private StaticHTMLEditorKit(MHTMLViewer mHTMLViewer) {
            this.viewerRef = new WeakReference<MHTMLViewer>(mHTMLViewer);
        }
    }
}

