/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JMenuBar;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MAboutDialog;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MSystemTray;
import org.makagiga.commons.MainView;
import org.makagiga.commons.Net;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.sb.DefaultPageChecker;
import org.makagiga.commons.sb.PageChecker;
import org.makagiga.commons.sb.SecureOpen;

public class MMainWindow
extends MFrame
implements Lockable {
    private boolean desktopVisible;
    private boolean locked;
    private boolean oldMenuBarVisible = true;
    private boolean showSystemTrayInfo = true;
    private final MStatusBar statusBar;

    public MMainWindow() {
        super(MApplication.getFullName());
        this.setDefaultCloseOperation(0);
        this.readConfig(Config.getDefault(), null);
        this.setMinimumSize(new Dimension(this.getWidth() / 2, this.getHeight() / 2));
        if (MApplication.getLogo() != null) {
            this.setIconImage(MApplication.getLogo());
        }
        this.statusBar = new MStatusBar();
        this.addSouth(this.statusBar);
        MainView.init(this, this.statusBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MSystemTray.isHideMainWindowInTray()) {
                    MMainWindow.this.setVisible(false);
                    MMainWindow.this.fireWindowIconified();
                    if (MMainWindow.this.showSystemTrayInfo) {
                        MMainWindow.this.showSystemTrayInfo = false;
                        MNotification.Message message = new MNotification.Message(MApplication.getFullName(), UI.makeHTML(UI._("The application is still running<br>in the system tray.")), MApplication.getIcon());
                        message.setTimeout(-1);
                        MNotification.showMessage(message);
                    }
                } else {
                    MApplication.quit();
                }
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                MMainWindow.this.repaint();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                MMainWindow.this.onMinimize();
            }
        });
    }

    public void about() {
        MAboutDialog mAboutDialog = new MAboutDialog((Window)this);
        mAboutDialog.exec();
    }

    public MStatusBar getStatusBar() {
        return this.statusBar;
    }

    @Deprecated
    public boolean isDesktopVisible() {
        return this.desktopVisible;
    }

    public void setDesktopVisible(boolean bl) {
        this.desktopVisible = bl;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        if (bl == this.locked) {
            return;
        }
        this.locked = bl;
        JMenuBar jMenuBar = this.getJMenuBar();
        if (this.locked) {
            if (jMenuBar != null) {
                this.oldMenuBarVisible = jMenuBar.isVisible();
                jMenuBar.setVisible(false);
            }
        } else if (jMenuBar != null) {
            jMenuBar.setVisible(this.oldMenuBarVisible);
        }
        this.getContentPane().setVisible(!this.locked);
        this.firePropertyChange("locked", !this.locked, this.locked);
    }

    @Deprecated
    public Object onDynamicInit(Object object) {
        return null;
    }

    @Deprecated
    public Object onDynamicInit(Object object, Object object2) {
        return null;
    }

    public static boolean openURI(String string) {
        return MMainWindow.openURI(Net.fixURI(string));
    }

    public static boolean openURI(String string, PageChecker pageChecker) {
        return MMainWindow.openURI(Net.fixURI(string), pageChecker);
    }

    public static boolean openURI(String string, String ... stringArray) {
        if (TK.isEmpty(stringArray)) {
            return MMainWindow.openURI(string);
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = stringArray[i] == null ? "" : TK.escapeURL(stringArray[i]);
            objectArray[i] = string2;
        }
        URI uRI = Net.fixURI(MessageFormat.format(string, objectArray));
        return MMainWindow.openURI(uRI, (PageChecker)null);
    }

    public static boolean openURI(URI uRI) {
        return MMainWindow.openURI(uRI, null);
    }

    public static boolean openURI(URI uRI, PageChecker pageChecker) {
        if (pageChecker != null) {
            return MMainWindow.secureOpen(uRI, pageChecker);
        }
        if (((Boolean)Kiosk.linkAllowOpen.get()).booleanValue()) {
            MMainWindow.showOpenInfo(uRI);
            return OS.open(uRI);
        }
        return false;
    }

    public static boolean openURI(URL uRL) {
        return MMainWindow.openURI(uRL, (PageChecker)null);
    }

    public static boolean openURI(URL uRL, PageChecker pageChecker) {
        try {
            return MMainWindow.openURI(uRL.toURI(), pageChecker);
        }
        catch (URISyntaxException uRISyntaxException) {
            MMessage.error(null, uRISyntaxException);
            return false;
        }
    }

    public void restore() {
        this.setVisible(true);
        if (this.getExtendedState() == 1) {
            this.setExtendedState(0);
        }
        this.toFront();
    }

    public void updateTitle(String string) {
        StringBuilder stringBuilder = new StringBuilder(MApplication.getFullName());
        if (FS.getProfile() != null) {
            stringBuilder.append(" [").append(FS.getProfile()).append(']');
        } else if (FS.isPortable()) {
            stringBuilder.append(" [Portable]");
        }
        if (MApplication.isSafeMode()) {
            stringBuilder.append(" [Safe-Mode]");
        }
        if (string != null) {
            String string2 = string;
            if (OS.isWindows()) {
                string2 = string2.replace("\n", "");
            }
            stringBuilder.insert(0, " - ");
            stringBuilder.insert(0, string2);
        }
        this.setTitle(stringBuilder.toString());
    }

    protected void onMinimize() {
    }

    private static boolean secureOpen(URI uRI, PageChecker pageChecker) {
        if (!((Boolean)Kiosk.linkAllowOpen.get()).booleanValue()) {
            return false;
        }
        PageChecker.PageStatus pageStatus = pageChecker.getPageStatus(uRI);
        if (pageStatus == PageChecker.PageStatus.OK || pageChecker.showWarning(null, uRI, pageStatus)) {
            MMainWindow.showOpenInfo(uRI);
            return OS.open(uRI);
        }
        return false;
    }

    private static void showOpenInfo(URI uRI) {
        if (MainView.getStatusBar() != null) {
            MStatusBar.info(UI._("Opening \"{0}\"...", uRI));
        }
    }

    void fireWindowIconified() {
        WindowListener[] windowListenerArray = this.getWindowListeners();
        if (windowListenerArray.length > 0) {
            WindowEvent windowEvent = new WindowEvent(this, 203);
            for (WindowListener windowListener : windowListenerArray) {
                windowListener.windowIconified(windowEvent);
            }
        }
    }

    static boolean openURI(String string, SecureOpen secureOpen) {
        return MMainWindow.openURI(string, secureOpen.isSecureOpen() ? DefaultPageChecker.get() : null);
    }

    static boolean openURI(URL uRL, SecureOpen secureOpen) {
        return MMainWindow.openURI(uRL, secureOpen.isSecureOpen() ? DefaultPageChecker.get() : null);
    }
}

