/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.plaf.basic.BasicMenuBarUI;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.UI;
import org.makagiga.commons.mods.Mods;

public class MMenuBar
extends JMenuBar
implements Iterable<JMenu> {
    public static final String MOD_ADD_MENU = "add_JMenu@org.makagiga.commons.MMenuBar";
    private boolean minimized;

    @Override
    public JMenu add(JMenu jMenu) {
        JMenu jMenu2 = super.add(jMenu);
        if (jMenu2 != null) {
            Mods.exec(this, MOD_ADD_MENU, jMenu2);
        }
        return jMenu2;
    }

    public JComponent addGap() {
        return (JComponent)this.add(Box.createRigidArea(new Dimension(5, 0)));
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.minimized) {
            return new Dimension();
        }
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, Math.max(dimension.height, 24));
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean bl) {
        if (bl != this.minimized) {
            this.minimized = bl;
            this.updateUI();
            this.revalidate();
        }
    }

    @Override
    public Iterator<JMenu> iterator() {
        return new AbstractIterator<JMenu>(this.getMenuCount()){

            @Override
            public JMenu getObjectAt(int n) {
                return MMenuBar.this.getMenu(n);
            }
        };
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.minimized) {
            super.paint(graphics);
        }
    }

    @Override
    public void updateUI() {
        if (this.minimized) {
            this.setUI(new MinimizedUI());
        } else {
            super.updateUI();
        }
        if (UI.isMetal() || UI.isNimbus()) {
            this.setBorder(null);
            this.setBorderPainted(false);
        }
    }

    private static final class MinimizedUI
    extends BasicMenuBarUI {
        private MinimizedUI() {
        }

        @Override
        public Dimension getMaximumSize(JComponent jComponent) {
            return new Dimension();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            int n = 0;
            int n2 = 0;
            return new Dimension(n, n2);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
        }

        @Override
        public void update(Graphics graphics, JComponent jComponent) {
        }
    }
}

