/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MText;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.crypto.CryptoUtils;
import org.makagiga.commons.security.MPermission;
import org.makagiga.commons.style.StyleSupport;

public class MPasswordField
extends JPasswordField
implements MText.TextFieldExtensions,
StyleSupport {
    private int minimumPasswordLength = MLogger.isDeveloper() ? 3 : 8;
    private static MNotification.Message capsLockMessage;
    private WeakReference<MPasswordField> anotherPasswordFieldRef;

    public MPasswordField() {
        this((MPasswordField)null);
    }

    public MPasswordField(MPasswordField mPasswordField) {
        this.anotherPasswordFieldRef = TK.newWeakRef(mPasswordField);
        MText.commonSetup(this);
        StaticHandler staticHandler = new StaticHandler(this);
        this.getDocument().addDocumentListener(staticHandler);
        this.addKeyListener(staticHandler);
        MPasswordField.showCapsLockWarning();
    }

    @Override
    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        this.checkPermission("getPassword");
        super.addInputMethodListener(inputMethodListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.checkPermission("getPassword");
        super.addKeyListener(keyListener);
    }

    public static void clear(char[] cArray) {
        CryptoUtils.clear(cArray);
    }

    public MPasswordField getAnotherPasswordField() {
        this.checkPermission("getPassword");
        return this.anotherPasswordFieldRef == null ? null : (MPasswordField)this.anotherPasswordFieldRef.get();
    }

    public void setAnotherPasswordField(MPasswordField mPasswordField) {
        this.checkPermission("getPassword");
        if (this.anotherPasswordFieldRef != null) {
            this.anotherPasswordFieldRef.clear();
        }
        this.anotherPasswordFieldRef = TK.newWeakRef(mPasswordField);
    }

    @Override
    public Document getDocument() {
        this.checkPermission("getPassword");
        return super.getDocument();
    }

    @Override
    public void setDocument(Document document) {
        this.checkPermission("setPassword");
        super.setDocument(document);
    }

    @Override
    public char getEchoChar() {
        return super.getEchoChar();
    }

    @Override
    public void setEchoChar(char c) {
        this.checkPermission("getPassword");
        super.setEchoChar(c);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    public int getMinimumPasswordLength() {
        this.checkPermission("getPassword");
        return this.minimumPasswordLength;
    }

    public void setMinimumPasswordLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Minimum password length must be greater than zero");
        }
        this.minimumPasswordLength = n;
    }

    @Override
    public char[] getPassword() {
        this.checkPermission("getPassword");
        return super.getPassword();
    }

    public Status getPasswordStatus() {
        this.checkPermission("getPassword");
        char[] cArray = this.getPassword();
        if (cArray.length == 0) {
            MPasswordField.clear(cArray);
            return Status.EMPTY;
        }
        if (cArray.length < this.minimumPasswordLength) {
            MPasswordField.clear(cArray);
            return Status.TOO_SHORT;
        }
        if (!this.isEqualWithAnotherPasswordField()) {
            MPasswordField.clear(cArray);
            return Status.NOT_EQUAL;
        }
        boolean bl = true;
        for (char c : cArray) {
            if (c <= '\u007f') continue;
            bl = false;
            break;
        }
        MPasswordField.clear(cArray);
        if (!bl) {
            return Status.NOT_ASCII;
        }
        return Status.OK;
    }

    @Override
    @Deprecated
    public String getText() {
        this.checkPermission("getPassword");
        return super.getText();
    }

    @Override
    public void setText(String string) {
        this.checkPermission("setPassword");
        super.setText(string);
    }

    @Override
    @Deprecated
    public String getText(int n, int n2) throws BadLocationException {
        this.checkPermission("getPassword");
        return super.getText(n, n2);
    }

    public boolean isEqualWithAnotherPasswordField() {
        MPasswordField mPasswordField = this.getAnotherPasswordField();
        if (mPasswordField == null) {
            return true;
        }
        char[] cArray = this.getPassword();
        char[] cArray2 = mPasswordField.getPassword();
        boolean bl = Arrays.equals(cArray, cArray2);
        MPasswordField.clear(cArray);
        MPasswordField.clear(cArray2);
        return bl;
    }

    @Override
    public void clear() {
        this.checkPermission("setPassword");
        char[] cArray = this.getPassword();
        int n = cArray.length;
        MPasswordField.clear(cArray);
        this.setText(TK.filler(' ', n));
        this.setText(null);
    }

    @Override
    public boolean isEmpty() {
        char[] cArray = this.getPassword();
        boolean bl = TK.isEmpty(cArray);
        MPasswordField.clear(cArray);
        return bl;
    }

    @Override
    public void makeDefault() {
        MText.makeDefault(this);
    }

    @Override
    public AutoCompletion getAutoCompletion() {
        return null;
    }

    @Override
    public void saveAutoCompletion() {
    }

    @Override
    public void setAutoCompletion(String string) {
        MText.installAutoCompletion(this, string);
    }

    @Override
    public void setEnterPressAction(Action action) {
        MText.setEnterPressAction(this, action);
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    @Deprecated
    protected void onChange(DocumentEvent documentEvent) {
    }

    private void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            JLabel jLabel = MLabel.getLabel(this);
            String string2 = jLabel != null ? jLabel.getText() : UI._("Unknown");
            securityManager.checkPermission(new Permission(string, string2));
        }
    }

    private static synchronized void showCapsLockWarning() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit.getLockingKeyState(20)) {
                if (capsLockMessage == null) {
                    String string = TK.toString(20, 0);
                    String string2 = UI._("\"{0}\" key is turned on", string);
                    capsLockMessage = new MNotification.Message(string, string2, "ui/warning"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void onClose() {
                            Class<MPasswordField> clazz = MPasswordField.class;
                            synchronized (MPasswordField.class) {
                                capsLockMessage = null;
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    };
                    capsLockMessage.setTimeout(-1);
                    MNotification.showMessage(capsLockMessage);
                }
            } else if (MNotification.getMessageCount() > 0 && capsLockMessage != null) {
                MNotification.getInstance().hideMessage(capsLockMessage);
                capsLockMessage = null;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static final class StaticHandler
    extends MDocumentAdapter<MPasswordField>
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 20) {
                MPasswordField.showCapsLockWarning();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        protected void onChange(DocumentEvent documentEvent) {
            MPasswordField mPasswordField = (MPasswordField)this.getTextComponent();
            if (mPasswordField != null) {
                mPasswordField.onChange(documentEvent);
            }
        }

        private StaticHandler(MPasswordField mPasswordField) {
            super(mPasswordField);
        }
    }

    public static final class Permission
    extends MPermission {
        private Permission(String string, String string2) {
            super(string, PermissionInfo.ThreatLevel.HIGH, "Password Field: " + string2);
        }
    }

    public static enum Status {
        EMPTY(UI._("Password is empty")),
        NOT_ASCII(UI._("Password contains invalid characters")),
        NOT_EQUAL(UI._("Confirmation password is different")),
        OK(UI._("OK")),
        TOO_SHORT(UI._("Password is too short"));

        private String text;

        public String toString() {
            return this.text;
        }

        private Status(String string2) {
            this.text = string2;
        }
    }
}

