/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.ConstructorProperties;
import org.makagiga.commons.AbstractIndicator;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;

public class MRating
extends AbstractIndicator {
    public static final float NO_RATING = 0.0f;
    public static final float RATING_20 = 0.2f;
    public static final float RATING_40 = 0.4f;
    public static final float RATING_60 = 0.6f;
    public static final float RATING_80 = 0.8f;
    public static final float RATING_100 = 1.0f;
    private boolean highlightEnabled = true;
    private static MIcon globalGrayStarIcon;
    private static MIcon globalStarIcon;
    private MouseListener clickMouseListener;
    private MSmallButton clearButton;

    public MRating() {
        this(0.0f);
    }

    @ConstructorProperties(value={"value"})
    public MRating(float f) {
        super(f);
        this.setHBoxLayout();
        this.clickMouseListener = new MMouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (MRating.this.highlightEnabled) {
                    if (mouseEvent.getSource() instanceof MSmallButton) {
                        MRating.this.highlight(0.0f);
                    } else if (mouseEvent.getSource() instanceof RatingButton) {
                        MRating.this.highlight(((RatingButton)RatingButton.class.cast(mouseEvent.getSource())).value);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (MRating.this.highlightEnabled) {
                    MRating.this.highlight(0.0f);
                }
            }
        };
        this.addMouseListener(this.clickMouseListener);
        this.clearButton = new MSmallButton(MIcon.small("ui/clearright"), UI._("No Rating")){

            @Override
            protected void onClick() {
                MRating.this.clicked(Float.valueOf(0.0f));
            }
        };
        this.clearButton.addMouseListener(this.clickMouseListener);
        this.clearButton.setVisible(false);
        this.add(this.clearButton);
        this.addRatingButton(false, 0.2f);
        this.addRatingButton(false, 0.4f);
        this.addRatingButton(false, 0.6f);
        this.addRatingButton(false, 0.8f);
        this.addRatingButton(false, 1.0f);
        this.updateView();
    }

    public boolean isClearButtonVisible() {
        return this.clearButton.isVisible();
    }

    public void setClearButtonVisible(boolean bl) {
        this.clearButton.setVisible(bl);
    }

    public boolean isHighlightEnabled() {
        return this.highlightEnabled;
    }

    public void setHighlightEnabled(boolean bl) {
        this.highlightEnabled = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.clearButton.setEnabled(bl);
    }

    @Override
    public void setValue(float f) {
        float f2 = Math.max(f, 0.0f);
        f2 = Math.min(f2, 1.0f);
        super.setValue(f2);
    }

    protected void addRatingButton(boolean bl, float f) {
        this.add(new RatingButton(bl, f));
    }

    @Override
    protected void updateView() {
        float f = this.getValue();
        int n = 0;
        for (Component component : this.getComponents()) {
            if (!(component instanceof RatingButton)) continue;
            ((RatingButton)RatingButton.class.cast(component)).updateView(++n, f);
        }
    }

    private void clicked(Object object) {
        if (this.getChangeValueOnClick()) {
            if (object instanceof Float) {
                this.setValue(((Float)object).floatValue());
            } else if (object instanceof RatingButton) {
                this.setValue(((RatingButton)RatingButton.class.cast(object)).value);
            }
            this.repaint();
        }
        this.fireStateChanged();
    }

    private MIcon getGrayStarIcon() {
        if (globalGrayStarIcon == null) {
            globalGrayStarIcon = this.getStarIcon().getDisabledInstance();
        }
        return globalGrayStarIcon;
    }

    private MIcon getStarIcon() {
        if (globalStarIcon == null) {
            globalStarIcon = MIcon.small("ui/star").getReflectionInstance();
        }
        return globalStarIcon;
    }

    private void highlight(float f) {
        for (RatingButton ratingButton : ContainerIterator.create(this, RatingButton.class)) {
            if (this.isEnabled() && ratingButton.value <= f) {
                if (UI.isNimbus() && ((Boolean)UI.hackNimbus.get()).booleanValue()) {
                    ratingButton.setBackground(UI.getColor("textHighlight"));
                } else {
                    ratingButton.setBackground(UI.getColor("TextField.selectionBackground"));
                }
                ratingButton.setOpaque(true);
                continue;
            }
            ratingButton.setBackground(null);
            ratingButton.setOpaque(false);
        }
    }

    public class RatingButton
    extends MButton {
        private float value;

        public RatingButton(boolean bl, float f) {
            this.setContentAreaFilled(false);
            this.setCursor(12);
            this.setOpaque(false);
            this.setRequestFocusEnabled(false);
            this.setSelectionIcon(bl);
            this.setStyle("margin: 2; padding: 0");
            this.setToolTipText(UI._("Click to select rating: {0}", this.toString(f)));
            this.value = f;
            this.addMouseListener(MRating.this.clickMouseListener);
        }

        @Override
        public void updateUI() {
            this.setUI(UI.getSimpleButtonUI());
        }

        @Override
        protected void onClick() {
            if (MRating.this.isEnabled()) {
                MRating.this.clicked(this);
            } else {
                TK.beep();
            }
        }

        private void setSelectionIcon(boolean bl) {
            if (bl) {
                this.setIcon(MRating.this.getStarIcon());
            } else {
                this.setIcon(MRating.this.getGrayStarIcon());
            }
        }

        private String toString(float f) {
            int n = f <= 0.2f ? 1 : (f <= 0.4f ? 2 : (f <= 0.6f ? 3 : (f <= 0.8f ? 4 : 5)));
            return n + "/5";
        }

        private void updateView(int n, float f) {
            switch (n) {
                case 1: {
                    this.setSelectionIcon(f >= 0.2f);
                    break;
                }
                case 2: {
                    this.setSelectionIcon(f >= 0.4f);
                    break;
                }
                case 3: {
                    this.setSelectionIcon(f >= 0.6f);
                    break;
                }
                case 4: {
                    this.setSelectionIcon(f >= 0.8f);
                    break;
                }
                case 5: {
                    this.setSelectionIcon(f == 1.0f);
                    break;
                }
                default: {
                    throw new WTFError("Invalid button number: " + n);
                }
            }
        }
    }
}

