/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.UI;

public class MSizeGrip
extends MComponent {
    private boolean _autoSize = true;
    private final Dimension size = new Dimension(10, 10);
    private final Point clickLocation = new Point();
    private static StaticHandler handler;
    private final WeakReference<Container> containerRef;

    public MSizeGrip(Container container) {
        this.containerRef = new WeakReference<Container>(container);
        if (handler == null) {
            handler = new StaticHandler();
        }
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.setCursor(5);
        this.setSize(this.size);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container != null) {
            this.setComponentOrientation(container.getComponentOrientation());
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.size);
    }

    @Override
    public Dimension getSize() {
        return super.getSize();
    }

    @Deprecated
    public boolean isAutoSize() {
        return this._autoSize;
    }

    @Deprecated
    public void setAutoSize(boolean bl) {
        this._autoSize = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.isContainerResizable()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        UI.setAntialiasing(graphics2D, false);
        Color color = MColor.getContrast(UI.getBackground(this));
        Color color2 = MColor.getBrighter(color);
        this.drawLine(graphics2D, color, color2, 0);
        this.drawLine(graphics2D, color, color2, 3);
        this.drawLine(graphics2D, color, color2, 6);
        graphics2D.dispose();
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
    }

    private void doDrag(MouseEvent mouseEvent) {
        Container container = (Container)this.containerRef.get();
        if (container == null) {
            return;
        }
        Point point = container.getLocationOnScreen();
        int n = mouseEvent.getXOnScreen() - point.x + this.clickLocation.x;
        int n2 = mouseEvent.getYOnScreen() - point.y + this.clickLocation.y;
        Dimension dimension = container.isMinimumSizeSet() ? container.getMinimumSize() : new Dimension(50, 50);
        container.setSize(Math.max(n, dimension.width), Math.max(n2, dimension.height));
    }

    private void drawLine(Graphics graphics, Color color, Color color2, int n) {
        int n2 = this.getWidth() - 1;
        int n3 = this.getHeight() - 1;
        graphics.setColor(color2);
        graphics.drawLine(n2 - n, n3, n2, n3 - n);
        graphics.setColor(color);
        graphics.drawLine(n2 - (n + 1), n3, n2, n3 - (n + 1));
    }

    private boolean isContainerResizable() {
        Container container = (Container)this.containerRef.get();
        if (container instanceof JDialog) {
            return ((JDialog)JDialog.class.cast(container)).isResizable();
        }
        if (container instanceof JFrame) {
            return ((JFrame)JFrame.class.cast(container)).isResizable();
        }
        if (container instanceof JInternalFrame) {
            return ((JInternalFrame)JInternalFrame.class.cast(container)).isResizable();
        }
        return false;
    }

    void moveToCorner() {
        Container container = this.getParent();
        if (container != null) {
            this.setLocation(container.getWidth() - this.getWidth(), container.getHeight() - this.getHeight());
        }
    }

    private static final class StaticHandler
    extends MMouseAdapter {
        private StaticHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MSizeGrip mSizeGrip = (MSizeGrip)mouseEvent.getSource();
            mSizeGrip.doDrag(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MSizeGrip mSizeGrip = (MSizeGrip)mouseEvent.getSource();
            mSizeGrip.clickLocation.setLocation(mSizeGrip.getWidth() - mouseEvent.getX() + 1, mSizeGrip.getHeight() - mouseEvent.getY() + 1);
        }
    }
}

