/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.beans.ConstructorProperties;
import java.lang.ref.WeakReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MColorButton;
import org.makagiga.commons.MColorIcon;
import org.makagiga.commons.MColorPicker;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MSmallColorButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueEvent;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.color.ColorPalette;
import org.makagiga.commons.form.FieldEditor;
import org.makagiga.commons.painters.PainterFactory;

@FieldEditor(type=Color.class, valueProperty="color", labelProperty="title")
public class MSmallColorChooser
extends MPanel {
    public static final String COLOR_PROPERTY = "color";
    private Color[] colors;
    private MColorButton colorButton;
    private MLabel titleLabel;
    private MSmallButton clearButton;

    public MSmallColorChooser(String string, Color ... colorArray) {
        super(0);
        this.setOpaque(false);
        this.colors = (Color[])TK.copyOf((Object[])TK.checkNull(colorArray, "colors"));
        this.clearButton = new MSmallButton(MActionInfo.RESTORE_DEFAULT_VALUES);
        this.clearButton.setVisible(false);
        this.colorButton = new MColorButton(){

            @Override
            protected MMenu onPopupMenu() {
                return MSmallColorChooser.this.createColorMenu();
            }
        };
        this.colorButton.setPopupMenuEnabled(true);
        this.colorButton.addValueListener(new ValueListener<Color>(){

            @Override
            public void valueChanged(ValueEvent<Color> valueEvent) {
                MSmallColorChooser.this.firePropertyChange(MSmallColorChooser.COLOR_PROPERTY, valueEvent.getOldValue(), valueEvent.getNewValue());
                MSmallColorChooser.this.fireStateChanged();
            }
        });
        this.add(this.colorButton);
        this.titleLabel = new MLabel();
        this.titleLabel.setLabelFor(this.colorButton);
        this.titleLabel.setStyle("font-size: smaller; margin-left: 5");
        this.add(this.titleLabel);
        this.setTitle(string);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MSmallColorChooser.this.onChange();
            }
        });
        this.setMargin(1);
        this.setPainter(PainterFactory.newGlassPainter());
    }

    @ConstructorProperties(value={"title"})
    public MSmallColorChooser(String string) {
        this(string, MSmallColorChooser.createDefaultPalette());
    }

    public MSmallColorChooser() {
        this((String)null);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    @Deprecated
    public static Color[] createDefaultPalette() {
        return ColorPalette.getApplicationPalette().toColorList().toArray(new Color[0]);
    }

    @Deprecated
    public static Color[] createWeb20Palette() {
        return ColorPalette.getWeb20Palette().toColorList().toArray(new Color[0]);
    }

    public MSmallButton getClearButton() {
        return this.clearButton;
    }

    public Color getColor() {
        return this.colorButton.getColor();
    }

    public void setColor(Color color) {
        Color color2 = this.getColor();
        this.colorButton.setColor(color);
        if (TK.isChange(color2, color)) {
            this.firePropertyChange(COLOR_PROPERTY, color2, color);
        }
    }

    public Color getDefaultColor() {
        return this.colorButton.getDefaultColor();
    }

    public void setDefaultColor(Color color) {
        this.colorButton.setDefaultColor(color);
    }

    @Override
    public String getTitle() {
        return this.titleLabel.getText();
    }

    @Override
    public void setTitle(String string) {
        this.titleLabel.setText(TK.isEmpty(string) ? UI._("Color") : string);
    }

    public MLabel getTitleLabel() {
        return this.titleLabel;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }

    protected MMenu createColorMenu() {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        if (this.colors.length > 0) {
            ColorPalette colorPalette = ColorPalette.getNamedColors();
            for (Color color : this.colors) {
                mMenu.add(new ColorAction(color, colorPalette.getDisplayName(color)));
            }
            mMenu.addSeparator();
        }
        mMenu.add(new MAction(UI._("More...")){

            @Override
            public void onAction() {
                MSmallColorChooser.this.colorButton.selectColor();
            }
        });
        mMenu.addSeparator();
        for (ColorPalette colorPalette : ColorPalette.getAll()) {
            if (colorPalette.getCount() > 150 || colorPalette == ColorPalette.getApplicationPalette() || "Gold".equals(colorPalette.toString()) || "Grays".equals(colorPalette.toString()) || "Paintjet".equals(colorPalette.toString())) continue;
            mMenu.add(new ColorPaletteMenu(colorPalette, this));
        }
        if (this.clearButton.isVisible()) {
            mMenu.addSeparator();
            mMenu.add(new MAction(MActionInfo.RESTORE_DEFAULT_VALUES){

                @Override
                public void onAction() {
                    MSmallColorChooser.this.setColor(null);
                    MSmallColorChooser.this.fireStateChanged();
                }
            });
        }
        return mMenu;
    }

    protected void fireStateChanged() {
        TK.fireStateChanged(this, this.getChangeListeners());
    }

    protected void onChange() {
    }

    private static final class ColorPaletteMenuAdapter
    extends MMenuAdapter {
        @Override
        protected void onSelect(MMenu mMenu) {
            final ColorPaletteMenu colorPaletteMenu = (ColorPaletteMenu)mMenu;
            if (colorPaletteMenu.isEmpty()) {
                colorPaletteMenu.add(new MColorPicker(colorPaletteMenu.colorPalette){

                    @Override
                    protected void onChange() {
                        MSmallColorChooser mSmallColorChooser = (MSmallColorChooser)colorPaletteMenu.chooserRef.get();
                        mSmallColorChooser.setColor(super.getColor());
                        mSmallColorChooser.fireStateChanged();
                        MMenu.hideCurrentPopup();
                    }
                });
            }
        }

        private ColorPaletteMenuAdapter() {
            super(false);
        }
    }

    private static final class ColorPaletteMenu
    extends MMenu {
        private final ColorPalette colorPalette;
        private final WeakReference<MSmallColorChooser> chooserRef;

        private ColorPaletteMenu(ColorPalette colorPalette, MSmallColorChooser mSmallColorChooser) {
            super(colorPalette.toString(), colorPalette);
            this.colorPalette = colorPalette;
            this.chooserRef = TK.newWeakRef(mSmallColorChooser);
            this.addMenuListener(new ColorPaletteMenuAdapter());
        }
    }

    private final class ColorAction
    extends MDataAction<Color> {
        @Override
        public void onAction() {
            MSmallColorChooser.this.setColor((Color)this.getData());
            MSmallColorChooser.this.fireStateChanged();
        }

        private ColorAction(Color color, String string) {
            super(color, string, new MColorIcon(color, 17, 17, MColorIcon.Type.RECTANGLE));
            this.setLongDescription(MSmallColorButton.getToolTipText(color, null));
        }
    }
}

