/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.makagiga.commons.ColumnManager;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MTable;

public class MTableHeader
extends JTableHeader {
    private boolean showToolTipText = true;
    private PrintTableCellRenderer printTableCellRenderer;

    public MTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        StaticHandler staticHandler = new StaticHandler();
        this.addMouseListener(staticHandler);
    }

    @Override
    public TableCellRenderer getDefaultRenderer() {
        if (this.isPaintingForPrint()) {
            if (this.printTableCellRenderer == null) {
                this.printTableCellRenderer = new PrintTableCellRenderer();
            }
            return this.printTableCellRenderer;
        }
        return super.getDefaultRenderer();
    }

    @Deprecated
    public boolean getShowToolTipText() {
        return this.showToolTipText;
    }

    @Deprecated
    public void setShowToolTipText(boolean bl) {
        this.showToolTipText = bl;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        TableColumn tableColumn;
        if (!this.showToolTipText) {
            return null;
        }
        int n = this.columnAtPoint(mouseEvent.getPoint());
        String string = "";
        if (n != -1 && (tableColumn = this.columnModel.getColumn(n)) != null && (object = tableColumn.getHeaderValue()) != null) {
            string = object.toString();
        }
        return string;
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.reorderingAllowed = Kiosk.tableColumnReorderingAllowed.booleanValue();
        this.resizingAllowed = Kiosk.tableColumnReorderingAllowed.booleanValue();
    }

    private static final class StaticHandler
    extends MMouseAdapter {
        @Override
        public void popupTrigger(MouseEvent mouseEvent) {
            if (!((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
                return;
            }
            MTableHeader mTableHeader = (MTableHeader)mouseEvent.getSource();
            JTable jTable = mTableHeader.getTable();
            if (!(jTable instanceof MTable)) {
                return;
            }
            MTable mTable = (MTable)jTable;
            ColumnManager columnManager = mTable.getColumnManager();
            MMenu mMenu = columnManager.createMenu();
            mMenu.showPopup(mouseEvent);
        }

        private StaticHandler() {
        }
    }

    private static final class PrintTableCellRenderer
    extends MRenderer<Object> {
        @Override
        protected void onRender(Object object) {
            MLabel mLabel = this.getLabel();
            mLabel.setBackground(MColor.WHITE);
            mLabel.setForeground(MColor.BLACK);
            mLabel.setOpaque(true);
            mLabel.setStyle("font-weight: bold");
            mLabel.setText(object == null ? null : object.toString());
        }

        private PrintTableCellRenderer() {
        }
    }
}

