/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.im.InputContext;
import java.awt.im.spi.InputMethodDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.FS;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MUndoManager;
import org.makagiga.commons.OS;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.fx.Blend;

public final class MText {
    public static final int MARGIN = 2;
    public static final String CUT = "org.makagiga.commons.MText.cut";
    public static final String COPY = "org.makagiga.commons.MText.copy";
    public static final String PASTE = "org.makagiga.commons.MText.paste";
    public static final String PASTE_HTML = "org.makagiga.commons.MText.pasteHTML";
    public static final String CLEAR = "org.makagiga.commons.MText.clear";
    public static final String DELETE = "org.makagiga.commons.MText.delete";
    public static final String SELECT_ALL = "org.makagiga.commons.MText.selectAll";
    public static final String SPELLING = "org.makagiga.commons.MText.spelling";
    @Deprecated
    public static final String INSERT_DATE = "org.makagiga.commons.MText.insertDate";
    public static final String NO_GLOBAL_MENU = "org.makagiga.commons.MText.noGlobalMenu";
    private static Handler handler;
    private static List<GlobalMenu> globalMenus;
    private static SoftReference<SpellChecker> spellCheckerSoftCache;
    private static String spellCheckerClassName;
    private static final String AUTO_COMPLETION = "org.makagiga.commons.MText.autoCompletion";
    private static final String AUTO_HIDE_TIMER = "org.makagiga.commons.MText.autoHideTimer";
    private static final String CAN_PASTE = "org.makagiga.commons.MText.canPaste";
    private static final String CAN_PASTE_HTML = "org.makagiga.commons.MText.canPasteHTML";
    private static final String MODIFIABLE = "org.makagiga.commons.MText.modifiable";
    private static final String UNDO_MANAGER = "org.makagiga.commons.MText.undoManager";
    private static final String UNDO_MANAGER_LISTENER = "org.makagiga.commons.MText.undoManagerListener";
    private static final String USER_MENU = "org.makagiga.commons.MText.userMenu";

    public static void addGlobalMenu(GlobalMenu globalMenu) {
        globalMenus.add(globalMenu);
    }

    public static void removeGlobalMenu(GlobalMenu globalMenu) {
        globalMenus.remove(globalMenu);
    }

    public static void commonSetup(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof JPasswordField)) {
            jTextComponent.setDragEnabled((Boolean)Kiosk.actionDragDrop.get());
        }
        MText.setupMargin(jTextComponent);
        MText.install(jTextComponent);
    }

    public static void copyAll(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return;
        }
        MText.selectAll(jTextComponent);
        jTextComponent.copy();
    }

    public static synchronized SpellChecker createDefaultSpellChecker() throws Throwable {
        return (SpellChecker)TK.newInstance(spellCheckerClassName);
    }

    public static MMenu createMenu(JTextComponent jTextComponent) {
        UserMenu userMenu;
        MText.updateActions(jTextComponent);
        MMenu mMenu = new MMenu();
        if (!(jTextComponent instanceof JPasswordField)) {
            boolean bl = MText.isMultiline(jTextComponent);
            if (jTextComponent.isEditable()) {
                MUndoManager object = MText.getUndoManager(jTextComponent);
                if (object != null) {
                    object.updateMenu(mMenu);
                    mMenu.addSeparator();
                }
                mMenu.add(MText.getAction(jTextComponent, CUT));
                mMenu.add(MText.getAction(jTextComponent, COPY));
                mMenu.add(MText.getAction(jTextComponent, PASTE));
                if (bl) {
                    mMenu.add(MText.getAction(jTextComponent, PASTE_HTML));
                }
                mMenu.add(MText.getAction(jTextComponent, DELETE));
                if (OS.isKDE()) {
                    mMenu.add(MText.getAction(jTextComponent, CLEAR));
                }
                mMenu.addSeparator();
            } else {
                mMenu.add(MText.getAction(jTextComponent, COPY));
            }
            mMenu.add(MText.getAction(jTextComponent, SELECT_ALL));
            if (jTextComponent.isEditable()) {
                if (MText.getDefaultSpellChecker() != null) {
                    mMenu.add(MText.getAction(jTextComponent, SPELLING));
                }
                MMenu mMenu2 = new MMenu(UI._("More"));
                mMenu2.addTitle(UI._("Insert Symbol"));
                mMenu2.add(new InsertSymbolAction(jTextComponent, '\u20ac', "Euro Sign"));
                mMenu2.add(new InsertSymbolAction(jTextComponent, '\u00a9', "Copyright Sign"));
                mMenu2.add(new InsertSymbolAction(jTextComponent, '\u00ae', "Registered Sign"));
                mMenu2.add(new InsertSymbolAction(jTextComponent, '\u2122', "Trade Mark Sign"));
                if (bl) {
                    mMenu2.add(new InsertSymbolAction(jTextComponent, '\u2610', "Ballot box"));
                    mMenu2.add(new InsertSymbolAction(jTextComponent, '\u2611', "Ballot box with check"));
                    mMenu2.add(new InsertSymbolAction(jTextComponent, '\u2612', "Ballot box with X"));
                    mMenu2.addTitle(UI._("Insert Date/Time"));
                    mMenu2.add(new InsertDateAction(jTextComponent, 2, 3));
                    mMenu2.add(new InsertDateAction(jTextComponent, 0, -1));
                    mMenu2.add(new InsertDateAction(jTextComponent, "EEE MMM d yyyy"));
                    mMenu2.add(new InsertDateAction(jTextComponent, "EEE MMM d HH:mm yyyy"));
                    mMenu2.add(new InsertDateAction(jTextComponent, 2, -1));
                    mMenu2.add(new InsertDateAction(jTextComponent, -1, 3));
                    mMenu2.add(new InsertDateAction(jTextComponent, "yyyy-MM-dd HH:mm:ss"));
                }
                mMenu2.addSeparator();
                mMenu2.add(new InputMethodAction(jTextComponent));
                if (MText.getAutoCompletion(jTextComponent) != null) {
                    mMenu2.add(new AutoCompletion.HistoryAction(jTextComponent));
                }
                mMenu.add(mMenu2);
            }
        }
        if (((Boolean)Kiosk.textExtraMenu.get()).booleanValue() && !globalMenus.isEmpty() && !UI.getClientProperty(jTextComponent, NO_GLOBAL_MENU, false).booleanValue()) {
            if (!mMenu.isEmpty()) {
                mMenu.addSeparator();
            }
            for (GlobalMenu globalMenu : globalMenus) {
                globalMenu.onGlobalMenu(jTextComponent, mMenu);
            }
        }
        if ((userMenu = (UserMenu)UI.getClientProperty(jTextComponent, USER_MENU, null)) != null) {
            userMenu.onUserMenu(jTextComponent, mMenu);
        }
        return mMenu;
    }

    public static void deinstallKit(JEditorPane jEditorPane) {
        EditorKit editorKit = jEditorPane.getEditorKit();
        if (editorKit != null) {
            editorKit.deinstall(jEditorPane);
        }
    }

    public static boolean disableCaretUpdate(JTextComponent jTextComponent) {
        Caret caret = jTextComponent.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)DefaultCaret.class.cast(caret)).setUpdatePolicy(1);
            return true;
        }
        return false;
    }

    public static MAction getAction(JTextComponent jTextComponent, String string) {
        return UI.getClientProperty(jTextComponent, string, null);
    }

    public static AutoCompletion getAutoCompletion(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        if (jTextComponent instanceof JPasswordField) {
            return null;
        }
        return UI.getClientProperty(jTextComponent, AUTO_COMPLETION, null);
    }

    public static synchronized String getDefaultSpellChecker() {
        return spellCheckerClassName;
    }

    public static synchronized void setDefaultSpellChecker(String string) {
        MLogger.debug("core", "Setting default spell checker to \"%s\"...", string);
        spellCheckerClassName = string;
    }

    public static Action getEnterPressAction(JTextField jTextField) {
        Object object = jTextField.getInputMap(0).get(KeyStroke.getKeyStroke(10, 0));
        return object instanceof Action ? (Action)object : null;
    }

    public static void setEnterPressAction(JTextField jTextField, Action action) {
        if (action == null) {
            jTextField.getInputMap(0).remove(KeyStroke.getKeyStroke(10, 0));
        } else {
            if (MAction.getValue(action, "Name", null) == null) {
                action.putValue("Name", jTextField.getClass().getName() + "-enterPressAction");
            }
            MAction.connect(jTextField, 0, 10, action);
        }
    }

    public static MMenu getMenu(JTextComponent jTextComponent, String string) {
        return UI.getClientProperty(jTextComponent, string, null);
    }

    public static String getPlainText(JTextComponent jTextComponent) {
        try {
            Document document = jTextComponent.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (Exception exception) {
            MLogger.exception(exception);
            return null;
        }
    }

    public static MUndoManager getUndoManager(JTextComponent jTextComponent) {
        return UI.getClientProperty(jTextComponent, UNDO_MANAGER, null);
    }

    public static boolean goTo(JTextComponent jTextComponent, int n, int n2) {
        int n3;
        jTextComponent.requestFocusInWindow();
        if (n == -1 && n2 == -1) {
            return false;
        }
        String string = jTextComponent.getText();
        int n4 = 1;
        int n5 = -1;
        for (n3 = 0; n3 < string.length(); ++n3) {
            if (n3 == jTextComponent.getCaretPosition()) {
                n5 = n4;
                break;
            }
            if (string.charAt(n3) != '\n') continue;
            ++n4;
        }
        n4 = 1;
        for (n3 = 0; n3 < string.length(); ++n3) {
            if (n4 == n) {
                if (n2 == -1) {
                    if (n5 == -1 || n != n5) {
                        jTextComponent.setCaretPosition(n3);
                    }
                } else {
                    jTextComponent.setCaretPosition(n3 + n2 - 1);
                }
                return true;
            }
            if (string.charAt(n3) != '\n') continue;
            ++n4;
        }
        return false;
    }

    public static boolean hasSelection(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaretPosition();
        return jTextComponent.getSelectionEnd() != n || jTextComponent.getSelectionStart() != n;
    }

    public static boolean insertString(JTextComponent jTextComponent, String string) {
        return MText.insertString(jTextComponent, string, jTextComponent.getCaretPosition());
    }

    public static boolean insertString(JTextComponent jTextComponent, String string, int n) {
        try {
            jTextComponent.getDocument().insertString(n, string, null);
            return true;
        }
        catch (BadLocationException badLocationException) {
            MLogger.exception(badLocationException);
            return false;
        }
    }

    public static void install(JTextComponent jTextComponent) {
        if (handler == null) {
            handler = new Handler();
        }
        jTextComponent.addCaretListener(handler);
        jTextComponent.addKeyListener(handler);
        jTextComponent.addMouseListener(handler);
        jTextComponent.addMouseMotionListener(handler);
        if (jTextComponent instanceof JPasswordField) {
            return;
        }
        MText.installUndoManager(jTextComponent);
        StaticAction staticAction = new StaticAction(jTextComponent, MActionInfo.CUT){

            @Override
            public void onAction() {
                this.getTextComponent().cut();
            }
        };
        staticAction.setHTMLHelp(UI._("Cuts the selected text to the clipboard."));
        StaticAction staticAction2 = new StaticAction(jTextComponent, MActionInfo.COPY){

            @Override
            public void onAction() {
                this.getTextComponent().copy();
            }
        };
        staticAction2.setHTMLHelp(UI._("Copies the selected text to the clipboard."));
        String string = UI._("Pastes from the clipboard.");
        StaticAction staticAction3 = new StaticAction(jTextComponent, MActionInfo.PASTE){

            @Override
            public void onAction() {
                this.getTextComponent().paste();
            }
        };
        staticAction3.setHTMLHelp(string);
        StaticAction staticAction4 = new StaticAction(jTextComponent, UI._("Paste as HTML")){

            @Override
            public void onAction() {
                MText.pasteHTML(this.getTextComponent());
            }
        };
        staticAction4.setHTMLHelp(string);
        StaticAction staticAction5 = new StaticAction(jTextComponent, MActionInfo.CLEAR_RIGHT){

            @Override
            public void onAction() {
                this.getTextComponent().setText(null);
            }
        };
        staticAction5.setHTMLHelp(UI._("Clears all text."));
        StaticAction staticAction6 = new StaticAction(jTextComponent, MActionInfo.DELETE_NO_KEY_STROKE){

            @Override
            public void onAction() {
                this.getTextComponent().replaceSelection(null);
            }
        };
        staticAction6.setHTMLHelp(UI._("Deletes the selected text."));
        StaticAction staticAction7 = new StaticAction(jTextComponent, MActionInfo.SELECT_ALL){

            @Override
            public void onAction() {
                MText.selectAll(this.getTextComponent());
            }
        };
        staticAction7.setHTMLHelp(UI._("Selects all text."));
        StaticAction staticAction8 = new StaticAction(jTextComponent, UI._("Spelling")){

            @Override
            public void onAction() {
                MText.spelling(this.getTextComponent());
            }
        };
        staticAction8.setIconName("ui/checkspelling");
        if (jTextComponent instanceof JTextField) {
            staticAction5.connect(jTextComponent, 0, 85, MAction.getMenuMask());
        }
        staticAction.connect(jTextComponent, 0, 127, 1);
        staticAction2.connect(jTextComponent, 0, 155, MAction.getMenuMask());
        staticAction3.connect(jTextComponent, 0, 155, 1);
        jTextComponent.putClientProperty(CUT, staticAction);
        jTextComponent.putClientProperty(COPY, staticAction2);
        jTextComponent.putClientProperty(PASTE, staticAction3);
        jTextComponent.putClientProperty(PASTE_HTML, staticAction4);
        jTextComponent.putClientProperty(CLEAR, staticAction5);
        jTextComponent.putClientProperty(DELETE, staticAction6);
        jTextComponent.putClientProperty(SELECT_ALL, staticAction7);
        jTextComponent.putClientProperty(SPELLING, staticAction8);
        if (jTextComponent instanceof Modifiable) {
            MText.installModifiable(jTextComponent, (Modifiable)((Object)jTextComponent));
        }
    }

    public static void installAutoCompletion(JTextComponent jTextComponent, String string) {
        if (jTextComponent == null) {
            return;
        }
        if (jTextComponent instanceof JPasswordField) {
            throw new IllegalArgumentException("Cannot set text auto completion for password field");
        }
        jTextComponent.putClientProperty(AUTO_COMPLETION, new AutoCompletion(jTextComponent, string));
    }

    public static boolean isMultiline(JTextComponent jTextComponent) {
        return jTextComponent instanceof JEditorPane || jTextComponent instanceof JTextArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(JTextComponent jTextComponent, File file) throws IOException {
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            MText.load(jTextComponent, bufferedFileInput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
    }

    public static void load(JTextComponent jTextComponent, InputStream inputStream) throws IOException {
        MText.load(jTextComponent, FS.getUTF8Reader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(JTextComponent jTextComponent, Reader reader) throws IOException {
        try {
            MText.uninstallUndoManager(jTextComponent);
            jTextComponent.read(reader, null);
        }
        finally {
            FS.close(reader);
            MText.finishLoad(jTextComponent);
        }
    }

    public static void load(JTextComponent jTextComponent, String string) throws IOException {
        MText.load(jTextComponent, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadHTML(JEditorPane jEditorPane, InputStream inputStream) throws IOException {
        try {
            MText.uninstallUndoManager(jEditorPane);
            jEditorPane.read(inputStream, (Object)jEditorPane.getDocument());
        }
        finally {
            MText.finishLoad(jEditorPane);
        }
    }

    public static void makeDefault(JTextComponent jTextComponent) {
        boolean bl;
        if (jTextComponent == null) {
            return;
        }
        MText.selectAll(jTextComponent);
        boolean bl2 = bl = !UI.isNimbus() && !UI.isSubstance();
        if (jTextComponent instanceof JTextField && bl) {
            Blend.textField((JTextField)jTextComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(JTextComponent jTextComponent, File file) throws IOException {
        FS.BufferedFileOutput bufferedFileOutput = null;
        try {
            bufferedFileOutput = new FS.BufferedFileOutput(file);
            MText.save(jTextComponent, bufferedFileOutput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileOutput);
            throw throwable;
        }
        FS.close(bufferedFileOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(JTextComponent jTextComponent, OutputStream outputStream) throws IOException {
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(outputStream);
            if (jTextComponent.getDocument().getLength() == 0) {
                textWriter.println();
            } else {
                jTextComponent.write(textWriter);
            }
        }
        finally {
            FS.close(textWriter);
        }
    }

    public static void save(JTextComponent jTextComponent, String string) throws IOException {
        MText.save(jTextComponent, new File(string));
    }

    public static void saveAutoCompletion(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return;
        }
        if (jTextComponent instanceof JPasswordField) {
            return;
        }
        AutoCompletion autoCompletion = MText.getAutoCompletion(jTextComponent);
        if (autoCompletion != null) {
            autoCompletion.addItem(jTextComponent.getText());
            autoCompletion.save();
        }
    }

    public static void selectAll(JTextComponent jTextComponent) {
        jTextComponent.requestFocusInWindow();
        jTextComponent.selectAll();
    }

    public static void setMaximumLength(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            if (n == -1) {
                if (abstractDocument.getDocumentFilter() instanceof MaximumLengthDocumentFilter) {
                    abstractDocument.setDocumentFilter(null);
                }
            } else {
                abstractDocument.setDocumentFilter(new MaximumLengthDocumentFilter(n));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setText(JTextComponent jTextComponent, String string) {
        AutoCompletion autoCompletion = MText.getAutoCompletion(jTextComponent);
        if (autoCompletion == null) {
            jTextComponent.setText(string);
        } else {
            boolean bl = (Boolean)autoCompletion.enabled.get();
            try {
                autoCompletion.enabled.no();
                jTextComponent.setText(string);
            }
            finally {
                autoCompletion.enabled.set(bl);
            }
        }
    }

    public static void setupMargin(JTextComponent jTextComponent) {
        if (!(UI.isA03() || UI.isSubstance() || UI.isSynth() || UI.isWindows())) {
            jTextComponent.setMargin(UI.createInsets(2));
        }
    }

    public static void setUserMenu(JTextComponent jTextComponent, UserMenu<?> userMenu) {
        jTextComponent.putClientProperty(USER_MENU, userMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spelling(JTextComponent jTextComponent) {
        SpellChecker spellChecker = null;
        try {
            Class<MText> clazz = MText.class;
            synchronized (MText.class) {
                if (spellCheckerSoftCache != null) {
                    spellChecker = spellCheckerSoftCache.get();
                }
                if (spellChecker == null) {
                    spellChecker = MText.createDefaultSpellChecker();
                    spellCheckerSoftCache = new SoftReference<SpellChecker>(spellChecker);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            MLogger.exception(throwable);
            MStatusBar.error(UI._("Could not initialize spell checker"));
            return;
        }
        {
            try {
                spellChecker.setProperty("interactive", true);
                spellChecker.setProperty("locale", jTextComponent.getLocale());
                spellChecker.check(jTextComponent);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                MMessage.error(null, throwable);
            }
            return;
        }
    }

    public static void uninstallUndoManager(JTextComponent jTextComponent) {
        MUndoManager mUndoManager = MText.getUndoManager(jTextComponent);
        if (mUndoManager != null) {
            mUndoManager.getUndoAction().disconnect(jTextComponent, 0);
            mUndoManager.getRedoAction().disconnect(jTextComponent, 0);
            UndoableEditListener undoableEditListener = UI.getClientProperty(jTextComponent, UNDO_MANAGER_LISTENER, null);
            if (undoableEditListener != null) {
                jTextComponent.getDocument().removeUndoableEditListener(undoableEditListener);
            }
            if (mUndoManager.owner != null) {
                mUndoManager.owner.clear();
                mUndoManager.owner = null;
            }
        }
    }

    public static void updateActions(JTextComponent jTextComponent) {
        if (jTextComponent instanceof JPasswordField) {
            return;
        }
        boolean bl = jTextComponent.isEditable();
        boolean bl2 = jTextComponent.getDocument().getLength() == 0;
        MUndoManager mUndoManager = MText.getUndoManager(jTextComponent);
        if (mUndoManager != null) {
            mUndoManager.updateUndoRedoActions(bl);
        }
        MText.getAction(jTextComponent, CLEAR).setEnabled(bl && !bl2);
        MText.getAction(jTextComponent, SELECT_ALL).setEnabled(!bl2);
        MText.getAction(jTextComponent, SPELLING).setEnabled(bl && !bl2);
        MText.updateSelectionActions(jTextComponent);
        boolean bl3 = bl && UI.getClientProperty(jTextComponent, CAN_PASTE, true) != false;
        MText.getAction(jTextComponent, PASTE).setEnabled(bl3);
        boolean bl4 = bl && UI.getClientProperty(jTextComponent, CAN_PASTE_HTML, true) != false;
        MText.getAction(jTextComponent, PASTE_HTML).setEnabled(bl4);
    }

    public static void updatePasteAction(JTextComponent jTextComponent) {
        DataFlavor[] dataFlavorArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = jTextComponent.isEditable();
        Clipboard clipboard = MClipboard.getDefault();
        for (DataFlavor dataFlavor : dataFlavorArray = MDataTransfer.getAvailableDataFlavors(clipboard)) {
            if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
            bl = true;
            break;
        }
        if (MText.isMultiline(jTextComponent)) {
            bl2 = MDataTransfer.findBestHTMLFlavor(dataFlavorArray, false) != null;
        }
        MText.getAction(jTextComponent, PASTE).setEnabled(bl && bl3);
        jTextComponent.putClientProperty(CAN_PASTE, bl);
        MText.getAction(jTextComponent, PASTE_HTML).setEnabled(bl2 && bl3);
        jTextComponent.putClientProperty(CAN_PASTE_HTML, bl2);
    }

    public static void updateToolBar(JTextComponent jTextComponent, MToolBar mToolBar) {
        MUndoManager mUndoManager = MText.getUndoManager(jTextComponent);
        if (mUndoManager != null) {
            mUndoManager.updateToolBar(mToolBar);
            mToolBar.addSeparator();
        }
        mToolBar.add(MText.getAction(jTextComponent, CUT));
        mToolBar.add(MText.getAction(jTextComponent, COPY), 1);
        mToolBar.add(MText.getAction(jTextComponent, PASTE), 1);
        if (MText.getDefaultSpellChecker() != null) {
            mToolBar.addSeparator();
            mToolBar.add(MText.getAction(jTextComponent, SPELLING));
        }
    }

    private MText() {
    }

    private static void finishLoad(JTextComponent jTextComponent) {
        if (jTextComponent instanceof Modifiable) {
            MText.installModifiable(jTextComponent, (Modifiable)((Object)jTextComponent));
        }
        MText.installUndoManager(jTextComponent);
        if (jTextComponent instanceof Modifiable) {
            ((Modifiable)Modifiable.class.cast(jTextComponent)).setModified(false, null);
        }
    }

    private static void installModifiable(JTextComponent jTextComponent, Modifiable modifiable) {
        StaticModifiableDocumentHandler staticModifiableDocumentHandler = new StaticModifiableDocumentHandler(modifiable);
        jTextComponent.getDocument().addDocumentListener(staticModifiableDocumentHandler);
        if (jTextComponent != modifiable) {
            jTextComponent.putClientProperty(MODIFIABLE, modifiable);
        }
    }

    private static void installUndoManager(JTextComponent jTextComponent) {
        if (jTextComponent instanceof JPasswordField) {
            return;
        }
        MText.uninstallUndoManager(jTextComponent);
        MUndoManager mUndoManager = new MUndoManager(jTextComponent){

            @Override
            public void updateUserActions() {
                JComponent jComponent = this.getOwner();
                if (jComponent instanceof JTextComponent) {
                    MText.updateActions((JTextComponent)jComponent);
                }
            }
        };
        UndoableEditListener undoableEditListener = mUndoManager.createUndoableEditListener();
        jTextComponent.getDocument().addUndoableEditListener(undoableEditListener);
        jTextComponent.putClientProperty(UNDO_MANAGER, mUndoManager);
        jTextComponent.putClientProperty(UNDO_MANAGER_LISTENER, undoableEditListener);
        mUndoManager.getUndoAction().connect((JComponent)jTextComponent, 0);
        mUndoManager.getRedoAction().connect((JComponent)jTextComponent, 0);
    }

    private static void pasteHTML(JTextComponent jTextComponent) {
        try {
            Clipboard clipboard = MClipboard.getDefault();
            DataFlavor[] dataFlavorArray = MDataTransfer.getAvailableDataFlavors(clipboard);
            DataFlavor dataFlavor = MDataTransfer.findBestHTMLFlavor(dataFlavorArray, false);
            if (dataFlavor != null) {
                String string = MDataTransfer.getHTML(clipboard, dataFlavor);
                MText.insertString(jTextComponent, string);
            } else {
                MStatusBar.error(UI._("Paste failed"));
            }
        }
        catch (IOException iOException) {
            MStatusBar.error(iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            MStatusBar.error(unsupportedFlavorException);
        }
    }

    private static void setCursorVisible(JTextComponent jTextComponent, boolean bl) {
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return;
        }
        MTimer mTimer = UI.getClientProperty(jTextComponent, AUTO_HIDE_TIMER, null);
        if (bl) {
            if (mTimer != null) {
                mTimer.stop();
            }
            jTextComponent.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            if (mTimer == null) {
                mTimer = new AutoHideTimer(jTextComponent);
                jTextComponent.putClientProperty(AUTO_HIDE_TIMER, mTimer);
            }
            mTimer.restart();
        }
    }

    private static void updateSelectionActions(JTextComponent jTextComponent) {
        if (jTextComponent instanceof JPasswordField) {
            return;
        }
        boolean bl = jTextComponent.isEditable();
        boolean bl2 = MText.hasSelection(jTextComponent);
        MText.getAction(jTextComponent, CUT).setEnabled(bl && bl2);
        MText.getAction(jTextComponent, COPY).setEnabled(bl2);
        MText.getAction(jTextComponent, DELETE).setEnabled(bl && bl2);
    }

    static {
        globalMenus = new ArrayList<GlobalMenu>();
    }

    private static final class StaticModifiableDocumentHandler
    extends MDocumentAdapter<JTextComponent> {
        private final WeakReference<Modifiable> modifiableRef;

        @Override
        protected void onChange(DocumentEvent documentEvent) {
            Modifiable modifiable = (Modifiable)this.modifiableRef.get();
            if (modifiable != null) {
                modifiable.setModified(true, documentEvent);
            }
        }

        public StaticModifiableDocumentHandler(Modifiable modifiable) {
            this.modifiableRef = new WeakReference<Modifiable>(modifiable);
        }
    }

    private static abstract class StaticAction
    extends MDataAction.Weak<JTextComponent> {
        protected StaticAction(JTextComponent jTextComponent, MActionInfo mActionInfo) {
            super(jTextComponent, mActionInfo);
        }

        protected StaticAction(JTextComponent jTextComponent, String string) {
            super(jTextComponent, string);
        }

        protected JTextComponent getTextComponent() {
            return (JTextComponent)this.get();
        }
    }

    private static final class MaximumLengthDocumentFilter
    extends DocumentFilter {
        private final int maximumLength;

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (filterBypass.getDocument().getLength() + string.length() <= this.maximumLength) {
                super.insertString(filterBypass, n, string, attributeSet);
            } else {
                TK.beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (filterBypass.getDocument().getLength() + (string == null ? 0 : string.length()) - n2 <= this.maximumLength) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            } else {
                TK.beep();
            }
        }

        private MaximumLengthDocumentFilter(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.maximumLength = n;
        }
    }

    private static final class InsertSymbolAction
    extends InsertAction {
        private final String symbol;

        @Override
        public void onAction() {
            this.insertText(this.symbol);
        }

        private InsertSymbolAction(JTextComponent jTextComponent, char c, String string) {
            super(jTextComponent);
            this.symbol = Character.toString(c);
            this.setHTMLHelp(UI._("Insert: {0}", string));
            this.setName(this.symbol);
        }
    }

    private static final class InsertDateAction
    extends InsertAction {
        private int dateStyle;
        private int timeStyle;
        private String format;

        public InsertDateAction(JTextComponent jTextComponent, int n, int n2) {
            super(jTextComponent);
            this.dateStyle = n;
            this.timeStyle = n2;
            this.setHTMLHelp(UI._("Insert Date/Time"));
            this.setName(this.format());
        }

        public InsertDateAction(JTextComponent jTextComponent, String string) {
            super(jTextComponent);
            this.format = string;
            this.setHTMLHelp(UI._("Insert Date/Time"));
            this.setName(this.format());
        }

        @Override
        public void onAction() {
            this.insertText(this.format());
        }

        private String format() {
            MDate mDate = MDate.now();
            if (this.format != null) {
                return mDate.format(this.format);
            }
            if (this.dateStyle != -1 && this.timeStyle != -1) {
                return mDate.formatDateTime(this.dateStyle, this.timeStyle);
            }
            if (this.dateStyle != -1) {
                return mDate.formatDate(this.dateStyle);
            }
            return mDate.formatTime(this.timeStyle);
        }
    }

    private static abstract class InsertAction
    extends StaticAction {
        protected InsertAction(JTextComponent jTextComponent) {
            super(jTextComponent, (String)null);
        }

        protected void insertText(String string) {
            JTextComponent jTextComponent = this.getTextComponent();
            if (jTextComponent != null) {
                MText.insertString(jTextComponent, string);
            }
        }
    }

    private static final class InputMethodAction
    extends StaticAction {
        @Override
        public void onAction() {
            JTextComponent jTextComponent = this.getTextComponent();
            if (jTextComponent == null) {
                return;
            }
            InputContext inputContext = jTextComponent.getInputContext();
            if (inputContext != null) {
                try {
                    int n = 0;
                    for (InputMethodDescriptor object : ServiceLoader.loadInstalled(InputMethodDescriptor.class)) {
                        ++n;
                    }
                    if (n == 0) {
                        MStatusBar.info(UI._("No input method installed"));
                        return;
                    }
                    try {
                        Class<?> clazz = Class.forName("sun.awt.im.InputMethodManager");
                        Method method = clazz.getMethod("getInstance", new Class[0]);
                        Object object = method.invoke(null, new Object[0]);
                        Method method2 = clazz.getMethod("notifyChangeRequestByHotKey", Component.class);
                        method2.invoke(object, jTextComponent);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        MMessage.error(null, throwable);
                    }
                }
                catch (Exception exception) {
                    MMessage.error(null, exception);
                }
            }
        }

        private InputMethodAction(JTextComponent jTextComponent) {
            super(jTextComponent, UI._("Select Input Method..."));
        }
    }

    private static final class Handler
    extends MMouseAdapter
    implements CaretListener,
    KeyListener {
        private Handler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            MText.setCursorVisible(jTextComponent, true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            MText.setCursorVisible(jTextComponent, true);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            MText.setCursorVisible(jTextComponent, true);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            MText.setCursorVisible(jTextComponent, true);
        }

        @Override
        public void popupTrigger(MouseEvent mouseEvent) {
            if (((Boolean)UI.mouseGestures.get()).booleanValue() && mouseEvent.isConsumed()) {
                return;
            }
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            MMenu mMenu = MText.createMenu(jTextComponent);
            if (!mMenu.isEmpty()) {
                mMenu.showPopup(mouseEvent);
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            JTextComponent jTextComponent = (JTextComponent)caretEvent.getSource();
            MText.updateSelectionActions(jTextComponent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JTextComponent jTextComponent;
            MMenu mMenu;
            if (UI.isPopupTrigger(keyEvent) && !(mMenu = MText.createMenu(jTextComponent = (JTextComponent)keyEvent.getSource())).isEmpty()) {
                mMenu.showPopup(jTextComponent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
            MText.setCursorVisible(jTextComponent, false);
        }
    }

    private static final class AutoHideTimer
    extends MTimer {
        private final WeakReference<JTextComponent> textComponentRef;

        @Override
        protected boolean onTimeout() {
            JTextComponent jTextComponent = (JTextComponent)this.textComponentRef.get();
            if (jTextComponent != null) {
                jTextComponent.setCursor(UI.getInvisibleCursor());
            }
            return false;
        }

        private AutoHideTimer(JTextComponent jTextComponent) {
            super(1000);
            this.textComponentRef = new WeakReference<JTextComponent>(jTextComponent);
        }
    }

    public static interface UserMenu<T extends JTextComponent> {
        public void onUserMenu(T var1, MMenu var2);
    }

    public static interface TextFieldExtensions
    extends CommonExtensions {
        public void makeDefault();

        public AutoCompletion getAutoCompletion();

        public void saveAutoCompletion();

        public void setAutoCompletion(String var1);

        public String getText();

        public void setText(String var1);

        public void setEnterPressAction(Action var1);
    }

    public static interface SpellChecker {
        public static final String INTERACTIVE_PROPERTY = "interactive";
        public static final String LOCALE_PROPERTY = "locale";

        public void addToPersonal(String var1);

        public void addToSession(String var1);

        public void check(JTextComponent var1);

        public Object getProperty(String var1);

        public void setProperty(String var1, Object var2);

        public void install(JTextComponent var1);

        public void uninstall(JTextComponent var1);

        public boolean isCorrect(String var1);

        public List<String> suggest(String var1);

        public void storeReplacement(String var1, String var2);
    }

    public static interface Modifiable {
        public boolean isModified();

        public void setModified(boolean var1, Object var2);
    }

    public static interface GlobalMenu {
        public void onGlobalMenu(JTextComponent var1, MMenu var2);
    }

    public static interface CommonExtensions {
        public void clear();

        public boolean isEmpty();
    }
}

