/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.ConstructorProperties;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MText;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.style.StyleSupport;

public class MTextField
extends JTextField
implements MText.TextFieldExtensions,
StyleSupport {
    private String promptText;

    public MTextField() {
        this(null);
    }

    public MTextField(int n) {
        super(n);
        this.init();
    }

    @ConstructorProperties(value={"text"})
    public MTextField(String string) {
        super(string);
        this.init();
    }

    public Action getEnterPressAction() {
        return MText.getEnterPressAction(this);
    }

    @Override
    public void setEnterPressAction(Action action) {
        MText.setEnterPressAction(this, action);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    public String getPromptText() {
        return this.promptText;
    }

    public void setPromptText(String string) {
        if (TK.isChange(this.promptText, string)) {
            this.promptText = string;
            this.repaint();
        }
        if (this.getToolTipText() == null) {
            this.setToolTipText(string);
        }
    }

    @Override
    public void clear() {
        this.setText(null);
    }

    @Override
    public boolean isEmpty() {
        return this.getDocument().getLength() == 0;
    }

    @Override
    public void makeDefault() {
        MText.makeDefault(this);
    }

    @Override
    public AutoCompletion getAutoCompletion() {
        return MText.getAutoCompletion(this);
    }

    @Override
    public void saveAutoCompletion() {
        MText.saveAutoCompletion(this);
    }

    @Override
    public void setAutoCompletion(String string) {
        MText.installAutoCompletion(this, string);
    }

    @Override
    public void setStyle(String string) {
        UI.setStyle(string, this);
    }

    protected void onChange(DocumentEvent documentEvent) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (UI.isSeaGlass() && this.getClientProperty("JTextField.Search.PlaceholderText") != null) {
            return;
        }
        if (TK.isEmpty(this.getPromptText()) || !this.isEmpty()) {
            return;
        }
        Color color = UI.getForeground(this);
        boolean bl = this.isFocusOwner();
        color = UI.getBrighter(color, bl ? 65 : 55, Color.BLACK);
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = UI.createInsets(0);
        }
        int n = this.getHeight() - (insets.top + insets.bottom);
        graphics.setColor(color);
        Font font = UI.getFont(this);
        graphics.setFont(font.deriveFont(bl ? 2 : 1));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = insets.left;
        int n3 = insets.top + n / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent();
        UI.setTextAntialiasing((Graphics2D)graphics, null);
        graphics.drawString(this.promptText, n2, n3);
    }

    private void init() {
        MText.commonSetup(this);
        StaticHandler staticHandler = new StaticHandler(this);
        this.addFocusListener(staticHandler);
        this.getDocument().addDocumentListener(staticHandler);
    }

    boolean isPromptTextVisible() {
        return !TK.isEmpty(this.getPromptText()) && this.isEmpty() && !this.isFocusOwner();
    }

    private static final class StaticHandler
    extends MDocumentAdapter<MTextField>
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            MTextField mTextField = (MTextField)focusEvent.getSource();
            if (!TK.isEmpty(mTextField.getPromptText())) {
                mTextField.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            MTextField mTextField = (MTextField)focusEvent.getSource();
            if (!TK.isEmpty(mTextField.getPromptText())) {
                mTextField.repaint();
            }
        }

        @Override
        protected void onChange(DocumentEvent documentEvent) {
            MTextField mTextField = (MTextField)this.getTextComponent();
            if (mTextField != null) {
                mTextField.onChange(documentEvent);
            }
        }

        private StaticHandler(MTextField mTextField) {
            super(mTextField);
        }
    }
}

