/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.commons.autocompletion.AutoCompletion;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.Painter;

public class MTextFieldPanel
extends MPanel
implements MText.TextFieldExtensions {
    private boolean limitWidth;
    private DocumentEvent lastDocumentEvent;
    private int changeEventDelay;
    private MLabel label;
    private MPanel buttonPanel;
    private MSmallButton clearButton;
    private MSmallButton menuButton;
    private MTextField textField;
    private MTimer changeEventDelayTimer;
    private State state = State.NORMAL;

    public MTextFieldPanel() {
        this((String)null, false);
    }

    public MTextFieldPanel(boolean bl) {
        this((String)null, bl);
    }

    public MTextFieldPanel(String string) {
        this(string, false);
    }

    public MTextFieldPanel(String string, boolean bl) {
        this.limitWidth = bl;
        this.setMargin(1);
        this.setOpaque(false);
        this.buttonPanel = MPanel.createHBoxPanel();
        this.buttonPanel.setOpaque(false);
        this.addEast(this.buttonPanel);
        this.clearButton = new MSmallButton(MActionInfo.CLEAR_LEFT){

            @Override
            protected void onClick() {
                MTextFieldPanel.this.textField.clear();
                MTextFieldPanel.this.textField.makeDefault();
            }
        };
        this.buttonPanel.add(this.clearButton);
        this.textField = new MTextField(string){

            @Override
            public void setPromptText(String string) {
                super.setPromptText(string);
                if (UI.isSeaGlass()) {
                    this.putClientProperty("JTextField.Search.PlaceholderText", string);
                }
            }

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                if (MTextFieldPanel.this.changeEventDelay == 0) {
                    MTextFieldPanel.this.onChange(documentEvent);
                    MTextFieldPanel.this.updateClearButton();
                } else {
                    MTextFieldPanel.this.lastDocumentEvent = documentEvent;
                    MTextFieldPanel.this.changeEventDelayTimer.restart();
                }
            }
        };
        this.updateClearButton();
        this.textField.setCaretPosition(0);
        this.addCenter(this.textField);
        this.menuButton = new MSmallButton(MIcon.small("ui/plus"), null){

            @Override
            protected MMenu onPopupMenu() {
                return MTextFieldPanel.this.onPopupMenu();
            }
        };
        this.menuButton.setPopupMenuArrowPainted(false);
        this.menuButton.setPopupMenuEnabled(true);
        this.buttonPanel.add(this.menuButton);
        this.setPainter(new GlassPainter());
    }

    public MPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public int getChangeEventDelay() {
        return this.changeEventDelay;
    }

    public void setChangeEventDelay(int n) {
        if (n == this.changeEventDelay) {
            return;
        }
        this.changeEventDelay = n;
        if (this.changeEventDelay == 0) {
            this.lastDocumentEvent = null;
            if (this.changeEventDelayTimer != null) {
                this.changeEventDelayTimer.stop();
                this.changeEventDelayTimer = null;
            }
        } else {
            if (this.changeEventDelayTimer == null) {
                this.changeEventDelayTimer = new MTimer(this.changeEventDelay){

                    @Override
                    protected boolean onTimeout() {
                        if (MTextFieldPanel.this.lastDocumentEvent != null) {
                            MTextFieldPanel.this.onChange(MTextFieldPanel.this.lastDocumentEvent);
                            MTextFieldPanel.this.updateClearButton();
                            MTextFieldPanel.this.lastDocumentEvent = null;
                        }
                        return false;
                    }
                };
            }
            this.changeEventDelayTimer.setDelay(MTimer.Format.MS, this.changeEventDelay);
            this.changeEventDelayTimer.restart();
        }
    }

    public MTimer getChangeEventDelayTimer() {
        return this.changeEventDelayTimer;
    }

    public MLabel getLabelComponent() {
        return this.label;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.limitWidth ? this.getPreferredSize() : super.getMaximumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return this.limitWidth ? new Dimension(200, dimension.height) : dimension;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (this.state != state) {
            this.state = state;
            Painter painter = this.getPainter();
            if (painter instanceof GlassPainter) {
                Color color;
                switch (this.state) {
                    case NORMAL: {
                        color = null;
                        break;
                    }
                    case OK: {
                        color = MHighlighter.OK_COLOR;
                        break;
                    }
                    case WARNING: {
                        color = MHighlighter.WARNING_COLOR;
                        break;
                    }
                    case ERROR: {
                        color = MHighlighter.ERROR_COLOR;
                        break;
                    }
                    default: {
                        throw new WTFError(state);
                    }
                }
                ((GlassPainter)GlassPainter.class.cast(painter)).setPrimaryColor(color);
                this.repaint();
            }
        }
    }

    @Override
    public String getText() {
        return this.textField.getText();
    }

    @Override
    public void setText(String string) {
        MText.setText(this.textField, string);
    }

    public MSmallButton getClearButton() {
        return this.clearButton;
    }

    public String getHintText() {
        return this.textField.getPromptText();
    }

    public void setHintText(String string) {
        this.textField.setPromptText(string);
    }

    public MSmallButton getMenuButton() {
        return this.menuButton;
    }

    public MTextField getTextField() {
        return this.textField;
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void setEditable(boolean bl) {
        if (this.isEditable() == bl) {
            return;
        }
        this.textField.setEditable(bl);
        if (this.clearButton != null) {
            this.clearButton.setEnabled(bl);
            this.clearButton.setVisible(bl);
        }
        if (this.menuButton != null) {
            this.menuButton.setEnabled(bl);
        }
        this.updateClearButton();
    }

    @Deprecated
    public boolean isHintTextVisible() {
        return this.textField.isPromptTextVisible();
    }

    @Deprecated
    public void setHintTextVisible(boolean bl) {
    }

    @Override
    public void setEnterPressAction(Action action) {
        this.textField.setEnterPressAction(action);
    }

    public void setLabel(String string) {
        if (this.label == null) {
            this.label = MLabel.createFor(this.textField, string);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.addWest(this.label);
        }
        this.label.setText(string);
    }

    @Override
    public void clear() {
        this.textField.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.textField.isEmpty();
    }

    @Override
    public void makeDefault() {
        this.textField.makeDefault();
    }

    @Override
    public AutoCompletion getAutoCompletion() {
        return MText.getAutoCompletion(this.textField);
    }

    @Override
    public void saveAutoCompletion() {
        MText.saveAutoCompletion(this.textField);
    }

    @Override
    public void setAutoCompletion(String string) {
        MText.installAutoCompletion(this.textField, string);
    }

    protected void onChange(DocumentEvent documentEvent) {
    }

    protected MMenu onPopupMenu() {
        return null;
    }

    protected void updateClearButton(boolean bl) {
        this.clearButton.setEnabled(bl);
        this.clearButton.setVisible(bl);
    }

    private void updateClearButton() {
        if (this.clearButton != null) {
            boolean bl = this.textField.isEditable() && !this.isEmpty();
            this.updateClearButton(bl);
        }
    }

    public static enum State {
        NORMAL,
        OK,
        WARNING,
        ERROR;

    }
}

