/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;

public class MUndoManager
extends UndoManager {
    public static final UndoableEditListener[] EMPTY_UNDOABLE_EDIT_LISTENER_ARRAY = new UndoableEditListener[0];
    public static final int NO_LIMIT = -1;
    private MAction redoAction;
    private MAction undoAction;
    WeakReference<JComponent> owner;

    public MUndoManager() {
        this(128);
    }

    public MUndoManager(int n) {
        this(null, n);
    }

    public MUndoManager(JComponent jComponent) {
        this(jComponent, 128);
    }

    public MUndoManager(JComponent jComponent, int n) {
        this.setOwner(jComponent);
        this.setLimit(n);
        this.undoAction = new StaticUndoAction(this);
        this.redoAction = new StaticRedoAction(this);
    }

    public UndoableEditListener createUndoableEditListener() {
        return new StaticUndoableEditListener(this);
    }

    public MAction getRedoAction() {
        return this.redoAction;
    }

    public MAction getUndoAction() {
        return this.undoAction;
    }

    public void setOwner(JComponent jComponent) {
        this.owner = jComponent == null ? null : new WeakReference<JComponent>(jComponent);
    }

    public void updateMenu(MMenu mMenu) {
        mMenu.add(this.getUndoAction());
        mMenu.add(this.getRedoAction());
    }

    public void updateToolBar(MToolBar mToolBar) {
        mToolBar.add(this.getUndoAction(), 1);
        mToolBar.add(this.getRedoAction());
    }

    public void updateUndoRedoActions(boolean bl) {
        this.undoAction.setEnabled(bl && this.canUndo());
        this.redoAction.setEnabled(bl && this.canRedo());
    }

    public void updateUserActions() {
        this.updateUndoRedoActions(true);
    }

    protected JComponent getOwner() {
        return TK.get(this.owner);
    }

    protected boolean isValidEvent(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            boolean bl;
            JComponent jComponent = this.getOwner();
            boolean bl2 = bl = (actionEvent.getModifiers() & (MAction.getMenuMask() | 1)) != 0;
            if (jComponent != null && !jComponent.isFocusOwner() && bl) {
                TK.beep();
                return false;
            }
        }
        return true;
    }

    private TriBoolean setAutoCompletionEnabled(ActionEvent actionEvent, boolean bl) {
        AutoCompletion autoCompletion;
        if (!(actionEvent.getSource() instanceof JMenuItem)) {
            return TriBoolean.UNDEFINED;
        }
        JComponent jComponent = this.getOwner();
        if (jComponent instanceof JTextComponent && (autoCompletion = MText.getAutoCompletion((JTextComponent)jComponent)) != null) {
            boolean bl2 = (Boolean)autoCompletion.enabled.get();
            autoCompletion.enabled.set(bl);
            return TriBoolean.from(bl2);
        }
        return TriBoolean.UNDEFINED;
    }

    private static final class StaticUndoAction
    extends MDataAction.Weak<MUndoManager> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAction() {
            MUndoManager mUndoManager = (MUndoManager)this.get();
            if (mUndoManager == null) {
                return;
            }
            if (!mUndoManager.isValidEvent(this.getActionEvent())) {
                return;
            }
            TriBoolean triBoolean = mUndoManager.setAutoCompletionEnabled(this.getActionEvent(), false);
            try {
                mUndoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
            }
            finally {
                if (triBoolean.isDefined()) {
                    mUndoManager.setAutoCompletionEnabled(this.getActionEvent(), triBoolean.isTrue());
                }
                mUndoManager.updateUserActions();
            }
        }

        private StaticUndoAction(MUndoManager mUndoManager) {
            super(mUndoManager, UI._("Undo"), "ui/undo");
            this.setAcceleratorKey(90, StaticUndoAction.getMenuMask());
            this.setHTMLHelp(UI._("Undoes the last operation."));
        }
    }

    private static final class StaticUndoableEditListener
    implements UndoableEditListener {
        private WeakReference<MUndoManager> ref;

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            MUndoManager mUndoManager = (MUndoManager)this.ref.get();
            if (mUndoManager != null) {
                mUndoManager.addEdit(undoableEditEvent.getEdit());
                mUndoManager.updateUserActions();
            }
        }

        private StaticUndoableEditListener(MUndoManager mUndoManager) {
            this.ref = new WeakReference<MUndoManager>(mUndoManager);
        }
    }

    private static final class StaticRedoAction
    extends MDataAction.Weak<MUndoManager> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAction() {
            MUndoManager mUndoManager = (MUndoManager)this.get();
            if (mUndoManager == null) {
                return;
            }
            if (!mUndoManager.isValidEvent(this.getActionEvent())) {
                return;
            }
            TriBoolean triBoolean = mUndoManager.setAutoCompletionEnabled(this.getActionEvent(), false);
            try {
                mUndoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                MLogger.exception(cannotRedoException);
            }
            finally {
                if (triBoolean.isDefined()) {
                    mUndoManager.setAutoCompletionEnabled(this.getActionEvent(), triBoolean.isTrue());
                }
                mUndoManager.updateUserActions();
            }
        }

        private StaticRedoAction(MUndoManager mUndoManager) {
            super(mUndoManager, UI._("Redo"), "ui/redo");
            this.setAcceleratorKey(StaticRedoAction.getRedoKeyStroke());
            this.setAlternateAcceleratorKey(89, StaticRedoAction.getMenuMask());
            this.setHTMLHelp(UI._("Redoes the last operation."));
        }
    }
}

