/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.BasicPermission;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Flags;
import org.makagiga.commons.HTMLViewFactory;
import org.makagiga.commons.HistoryManager;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MText;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WebBrowser;
import org.makagiga.commons.mods.Mods;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.commons.print.TextPrintInfo;

public class MWebBrowserPanel
extends MPanel
implements MDisposable,
WebBrowser {
    public static final String DEFAULT_CLASS_NAME;
    private final ActionGroup actionGroup;
    private boolean synchronousImageLoading;
    private static boolean useInternalBrowser;
    private static BrowserLauncher browserLauncher;
    private static ClassLoader webBrowserClassLoader;
    private final History history = new History();
    private HTMLViewFactory.ImageDownloader imageDownloader;
    private HTMLViewFactory.ImageFactory imageFactory;
    private static String webBrowserClassName;
    private final WeakReference<MHTMLViewer> viewerRef;

    public MWebBrowserPanel() {
        this.initImageDownloader();
        StaticHTMLViewer staticHTMLViewer = new StaticHTMLViewer(this);
        this.addCenter(staticHTMLViewer, 2);
        this.viewerRef = new WeakReference<StaticHTMLViewer>(staticHTMLViewer);
        this.actionGroup = MWebBrowserPanel.createDefaultActionGroup(this);
        this.actionGroup.add("copy", MText.getAction(staticHTMLViewer, "org.makagiga.commons.MText.copy")).setShowTextInToolBar(true);
    }

    public static ActionGroup createDefaultActionGroup(WebBrowser webBrowser) {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add("back", new BackAction(webBrowser)).setShowTextInToolBar(true);
        actionGroup.add("forward", new ForwardAction(webBrowser));
        actionGroup.add("stop", new StopAction(webBrowser));
        return actionGroup;
    }

    public static synchronized WebBrowser createDefaultWebBrowser() {
        MWebBrowserPanel.checkPermission("createDefaultWebBrowser");
        try {
            if (webBrowserClassLoader == null) {
                return (WebBrowser)TK.newInstance(webBrowserClassName);
            }
            return (WebBrowser)TK.newInstance(webBrowserClassName, webBrowserClassLoader);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            MLogger.exception(throwable);
            if (DEFAULT_CLASS_NAME.equals(webBrowserClassName)) {
                return null;
            }
            webBrowserClassName = DEFAULT_CLASS_NAME;
            try {
                return (WebBrowser)TK.newInstance(webBrowserClassName);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable2) {
                MLogger.exception(throwable2);
                return null;
            }
        }
    }

    public static synchronized BrowserLauncher getBrowserLauncher() {
        MWebBrowserPanel.checkPermission("getBrowserLauncher");
        if (browserLauncher == null) {
            browserLauncher = new BrowserLauncher(){

                @Override
                public void openURL(URL uRL) {
                    if (!Boolean.TRUE.equals(Mods.exec(null, "handleURL@org.makagiga.commons.WebBrowser", uRL))) {
                        MMainWindow.openURI(uRL);
                    }
                }
            };
        }
        return browserLauncher;
    }

    @Deprecated
    public static synchronized void setBrowserLauncher(BrowserLauncher browserLauncher) {
        MWebBrowserPanel.checkPermission("setBrowserLauncher");
        MWebBrowserPanel.browserLauncher = browserLauncher;
    }

    public static synchronized String getDefaultWebBrowser() {
        MWebBrowserPanel.checkPermission("getDefaultWebBrowser");
        return webBrowserClassName;
    }

    public static synchronized void setDefaultWebBrowser(String string) {
        MLogger.debug("browser", "Setting default web browser to \"%s\"...", string);
        MWebBrowserPanel.checkPermission("setDefaultWebBrowser");
        webBrowserClassLoader = null;
        webBrowserClassName = string;
    }

    public static synchronized void setDefaultWebBrowser(String string, ClassLoader classLoader) {
        MLogger.debug("browser", "Setting default web browser to \"%s\"...", string);
        MWebBrowserPanel.checkPermission("setDefaultWebBrowser");
        webBrowserClassLoader = classLoader;
        webBrowserClassName = string;
    }

    public static synchronized boolean getUseInternalBrowser() {
        return useInternalBrowser;
    }

    public static synchronized void setUseInternalBrowser(boolean bl) {
        MWebBrowserPanel.checkPermission("setUseInternalBrowser");
        useInternalBrowser = bl;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopThreads();
    }

    @Override
    public final Object dispose(Object ... objectArray) {
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        if (mHTMLViewer != null) {
            MText.deinstallKit(mHTMLViewer);
        }
        if (this.imageDownloader != null) {
            this.imageDownloader.setImageFactory(null);
        }
        this.imageFactory = null;
        return null;
    }

    @Override
    public void addLinkListener(WebBrowser.LinkListener linkListener) {
        this.listenerList.add(WebBrowser.LinkListener.class, linkListener);
    }

    @Override
    public WebBrowser.LinkListener[] getLinkListeners() {
        return (WebBrowser.LinkListener[])this.listenerList.getListeners(WebBrowser.LinkListener.class);
    }

    @Override
    public void removeLinkListener(WebBrowser.LinkListener linkListener) {
        this.listenerList.remove(WebBrowser.LinkListener.class, linkListener);
    }

    @Override
    public synchronized void back(int n) {
        if (this.history.back()) {
            this.openURL(this.history.getCurrentURL(), false);
        }
    }

    @Override
    public synchronized void blank(int n) {
        this.stop(n);
        ((MHTMLViewer)this.viewerRef.get()).clear();
    }

    @Override
    public synchronized void forward(int n) {
        if (this.history.forward()) {
            this.openURL(this.history.getCurrentURL(), false);
        }
    }

    @Override
    public synchronized Printable getPrintable(MessageFormat messageFormat, MessageFormat messageFormat2, int n) {
        return ((MHTMLViewer)this.viewerRef.get()).getPrintable(messageFormat, messageFormat2);
    }

    @Override
    public synchronized <T> T getProperty(String string) {
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        if ("org.makagiga.commons.WebBrowser.ACTION_GROUP_PROPERTY".equals(string)) {
            return (T)this.actionGroup;
        }
        if ("org.makagiga.commons.WebBrowser.BASE_PROPERTY".equals(string)) {
            Document document = mHTMLViewer.getDocument();
            if (document instanceof HTMLDocument) {
                return (T)((HTMLDocument)HTMLDocument.class.cast(document)).getBase();
            }
            return null;
        }
        if ("org.makagiga.commons.WebBrowser.CONTAINER_PROPERTY".equals(string)) {
            return (T)this;
        }
        if ("org.makagiga.commons.WebBrowser.EDIT_MENU_PROPERTY".equals(string)) {
            return (T)MText.createMenu(mHTMLViewer);
        }
        if ("org.makagiga.commons.WebBrowser.FONT_SIZE_PROPERTY".equals(string)) {
            return (T)Integer.valueOf(mHTMLViewer.getFont().getSize());
        }
        if ("org.makagiga.commons.WebBrowser.HISTORY_MANAGER".equals(string)) {
            return (T)this.history.historyManager;
        }
        if ("org.makagiga.commons.WebBrowser.HONOR_DISPLAY_PROPERTIES_PROPERTY".equals(string)) {
            return (T)Boolean.valueOf(mHTMLViewer.getHonorDisplayProperties());
        }
        if ("org.makagiga.commons.WebBrowser.IMAGE_FACTORY_PROPERTY".equals(string)) {
            return (T)this.imageFactory;
        }
        if ("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY".equals(string)) {
            return (T)mHTMLViewer;
        }
        if ("org.makagiga.commons.WebBrowser.SELECTED_TEXT_PROPERTY".equals(string)) {
            return (T)mHTMLViewer.getSelectedText();
        }
        if ("org.makagiga.commons.WebBrowser.SYNCHRONOUS_IMAGE_LOADING_PROPERTY".equals(string)) {
            return (T)Boolean.valueOf(this.synchronousImageLoading);
        }
        if ("org.makagiga.commons.WebBrowser.TEXT_HTML_CONTENT_PROPERTY".equals(string)) {
            return (T)mHTMLViewer.getText();
        }
        if ("org.makagiga.commons.WebBrowser.TEXT_PLAIN_CONTENT_PROPERTY".equals(string)) {
            return (T)MText.getPlainText(mHTMLViewer);
        }
        if ("org.makagiga.commons.WebBrowser.TITLE_PROPERTY".equals(string)) {
            return (T)mHTMLViewer.getTitle();
        }
        if ("org.makagiga.commons.WebBrowser.URL_PROPERTY".equals(string)) {
            return (T)mHTMLViewer.getPage();
        }
        return null;
    }

    @Override
    public synchronized void setProperty(String string, Object object) {
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        if ("org.makagiga.commons.WebBrowser.BASE_PROPERTY".equals(string)) {
            Document document = mHTMLViewer.getDocument();
            if (document instanceof HTMLDocument) {
                ((HTMLDocument)HTMLDocument.class.cast(document)).setBase((URL)object);
            }
        } else if ("org.makagiga.commons.WebBrowser.FONT_SIZE_PROPERTY".equals(string)) {
            mHTMLViewer.setStyle("font-size: " + object);
        } else if ("org.makagiga.commons.WebBrowser.HONOR_DISPLAY_PROPERTIES_PROPERTY".equals(string)) {
            mHTMLViewer.setHonorDisplayProperties((Boolean)object);
        } else if ("org.makagiga.commons.WebBrowser.IMAGE_FACTORY_PROPERTY".equals(string)) {
            this.imageFactory = (HTMLViewFactory.ImageFactory)object;
        } else if ("org.makagiga.commons.WebBrowser.SYNCHRONOUS_IMAGE_LOADING_PROPERTY".equals(string)) {
            this.synchronousImageLoading = (Boolean)object;
        }
    }

    @Override
    public synchronized boolean printDocument(MessageFormat messageFormat, MessageFormat messageFormat2, int n) throws PrinterException {
        PrintInfo.PrintResult printResult = TextPrintInfo.printDocument((JTextComponent)this.viewerRef.get(), new Flags(n), messageFormat, messageFormat2, (String)this.getProperty("org.makagiga.commons.WebBrowser.TITLE_PROPERTY"));
        return printResult == PrintInfo.PrintResult.COMPLETE;
    }

    @Override
    public synchronized void reload(int n) {
    }

    @Override
    public void setDocument(InputStream inputStream, String string) {
    }

    @Override
    public synchronized void setDocument(String string) {
        this.openURL(string, true);
    }

    @Override
    public synchronized void setDocument(URL uRL) {
        this.openURL(uRL.toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setDocumentFromString(String string, String string2) {
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        try {
            if (TK.isEmpty(string2)) {
                this.setProperty("org.makagiga.commons.WebBrowser.BASE_PROPERTY", null);
            } else {
                this.setProperty("org.makagiga.commons.WebBrowser.BASE_PROPERTY", new URL(string2));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.setProperty("org.makagiga.commons.WebBrowser.BASE_PROPERTY", null);
        }
        this.startLoading(null);
        try {
            mHTMLViewer.setHTML(string);
        }
        finally {
            this.stopLoading();
        }
        MScrollPane.scrollToTop(mHTMLViewer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int n) {
        this.stopThreads();
        MWebBrowserPanel mWebBrowserPanel = this;
        synchronized (mWebBrowserPanel) {
            MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
            if (mHTMLViewer != null) {
                mHTMLViewer.clearStreamDescription();
                mHTMLViewer.setEditorKit(new StaticHTMLEditorKit(this));
            }
        }
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission(string));
        }
    }

    private void initImageDownloader() {
        this.imageDownloader = new HTMLViewFactory.ImageDownloader(3);
        this.imageDownloader.setImageFactory(this.imageFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openURL(String string, boolean bl) {
        this.setProperty("org.makagiga.commons.WebBrowser.BASE_PROPERTY", null);
        if (bl) {
            this.history.addURL(string);
        }
        this.startLoading(string);
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        try {
            mHTMLViewer.setPage(string);
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
            String string2 = String.format("<h1>%s</h1><p>%s</p><p><code>%s</code></p><h2>%s</h2><p>%s</p>", UI._("Error"), UI._("Could not load page"), string, UI._("Details"), iOException);
            string2 = "<div style=\"margin: 10px\">" + string2 + "</div>";
            mHTMLViewer.setHTML(string2);
        }
        finally {
            this.stopLoading();
        }
    }

    private void startLoading(String string) {
        this.stop(0);
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        UI.setWaitCursor(mHTMLViewer, true);
        if (string != null) {
            MStatusBar.message(UI._("Opening \"{0}\"...", string));
        }
        this.actionGroup.setEnabled("stop", true);
    }

    private void stopLoading() {
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        if (mHTMLViewer != null) {
            UI.setWaitCursor(mHTMLViewer, false);
        }
        MStatusBar.ready();
        this.actionGroup.setEnabled("back", this.history.canBack());
        this.actionGroup.setEnabled("forward", this.history.historyManager.canForward());
        this.actionGroup.setEnabled("stop", false);
    }

    private synchronized void stopThreads() {
        this.imageDownloader.cancelAll();
        this.initImageDownloader();
        MHTMLViewer mHTMLViewer = (MHTMLViewer)this.viewerRef.get();
        if (mHTMLViewer != null) {
            mHTMLViewer.clearStreamDescription();
        }
    }

    static {
        webBrowserClassName = DEFAULT_CLASS_NAME = MWebBrowserPanel.class.getName();
    }

    private static final class StopAction
    extends MDataAction.Weak<WebBrowser> {
        @Override
        public void onAction() {
            this.setEnabled(false);
            ((WebBrowser)this.get()).stop(0);
        }

        private StopAction(WebBrowser webBrowser) {
            super(webBrowser, UI._("Stop"), "ui/stop");
            this.setEnabled(false);
        }
    }

    private static final class StaticHTMLViewer
    extends MHTMLViewer {
        private final WeakReference<MWebBrowserPanel> webBrowserPanelRef;

        @Override
        protected boolean onHyperlinkClick(HyperlinkEvent hyperlinkEvent) {
            MWebBrowserPanel mWebBrowserPanel = (MWebBrowserPanel)this.webBrowserPanelRef.get();
            if (mWebBrowserPanel == null) {
                return super.onHyperlinkClick(hyperlinkEvent);
            }
            for (WebBrowser.LinkListener linkListener : (WebBrowser.LinkListener[])mWebBrowserPanel.listenerList.getListeners(WebBrowser.LinkListener.class)) {
                if (!linkListener.linkEvent(hyperlinkEvent)) continue;
                return true;
            }
            return false;
        }

        private StaticHTMLViewer(MWebBrowserPanel mWebBrowserPanel) {
            this.webBrowserPanelRef = new WeakReference<MWebBrowserPanel>(mWebBrowserPanel);
            this.setSecureOpen(true);
            this.setStyle("padding: 0");
        }
    }

    private static final class StaticHTMLEditorKit
    extends HTMLEditorKit {
        private final WeakReference<MWebBrowserPanel> webBrowserPanelRef;

        @Override
        public ViewFactory getViewFactory() {
            MWebBrowserPanel mWebBrowserPanel = (MWebBrowserPanel)this.webBrowserPanelRef.get();
            if (mWebBrowserPanel == null) {
                return super.getViewFactory();
            }
            return new BrowserViewFactory(mWebBrowserPanel, super.getViewFactory(), mWebBrowserPanel.imageDownloader);
        }

        private StaticHTMLEditorKit(MWebBrowserPanel mWebBrowserPanel) {
            this.webBrowserPanelRef = new WeakReference<MWebBrowserPanel>(mWebBrowserPanel);
        }
    }

    private static final class ForwardAction
    extends MDataAction.Weak<WebBrowser> {
        @Override
        public void onAction() {
            ((WebBrowser)this.get()).forward(0);
        }

        private ForwardAction(WebBrowser webBrowser) {
            super(webBrowser, MActionInfo.FORWARD);
            this.setEnabled(false);
        }
    }

    private static final class BrowserViewFactory
    extends HTMLViewFactory {
        private final WeakReference<MWebBrowserPanel> webBrowserPanelRef;

        @Override
        @Deprecated
        public boolean getHandleMakagigaIconProtocol() {
            return super.getHandleMakagigaIconProtocol();
        }

        @Override
        public boolean getLoadsSynchronously() {
            MWebBrowserPanel mWebBrowserPanel = (MWebBrowserPanel)this.webBrowserPanelRef.get();
            return mWebBrowserPanel == null ? super.getLoadsSynchronously() : mWebBrowserPanel.synchronousImageLoading;
        }

        private BrowserViewFactory(MWebBrowserPanel mWebBrowserPanel, ViewFactory viewFactory, HTMLViewFactory.ImageDownloader imageDownloader) {
            super(viewFactory, imageDownloader);
            this.webBrowserPanelRef = new WeakReference<MWebBrowserPanel>(mWebBrowserPanel);
        }
    }

    private static final class BackAction
    extends MDataAction.Weak<WebBrowser> {
        @Override
        public void onAction() {
            ((WebBrowser)this.get()).back(0);
        }

        private BackAction(WebBrowser webBrowser) {
            super(webBrowser, MActionInfo.BACK);
            this.setEnabled(false);
        }
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }

    public static class History {
        private final HistoryManager<String> historyManager = new HistoryManager();

        public History() {
            this.historyManager.setLimit(100);
        }

        public void addURL(String string) {
            this.historyManager.add(string);
        }

        public boolean back() {
            if (!this.canBack()) {
                return false;
            }
            try {
                this.historyManager.back();
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }

        public boolean canBack() {
            return this.historyManager.canBack();
        }

        public String getCurrentURL() {
            try {
                return this.historyManager.getCurrent();
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }

        private boolean forward() {
            if (!this.historyManager.canForward()) {
                return false;
            }
            try {
                this.historyManager.forward();
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
    }

    public static interface BrowserLauncher {
        public void openURL(URL var1);
    }
}

