/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.beans.PropertyChangeListener;
import java.security.BasicPermission;
import java.text.ParseException;
import org.makagiga.commons.PropertyAccess;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;

public final class SecureProperty<T>
implements PropertyAccess<T> {
    private PropertyAccess<T> impl;

    public SecureProperty(PropertyAccess<T> propertyAccess) {
        this.impl = TK.checkNull(propertyAccess, "property");
    }

    public void checkRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission("read"));
        }
    }

    public void checkWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new Permission("write"));
        }
    }

    public PropertyAccess<T> getProperty() {
        this.checkRead();
        return this.impl;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.checkWrite();
        this.impl.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        this.checkRead();
        return this.impl.getPropertyChangeListeners();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.checkWrite();
        this.impl.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    @Deprecated
    public void clear() {
        this.checkWrite();
        this.impl.clear();
    }

    @Override
    public Object clone() {
        try {
            SecureProperty secureProperty = (SecureProperty)super.clone();
            secureProperty.impl = (PropertyAccess)this.impl.clone();
            return secureProperty;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WTFError(cloneNotSupportedException);
        }
    }

    @Override
    public int compareTo(PropertyAccess<T> propertyAccess) {
        this.checkRead();
        return this.impl.compareTo(propertyAccess);
    }

    @Override
    public boolean equals(Object object) {
        this.checkRead();
        if (object == this) {
            return true;
        }
        return ((Object)this.impl).equals(object);
    }

    @Override
    public T get() {
        this.checkRead();
        return this.impl.get();
    }

    @Override
    public void set(T t) {
        this.checkWrite();
        this.impl.set(t);
    }

    @Override
    public T getDefaultValue() {
        this.checkRead();
        return this.impl.getDefaultValue();
    }

    @Override
    public boolean isDefaultValue() {
        this.checkRead();
        return this.impl.isDefaultValue();
    }

    @Override
    public void setDefaultValue(T t) {
        this.checkWrite();
        this.impl.setDefaultValue(t);
    }

    @Override
    public Class<T> getType() {
        this.checkRead();
        return this.impl.getType();
    }

    @Override
    public int hashCode() {
        this.checkRead();
        return ((Object)this.impl).hashCode();
    }

    @Override
    public boolean isNull() {
        this.checkRead();
        return this.impl.isNull();
    }

    @Override
    public void parse(String string) throws ParseException {
        this.checkWrite();
        this.impl.parse(string);
    }

    @Override
    public void reset() {
        this.checkWrite();
        this.impl.reset();
    }

    @Override
    public String toString() {
        this.checkRead();
        return ((Object)this.impl).toString();
    }

    public static final class Permission
    extends BasicPermission {
        private Permission(String string) {
            super(string);
        }
    }
}

