/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.category;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.Icon;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MObject;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.category.CategoryIcon;

public final class Category
implements Comparable<Category>,
MRenderer.Renderable,
Serializable {
    private static final long serialVersionUID = -7649010919031915926L;
    public static final Color DEFAULT_COLOR = MColor.SKY_BLUE.getBrighter(60);
    private transient boolean noIcon;
    private transient CategoryIcon categoryIcon;
    private Color color;
    private int hash;
    private transient MIcon icon;
    private transient Object data;
    private String iconName;
    private String name;

    public Category(String string) {
        this(string, null, null, null);
    }

    public Category(String string, Color color) {
        this(string, color, null, null);
    }

    public Category(String string, Color color, String string2) {
        this(string, color, string2, null);
    }

    public Category(String string, Color color, String string2, Object object) {
        this.name = Category.validateName(string);
        this.color = color;
        this.iconName = string2;
        this.data = object;
        this.hash = MObject.hashCode(color, string2, string);
    }

    public static String validateName(String string) {
        if (TK.isEmpty(string)) {
            throw new IllegalArgumentException(UI._("Category name cannot be empty"));
        }
        if (string.indexOf(44) != -1) {
            throw new IllegalArgumentException(UI._("Category name cannot contain \"{0}\" character", Character.valueOf(',')));
        }
        return string;
    }

    public boolean equals(Object object) {
        switch (MObject.maybeEquals(this, object)) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        Category category = (Category)object;
        return this.name.equals(category.name) && MObject.safeEquals(this.color, category.color) && MObject.safeEquals(this.iconName, category.iconName);
    }

    public int hashCode() {
        return this.hash;
    }

    public synchronized CategoryIcon getCategoryIcon() {
        if (this.categoryIcon == null) {
            this.categoryIcon = new CategoryIcon(this);
        }
        return this.categoryIcon;
    }

    public Color getColor() {
        return this.color;
    }

    public Object getData() {
        return this.data;
    }

    public synchronized Icon getIcon() {
        if (this.noIcon) {
            return null;
        }
        if (this.icon == null) {
            if (this.iconName == null) {
                this.noIcon = true;
            } else {
                this.icon = MIcon.fromFileURI(this.iconName, MIcon.getSmallSize());
                if (this.icon == null) {
                    this.noIcon = true;
                }
            }
        }
        return this.icon;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Category category) {
        int n = this.name.compareToIgnoreCase(category.name);
        if (n == 0) {
            n = TK.compare(this.color == null ? 0 : this.color.getRGB(), category.color == null ? 0 : category.color.getRGB()) * -1;
        }
        return n;
    }

    @Override
    public void setupRenderer(MRenderer<?> mRenderer) {
        mRenderer.setIcon(this.getCategoryIcon());
        mRenderer.setText(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Category.validateName(this.name);
        Object object = TK.deserialize(objectInputStream, "data");
        if (object != null) {
            this.data = object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        TK.serialize(objectOutputStream, "data", this.data);
    }

    @Deprecated
    public static final class Renderer
    extends MRenderer<Category> {
        public Renderer() {
            super(2);
        }

        @Override
        protected void onRender(Category category) {
            super.onRender(category);
        }
    }
}

