/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.fx;

import java.awt.Component;
import java.awt.Graphics2D;
import java.lang.ref.WeakReference;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.TK;
import org.makagiga.commons.fx.Transition;

public abstract class AbstractTransition
implements Transition {
    protected int duration;
    protected int frames;
    protected MTimer timer;
    private EventListenerList listeners;
    private int frameCount;
    private WeakReference<Component> componentRef;

    public AbstractTransition(Component component, int n, int n2) {
        this.componentRef = TK.newWeakRef(component);
        this.duration = n;
        this.frames = n2;
        this.timer = new MTimer(n / n2){

            @Override
            protected boolean onTimeout() {
                return AbstractTransition.this.doFrame();
            }
        };
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        if (this.listeners == null) {
            return TK.EMPTY_CHANGE_LISTENER_ARRAY;
        }
        return (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(ChangeListener.class, changeListener);
        }
    }

    @Override
    public int getTransitionDuration() {
        return this.duration;
    }

    @Override
    public int getTransitionFrames() {
        return this.frames;
    }

    @Override
    public boolean isTransitionActive() {
        return this.timer.isRunning();
    }

    @Override
    public void paintTransition(Component component, Graphics2D graphics2D) {
        this.paintTransition(component, graphics2D, 0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public void startTransition(Component component) {
        this.timer.start();
        this.fireStateChanged();
        component.repaint();
        this.frameCount = 0;
    }

    @Override
    public void stopTransition(Component component) {
        this.timer.stop();
        this.fireStateChanged();
        component.repaint();
    }

    protected void fireStateChanged() {
        if (this.listeners != null) {
            TK.fireStateChanged(this, this.getChangeListeners());
        }
    }

    private boolean doFrame() {
        if (!this.isTransitionActive()) {
            return false;
        }
        Component component = (Component)this.componentRef.get();
        if (component == null) {
            return false;
        }
        if (this.updateTransitionFrame(component)) {
            ++this.frameCount;
            component.repaint();
            return true;
        }
        this.stopTransition(component);
        return false;
    }
}

