/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.painters;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.AbstractPainter;

public class RoundedBackgroundPainter
extends AbstractPainter {
    private int arc;

    public RoundedBackgroundPainter() {
        this(null, 9, UI.createInsets(0));
    }

    public RoundedBackgroundPainter(Color color) {
        this(color, 9, UI.createInsets(0));
    }

    public RoundedBackgroundPainter(Color color, int n, Insets insets) {
        super(color, TK.checkNull(insets, "insets"));
        this.cache = new AbstractPainter.Cache();
        this.arc = n;
    }

    @Override
    public boolean isOpaque() {
        return this.arc == 0;
    }

    @Override
    public void paint(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.cache.paint(this, component, graphics2D, n, n2, n3, n4)) {
            return;
        }
        Color color = this.getPrimaryColor();
        if (color == null) {
            color = UI.getDarker(component.getBackground(), Color.WHITE);
        }
        graphics2D.setColor(color);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n + this.insets.left, n2 + this.insets.top, n3 - (this.insets.left + this.insets.right), n4 - (this.insets.top + this.insets.bottom), this.arc, this.arc);
        Object object = UI.setAntialiasing(graphics2D, true);
        graphics2D.fill(float_);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

