/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.print;

import java.text.MessageFormat;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDate;
import org.makagiga.commons.TK;
import org.makagiga.commons.print.PrintInfo;

public abstract class AbstractPrintInfo
implements PrintInfo {
    protected String documentTitle;
    protected String footer;
    protected String header;

    public AbstractPrintInfo(String string, String string2, String string3) {
        this.documentTitle = string;
        this.header = string2;
        this.footer = string3;
    }

    public static PrintRequestAttributeSet getPrintRequestAttributeSet(Flags flags) {
        return AbstractPrintInfo.getPrintRequestAttributeSet(flags, null);
    }

    public static String getCurrentDateTime() {
        return MDate.now().formatDateTime(0, 3);
    }

    @Override
    public MessageFormat getPrintHeader(boolean bl) {
        if (!bl || this.header == null) {
            return null;
        }
        return new MessageFormat(this.header);
    }

    @Override
    public MessageFormat getPrintFooter(boolean bl) {
        if (!bl || this.footer == null) {
            return null;
        }
        return new MessageFormat(this.footer);
    }

    @Override
    public int getPrintingCapabilities() {
        int n = 0;
        if (this.header != null) {
            n |= 8;
        }
        if (this.footer != null) {
            n |= 4;
        }
        return n;
    }

    @Override
    public String getPrintTitle() {
        if (this.header == null) {
            return this.documentTitle == null ? "?" : this.documentTitle;
        }
        return this.header;
    }

    static PrintRequestAttributeSet getPrintRequestAttributeSet(Flags flags, String string) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (flags.isSet(16L)) {
            if (flags.isSet(64L)) {
                hashPrintRequestAttributeSet.add(OrientationRequested.REVERSE_LANDSCAPE);
            } else {
                hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            }
        } else if (flags.isSet(32L)) {
            if (flags.isSet(64L)) {
                hashPrintRequestAttributeSet.add(OrientationRequested.REVERSE_PORTRAIT);
            } else {
                hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
            }
        }
        String string2 = MApplication.getFullName();
        if (!TK.isEmpty(string)) {
            string2 = string2 + " - " + string;
        }
        hashPrintRequestAttributeSet.add(new JobName(string2, null));
        return hashPrintRequestAttributeSet;
    }
}

