/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.makagiga.commons.BooleanProperty;
import org.makagiga.commons.ConfigEntry;
import org.makagiga.commons.FS;
import org.makagiga.commons.PropertyAccess;

public final class ScriptExecutor {
    @ConfigEntry(value="Script.user")
    public static final PropertyAccess<Boolean> userScript = new BooleanProperty(true).getSecure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Object execute(File file) throws FileNotFoundException, ScriptException {
        FS.TextReader textReader = null;
        try {
            textReader = FS.getUTF8Reader(file);
            Object object = ScriptExecutor.getEngine(FS.getExtension(file)).eval(textReader);
            return object;
        }
        finally {
            FS.close(textReader);
        }
    }

    public static synchronized Object execute(String string, InputStream inputStream) throws FileNotFoundException, ScriptException {
        return ScriptExecutor.getEngine(string).eval(FS.getUTF8Reader(inputStream));
    }

    public static synchronized Object execute(String string, String string2) throws ScriptException {
        return ScriptExecutor.getEngine(string).eval(string2);
    }

    public static synchronized void executeUserScript() throws ScriptException {
        File file;
        if (userScript.get().booleanValue() && (file = new File(FS.makePath(FS.makeConfigPath("scripts"), "user.js"))).exists()) {
            try {
                ScriptExecutor.execute(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static synchronized ScriptEngine getEngine(String string) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = string == null ? scriptEngineManager.getEngineByName("JavaScript") : scriptEngineManager.getEngineByExtension(string);
        return scriptEngine;
    }

    public static void put(ScriptEngine scriptEngine, String string, Object object) {
        scriptEngine.put(string, object);
    }

    private ScriptExecutor() {
    }
}

