/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.script;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.FS;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.help.HelpContext;
import org.makagiga.commons.script.ScriptError;
import org.makagiga.commons.script.ScriptExecutor;

public final class ScriptIDE
extends MDialog {
    private Editor editor;
    private final File file;
    private ScriptError error;

    public ScriptIDE(Window window, String string, String string2) {
        super(window, (String)null, 327);
        this.changeButton((AbstractButton)this.getOKButton(), MActionInfo.SAVE);
        this.getMainPanel().setMargin(0);
        this.setHelpContext(new HelpContext("makagiga", "http://sourceforge.net/apps/mediawiki/makagiga/index.php?title=Scripting", HelpContext.Type.URI));
        this.setSize(UI.WindowSize.LARGE);
        this.setTitle(UI._("Edit Script: {0}", string2 + " (" + FS.getExtension(string) + ")"));
        this.file = new File(string);
        String string3 = "js".equals(FS.getExtension(this.file)) ? "application/javascript" : null;
        this.editor = new Editor();
        this.addCenter(this.editor);
        if (string3 != null) {
            this.editor.setContentType(string3);
        }
        this.error = new ScriptError(false);
        this.addSouth(this.error);
        try {
            if (this.file.exists()) {
                MText.load((JTextComponent)this.editor, this.file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            MMessage.error(this, iOException, this.file);
        }
        ActionGroup actionGroup = new ActionGroup();
        TestAction testAction = new TestAction();
        this.bind(2, testAction);
        actionGroup.add("test", testAction);
        MToolBar mToolBar = actionGroup.createToolBar();
        mToolBar.addGap();
        mToolBar.addButton(new SnippetsButton());
        this.setToolBar(mToolBar);
        this.exec(this.editor);
    }

    public void save() {
        try {
            this.saveToFile();
        }
        catch (IOException iOException) {
            MMessage.error(this, iOException, this.file);
        }
    }

    @Override
    protected boolean onAccept() {
        try {
            this.saveToFile();
            return true;
        }
        catch (IOException iOException) {
            MMessage.error(this, iOException, this.file);
            return false;
        }
    }

    @Override
    protected void onClose() {
        if (this.editor != null) {
            MText.deinstallKit(this.editor);
            this.editor = null;
        }
        this.error = null;
    }

    @Override
    protected boolean onReject() {
        if (!this.editor.isModified()) {
            return true;
        }
        Object[] objectArray = new Object[]{UI._("Save"), UI._("Do Not Save"), UI._("Cancel")};
        switch (JOptionPane.showOptionDialog(this, UI._("Save changes?"), UI._("Confirm"), 1, 3, null, objectArray, objectArray[0])) {
            case 0: {
                return this.onAccept();
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private MMenu createSnippetsMenu() throws IOException {
        MMenu mMenu = new MMenu();
        MMenu mMenu2 = new MMenu("Dialogs");
        mMenu2.add(new SnippetAction("Modal Dialog", "dialog-modal"));
        mMenu2.add(new SnippetAction("Simple Dialog", "dialog-simple"));
        mMenu.add(mMenu2);
        MMenu mMenu3 = new MMenu("Input");
        mMenu3.add(new SnippetAction("Text Field", "input-text-field"));
        mMenu3.add(new SnippetAction("Text Area", "input-text-area"));
        mMenu3.addSeparator();
        mMenu3.add(new SnippetAction("Password", "ui/password", "password-enter"));
        mMenu.add(mMenu3);
        MMenu mMenu4 = new MMenu("Messages");
        mMenu4.add(new SnippetAction("Error", "ui/error", "message-error"));
        mMenu4.add(new SnippetAction("Information", "ui/info", "message-info"));
        mMenu4.add(new SnippetAction("Warning", "ui/warning", "message-warning"));
        mMenu4.addSeparator();
        mMenu4.add(new SnippetAction("Notification", "ui/info", "notification"));
        mMenu.add(mMenu4);
        MMenu mMenu5 = new MMenu("RSS");
        mMenu5.add(new SnippetAction("RSS Viewer", "ui/feed", "rss-viewer"));
        mMenu.add(mMenu5);
        MMenu mMenu6 = new MMenu("General");
        mMenu6.add(new SnippetAction("Open URL", "general-open-url"));
        mMenu6.add(new SnippetAction("Open URL with parameters", "general-open-url-params"));
        mMenu6.add(new SnippetAction("Quit Application", "ui/quit", "general-quit-application"));
        mMenu6.addTitle("Java Integration");
        mMenu6.add(new SnippetAction("Handling Java Exception", "general-java-exception"));
        mMenu6.add(new SnippetAction("Action Listener", "general-action-listener"));
        mMenu.add(mMenu6);
        mMenu.addSeparator();
        MMenu mMenu7 = new MMenu("Plugin");
        mMenu7.add(new SnippetAction("Get Editor Text", "plugin-get-text"));
        mMenu7.add(new SnippetAction("Get selected text from a Note widget)", "plugin-note-widget"));
        mMenu.add(mMenu7);
        return mMenu;
    }

    private void saveToFile() throws IOException {
        MText.save((JTextComponent)this.editor, this.file);
        this.editor.setModified(false, null);
    }

    private void selectError(ScriptException scriptException) {
        MText.goTo(this.editor, scriptException.getLineNumber(), scriptException.getColumnNumber());
    }

    private void test() {
        this.save();
        try {
            String string = FS.getExtension(this.file);
            String string2 = this.editor.getText();
            Object object = ScriptExecutor.execute(string, string2);
            this.error.showResult(object);
        }
        catch (ScriptException scriptException) {
            this.selectError(scriptException);
            this.error.showError(scriptException);
        }
    }

    private static final class TestAction
    extends MAction {
        @Override
        public void onAction() {
            ScriptIDE scriptIDE = (ScriptIDE)this.getSourceWindow();
            scriptIDE.test();
        }

        private TestAction() {
            super(UI._("Test [{0}]", TK.toString(120, 0)), "ui/misc", 120);
        }
    }

    private static final class SnippetsButton
    extends MButton {
        @Override
        protected MMenu onPopupMenu() {
            ScriptIDE scriptIDE = (ScriptIDE)this.getWindowAncestor();
            try {
                return scriptIDE.createSnippetsMenu();
            }
            catch (IOException iOException) {
                MMessage.error((Window)scriptIDE, iOException);
                return null;
            }
        }

        private SnippetsButton() {
            super("Snippets (JavaScript)", "ui/paste");
            this.setPopupMenuEnabled(true);
        }
    }

    private static final class SnippetAction
    extends MDataAction<String> {
        private static Pattern keywordPattern;

        @Override
        public void onAction() {
            ScriptIDE scriptIDE = (ScriptIDE)this.getSourceWindow();
            MText.insertString(scriptIDE.editor, (String)this.getData());
        }

        private SnippetAction(String string, String string2) throws IOException {
            this(string, (String)null, string2);
        }

        private SnippetAction(String string, String string2, String string3) throws IOException {
            super(FS.read(ScriptIDE.class.getResourceAsStream("js/" + string3 + ".js"), "UTF8"), string, string2);
            this.setHTMLHelp(this.colorize());
        }

        private String colorize() {
            String string = TK.escapeXML((String)this.getData());
            if (keywordPattern == null) {
                keywordPattern = Pattern.compile("\\bcatch|\\bif|\\bimportClass|\\binstanceof|\\bnew|\\bnull|\\btry|\\bvar");
            }
            string = keywordPattern.matcher(string).replaceAll("<b>$0</b>");
            return "<pre>" + string + "</pre>";
        }
    }

    private static final class Editor
    extends MEditorPane {
        private Editor() {
            if (!UI.isRetro()) {
                this.setBackground(MColor.WHITE);
                this.setForeground(MColor.BLACK);
                this.setCaretColor(MColor.BLACK);
                int n = UI.getFont(this).getSize();
                this.setFont(UI.createMonospacedFont(n + 1));
                MText.setupMargin(this);
            }
        }
    }
}

